/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.helpers;

import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.util.EnumFacing;
import sonar.core.api.cabling.ISonarCable;
import sonar.core.api.utils.BlockCoords;

public abstract class CableNetworkHelper {
    private static Map<Integer, ArrayList<BlockCoords>> cables = new THashMap();
    private static Map<Integer, ArrayList<BlockCoords>> connections = new THashMap();

    private static void removeAll() {
        cables.clear();
        connections.clear();
    }

    public void addCable(ISonarCable cable) {
        cables.putIfAbsent(cable.registryID(), new ArrayList());
        this.addCoordsToArray(cable.getCoords(), cables.get(cable.registryID()));
        for (EnumFacing face : EnumFacing.field_82609_l) {
            BlockCoords coords = BlockCoords.translateCoords(cable.getCoords(), face);
            if (!this.checkConnection(coords)) continue;
            this.addCoordsToArray(coords, connections.get(cable.registryID()));
        }
    }

    public void removeCable(ISonarCable cable) {
        for (EnumFacing face : EnumFacing.field_82609_l) {
            BlockCoords coords = BlockCoords.translateCoords(cable.getCoords(), face);
            if (!this.checkConnection(coords)) continue;
            this.removeCoordsFromArray(coords, connections.get(cable.registryID()));
        }
        this.removeCoordsFromArray(cable.getCoords(), cables.get(cable.registryID()));
    }

    public void addCoordsToArray(BlockCoords coords, ArrayList<BlockCoords> array) {
        for (BlockCoords coord : (ArrayList)array.clone()) {
            if (!coord.equals(coords)) continue;
            return;
        }
    }

    public void removeCoordsFromArray(BlockCoords coords, ArrayList<BlockCoords> array) {
        ArrayList<BlockCoords> toRemove = new ArrayList<BlockCoords>();
        for (BlockCoords coord : (ArrayList)array.clone()) {
            if (!coord.equals(coords)) continue;
            toRemove.add(coord);
        }
        array.removeAll(toRemove);
    }

    public static ArrayList<BlockCoords> getCables(int registryID) {
        return cables.get(registryID) == null ? new ArrayList<BlockCoords>() : cables.get(registryID);
    }

    public static ArrayList<BlockCoords> getConnections(int registryID) {
        return connections.get(registryID) == null ? new ArrayList<BlockCoords>() : connections.get(registryID);
    }

    public abstract boolean checkConnection(BlockCoords var1);
}

