/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.handlers.inventories;

import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import sonar.core.api.SonarAPI;
import sonar.core.api.StorageSize;
import sonar.core.api.asm.InventoryHandler;
import sonar.core.api.inventories.ISonarInventoryHandler;
import sonar.core.api.inventories.StoredItemStack;
import sonar.core.api.utils.ActionType;
import sonar.core.inventory.ILargeInventory;
import sonar.core.inventory.SonarLargeInventory;

@InventoryHandler(modid="sonarcore", priority=0)
public class ILargeInventoryHandler
implements ISonarInventoryHandler {
    @Override
    public boolean canHandleItems(TileEntity tile, EnumFacing dir) {
        return tile instanceof ILargeInventory;
    }

    @Override
    public StoredItemStack getStack(int slot, TileEntity tile, EnumFacing dir) {
        SonarLargeInventory inv = ((ILargeInventory)tile).getTileInv();
        return inv.getLargeStack(slot);
    }

    @Override
    public StorageSize getItems(List<StoredItemStack> storedStacks, TileEntity tile, EnumFacing dir) {
        SonarLargeInventory inv = ((ILargeInventory)tile).getTileInv();
        long max = inv.getSlots() * inv.limit;
        long stored = 0L;
        for (StoredItemStack stack : inv.slots) {
            if (stack == null) continue;
            SonarAPI.getItemHelper().addStackToList(storedStacks, stack.copy());
            stored += stack.stored;
        }
        return new StorageSize(stored, max);
    }

    @Override
    public StoredItemStack addStack(StoredItemStack add, TileEntity tile, EnumFacing dir, ActionType action) {
        SonarLargeInventory inv = ((ILargeInventory)tile).getTileInv();
        for (int i = 0; i < inv.getSlots(); ++i) {
            if (add == null || add.stored == 0L) {
                return null;
            }
            ItemStack stack = inv.insertItem(i, add.getFullStack(), action.shouldSimulate());
            if (!stack.func_190926_b() && add.stored != 0L) {
                add.remove(SonarAPI.getItemHelper().getStackToAdd(add.stored, add, new StoredItemStack(stack)));
                continue;
            }
            add.stored -= (long)add.getFullStack().func_190916_E();
        }
        return add;
    }

    @Override
    public StoredItemStack removeStack(StoredItemStack remove, TileEntity tile, EnumFacing dir, ActionType action) {
        SonarLargeInventory inv = ((ILargeInventory)tile).getTileInv();
        for (int i = 0; i < inv.getSlots(); ++i) {
            int removeSize;
            ItemStack stack;
            if (remove == null || remove.stored == 0L) {
                return null;
            }
            ItemStack current = inv.getStackInSlot(i);
            if (current.func_190926_b() || !remove.equalStack(current) || (stack = inv.extractItem(i, removeSize = (int)Math.min((long)current.func_190916_E(), remove.getStackSize()), action.shouldSimulate())).func_190926_b()) continue;
            remove.remove(new StoredItemStack(stack));
        }
        return remove;
    }

    @Override
    public boolean isLargeInventory() {
        return false;
    }
}

