/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.common.tileentity;

import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import sonar.core.SonarCore;
import sonar.core.api.nbt.INBTSyncable;
import sonar.core.api.utils.BlockCoords;
import sonar.core.helpers.NBTHelper;
import sonar.core.integration.IWailaInfo;
import sonar.core.inventory.ISonarInventoryTile;
import sonar.core.network.PacketRequestSync;
import sonar.core.network.PacketTileSync;
import sonar.core.network.sync.IDirtyPart;
import sonar.core.network.sync.ISyncableListener;
import sonar.core.network.sync.SyncableList;
import sonar.core.utils.IWorldPosition;

public class TileEntitySonar
extends TileEntity
implements ISyncableListener,
ITickable,
INBTSyncable,
IWailaInfo,
IWorldPosition {
    public SyncableList syncList = new SyncableList(this);
    protected boolean forceSync;
    protected BlockCoords coords = BlockCoords.EMPTY;
    public boolean loaded = true;
    public boolean isDirty;

    public boolean isClient() {
        return this.func_145831_w() != null && this.func_145831_w().field_72995_K;
    }

    public boolean isServer() {
        return this.func_145831_w() == null || !this.func_145831_w().field_72995_K;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (CapabilityItemHandler.ITEM_HANDLER_CAPABILITY == capability && this instanceof ISonarInventoryTile) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (CapabilityItemHandler.ITEM_HANDLER_CAPABILITY == capability && this instanceof ISonarInventoryTile) {
            return (T)((ISonarInventoryTile)((Object)this)).inv().getItemHandler(facing);
        }
        return (T)super.getCapability(capability, facing);
    }

    public void onFirstTick() {
    }

    @Override
    public BlockCoords getCoords() {
        if (this.coords == BlockCoords.EMPTY) {
            this.coords = new BlockCoords(this);
        }
        return this.coords;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.readData(nbt, NBTHelper.SyncType.SAVE);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        this.writeData(nbt, NBTHelper.SyncType.SAVE);
        return nbt;
    }

    public NBTHelper.SyncType getUpdateTagType() {
        return NBTHelper.SyncType.SYNC_OVERRIDE;
    }

    public NBTTagCompound func_189517_E_() {
        return this.writeData(super.func_189517_E_(), this.getUpdateTagType());
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        super.handleUpdateTag(tag);
        this.readData(tag, this.getUpdateTagType());
    }

    public final SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = this.func_189515_b(new NBTTagCompound());
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, tag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public void func_145829_t() {
        super.func_145829_t();
        this.coords = new BlockCoords(this);
    }

    @Override
    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        NBTHelper.readSyncParts(nbt, type, this.syncList);
    }

    @Override
    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        if (this.forceSync && type == NBTHelper.SyncType.DEFAULT_SYNC) {
            type = NBTHelper.SyncType.SYNC_OVERRIDE;
            this.forceSync = false;
        }
        NBTHelper.writeSyncParts(nbt, type, this.syncList, this.forceSync);
        return nbt;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<String> getWailaInfo(List<String> currenttip, IBlockState state) {
        return currenttip;
    }

    public void forceNextSync() {
        this.forceSync = true;
        this.func_70296_d();
    }

    public void onSyncPacketRequested(EntityPlayer player) {
    }

    public void requestSyncPacket() {
        SonarCore.network.sendToServer((IMessage)new PacketRequestSync(this.field_174879_c));
    }

    public void sendSyncPacket(EntityPlayer player) {
        this.sendSyncPacket(player, NBTHelper.SyncType.SYNC_OVERRIDE);
    }

    public void sendSyncPacket(EntityPlayer player, NBTHelper.SyncType type) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (player != null && player instanceof EntityPlayerMP) {
            NBTTagCompound tag = new NBTTagCompound();
            this.writeData(tag, type);
            if (!tag.func_82582_d()) {
                SonarCore.network.sendTo(this.createSyncPacket(tag, type), (EntityPlayerMP)player);
            }
        }
    }

    public IMessage createRequestPacket() {
        return new PacketRequestSync(this.field_174879_c);
    }

    public IMessage createSyncPacket(NBTTagCompound tag, NBTHelper.SyncType type) {
        return new PacketTileSync(this.field_174879_c, tag, type);
    }

    public void markBlockForUpdate() {
        if (this.isServer()) {
            this.func_70296_d();
            SonarCore.sendFullSyncAroundWithRenderUpdate(this, 128);
        } else {
            this.func_145831_w().func_175704_b(this.field_174879_c, this.field_174879_c);
            this.func_145831_w().func_175726_f(this.func_174877_v()).func_177427_f(true);
        }
    }

    public boolean maxRender() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return this.maxRender() ? 65536.0 : super.func_145833_n();
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return this.maxRender() ? INFINITE_EXTENT_AABB : super.getRenderBoundingBox();
    }

    @Override
    public void markChanged(IDirtyPart part) {
        if (this.isServer()) {
            this.syncList.markSyncPartChanged(part);
            this.isDirty = true;
        }
    }

    public void func_73660_a() {
        if (this.loaded) {
            this.onFirstTick();
            boolean bl = this.loaded = !this.loaded;
        }
        if (this.isDirty) {
            this.func_70296_d();
            this.isDirty = !this.isDirty;
        }
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }
}

