/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.common.block;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import sonar.core.SonarCore;
import sonar.core.api.blocks.IInteractBlock;
import sonar.core.api.blocks.IWrenchable;
import sonar.core.api.nbt.INBTSyncable;
import sonar.core.api.utils.BlockInteraction;
import sonar.core.api.utils.BlockInteractionType;
import sonar.core.common.block.properties.IBlockRotated;
import sonar.core.common.tileentity.TileEntitySonar;
import sonar.core.helpers.InventoryHelper;
import sonar.core.helpers.NBTHelper;
import sonar.core.network.PacketBlockInteraction;

public abstract class SonarBlock
extends Block
implements IWrenchable,
IInteractBlock,
IBlockRotated {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public boolean orientation = true;
    public boolean wrenchable = true;
    public AxisAlignedBB customBB;

    protected SonarBlock(Material material, boolean orientation, boolean wrenchable) {
        super(material);
        this.orientation = orientation;
        this.wrenchable = wrenchable;
        this.field_149783_u = true;
        if (orientation) {
            this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (player != null) {
            TileEntity target = world.func_175625_s(pos);
            if (target != null && target instanceof TileEntitySonar) {
                ((TileEntitySonar)target).forceNextSync();
            }
            return this.operateBlock(world, pos, state, player, hand, new BlockInteraction(side.func_176745_a(), hitX, hitY, hitZ, player.func_70093_af() ? BlockInteractionType.SHIFT_RIGHT : BlockInteractionType.RIGHT));
        }
        return false;
    }

    @Override
    public boolean isClickableSide(World world, BlockPos pos, int side) {
        return false;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (willHarvest) {
            if (world.field_72995_K && this.allowLeftClick()) {
                RayTraceResult posn = Minecraft.func_71410_x().field_71476_x;
                if (this.isClickableSide(world, pos, posn.field_178784_b.func_176745_a())) {
                    this.func_180649_a(world, pos, player);
                    return false;
                }
            }
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public abstract boolean dropStandard(IBlockAccess var1, BlockPos var2);

    @Override
    public abstract boolean operateBlock(World var1, BlockPos var2, IBlockState var3, EntityPlayer var4, EnumHand var5, BlockInteraction var6);

    @Override
    public boolean allowLeftClick() {
        return false;
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        if (world.field_72995_K && this.allowLeftClick()) {
            RayTraceResult movingPos = Minecraft.func_71410_x().field_71476_x;
            float hitX = (float)(movingPos.field_72307_f.field_72450_a - (double)movingPos.field_178784_b.func_82601_c());
            float hitY = (float)(movingPos.field_72307_f.field_72448_b - (double)movingPos.field_178784_b.func_96559_d());
            float hitZ = (float)(movingPos.field_72307_f.field_72449_c - (double)movingPos.field_178784_b.func_82599_e());
            SonarCore.network.sendToServer((IMessage)new PacketBlockInteraction(pos, new BlockInteraction(movingPos.field_178784_b.func_176745_a(), hitX, hitY, hitZ, player.func_70093_af() ? BlockInteractionType.SHIFT_LEFT : BlockInteractionType.LEFT)));
        }
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, @Nullable ItemStack stack) {
        super.func_180657_a(world, player, pos, state, te, stack);
        world.func_175698_g(pos);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        super.getDrops(world, pos, state, fortune);
        if (this.dropStandard(world, pos)) {
            return super.getDrops(world, pos, state, fortune);
        }
        return Lists.newArrayList((Object[])new ItemStack[]{this.getSpecialDrop(world, pos)});
    }

    public final ItemStack getSpecialDrop(IBlockAccess world, BlockPos pos) {
        TileEntity target = world.func_175625_s(pos);
        if (target != null && target instanceof INBTSyncable) {
            ItemStack itemStack = new ItemStack((Block)this, 1);
            this.processDrop(world, pos, (INBTSyncable)target, itemStack);
            return itemStack;
        }
        ItemStack itemStack = new ItemStack((Block)this, 1);
        this.processDrop(world, pos, null, itemStack);
        return itemStack;
    }

    public void processDrop(IBlockAccess world, BlockPos pos, INBTSyncable te, ItemStack drop) {
        if (te != null) {
            INBTSyncable handler = te;
            NBTTagCompound tag = new NBTTagCompound();
            handler.writeData(tag, NBTHelper.SyncType.DROP);
            if (!tag.func_82582_d()) {
                tag.func_74757_a("dropped", true);
                drop.func_77982_d(tag);
            }
        }
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        if (this.orientation) {
            this.setDefaultFacing(world, pos, state);
        }
    }

    protected void setDefaultFacing(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K) {
            IBlockState block = worldIn.func_180495_p(pos.func_177978_c());
            IBlockState block1 = worldIn.func_180495_p(pos.func_177968_d());
            IBlockState block2 = worldIn.func_180495_p(pos.func_177976_e());
            IBlockState block3 = worldIn.func_180495_p(pos.func_177974_f());
            EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            if (enumfacing == EnumFacing.NORTH && block.func_185913_b() && !block1.func_185913_b()) {
                enumfacing = EnumFacing.SOUTH;
            } else if (enumfacing == EnumFacing.SOUTH && block1.func_185913_b() && !block.func_185913_b()) {
                enumfacing = EnumFacing.NORTH;
            } else if (enumfacing == EnumFacing.WEST && block2.func_185913_b() && !block3.func_185913_b()) {
                enumfacing = EnumFacing.EAST;
            } else if (enumfacing == EnumFacing.EAST && block3.func_185913_b() && !block2.func_185913_b()) {
                enumfacing = EnumFacing.WEST;
            }
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)enumfacing), 2);
        }
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase player, ItemStack itemstack) {
        TileEntity entity;
        if (this.orientation) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)player.func_174811_aO().func_176734_d()), 2);
        }
        if (itemstack.func_77942_o() && (entity = world.func_175625_s(pos)) != null && entity instanceof INBTSyncable) {
            INBTSyncable handler = (INBTSyncable)entity;
            handler.readData(itemstack.func_77978_p(), NBTHelper.SyncType.DROP);
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        InventoryHelper.dropInventory(world.func_175625_s(pos), world, pos, state);
        super.func_180663_b(world, pos, state);
    }

    @Override
    public ArrayList<ItemStack> wrenchBlock(EntityPlayer player, World world, BlockPos pos, boolean returnDrops) {
        ItemStack stack = player.func_184614_ca();
        TileEntity te = world.func_175625_s(pos);
        world.func_180495_p(pos).func_177230_c().func_180657_a(world, player, pos, world.func_180495_p(pos), te, stack);
        return null;
    }

    @Override
    public boolean canWrench(EntityPlayer player, World world, BlockPos pos) {
        return true;
    }

    public boolean hasSpecialRenderer() {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return !this.hasSpecialRenderer();
    }

    public boolean func_149721_r(IBlockState state) {
        return !this.hasSpecialRenderer();
    }

    public boolean func_149686_d(IBlockState state) {
        return !this.hasSpecialRenderer();
    }

    public void setBlockBounds(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        this.customBB = new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public AxisAlignedBB getCollisionBoundingBox(IBlockState blockState, World worldIn, BlockPos pos) {
        return blockState.func_185900_c((IBlockAccess)worldIn, pos);
    }

    @Deprecated
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (this.customBB != null) {
            return this.customBB;
        }
        return super.func_185496_a(state, world, pos);
    }

    public boolean hasSpecialCollisionBox() {
        return false;
    }

    @Deprecated
    @SideOnly(value=Side.CLIENT)
    public IBlockState getStateForEntityRender(IBlockState state) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.SOUTH);
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    @Override
    public EnumFacing getRotation(IBlockState state) {
        if (this.orientation) {
            return (EnumFacing)state.func_177229_b((IProperty)FACING);
        }
        return EnumFacing.NORTH;
    }
}

