/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.common.block;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import sonar.core.api.blocks.IConnectedBlock;
import sonar.core.api.blocks.IStableBlock;

public class ConnectedBlock
extends Block
implements IConnectedBlock,
IStableBlock {
    public int target;
    public static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    public static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    public static final PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    public static final PropertyBool WEST = PropertyBool.func_177716_a((String)"west");
    public static final PropertyBool DOWN = PropertyBool.func_177716_a((String)"down");
    public static final PropertyBool UP = PropertyBool.func_177716_a((String)"up");

    public ConnectedBlock(Material material, int target) {
        super(material);
        this.target = target;
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(false)));
    }

    public boolean checkBlockInDirection(IBlockAccess world, int x, int y, int z, EnumFacing side) {
        EnumFacing dir = side;
        IBlockState state = world.func_180495_p(new BlockPos(x, y, z));
        IBlockState block = world.func_180495_p(new BlockPos(x + dir.func_82601_c(), y + dir.func_96559_d(), z + dir.func_82599_e()));
        int meta = state.func_177230_c().func_176201_c(state);
        return block != null && ConnectedBlock.type(state, block, meta, block.func_177230_c().func_176201_c(block));
    }

    public static boolean type(IBlockState state1, IBlockState state2, int m1, int m2) {
        Block block1 = state1.func_177230_c();
        Block block2 = state2.func_177230_c();
        if (!(block1 instanceof IConnectedBlock && block2 instanceof IConnectedBlock && m1 != m2 || !(block1 instanceof IConnectedBlock))) {
            IConnectedBlock c1 = (IConnectedBlock)block1;
            int[] connections1 = ((IConnectedBlock)block1).getConnections();
            if (block2 instanceof IConnectedBlock) {
                int[] connections2 = ((IConnectedBlock)block2).getConnections();
                for (int aConnections1 : connections1) {
                    for (int aConnections2 : connections2) {
                        if (aConnections1 != aConnections2) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess w, BlockPos pos) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        return state.func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(this.checkBlockInDirection(w, x, y, z, EnumFacing.NORTH))).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(this.checkBlockInDirection(w, x, y, z, EnumFacing.SOUTH))).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(this.checkBlockInDirection(w, x, y, z, EnumFacing.WEST))).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(this.checkBlockInDirection(w, x, y, z, EnumFacing.EAST))).func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(this.checkBlockInDirection(w, x, y, z, EnumFacing.UP))).func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(this.checkBlockInDirection(w, x, y, z, EnumFacing.DOWN)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{NORTH, EAST, SOUTH, WEST, DOWN, UP});
    }

    @Override
    public int[] getConnections() {
        return new int[]{this.target};
    }

    public static class Glass
    extends ConnectedBlock {
        public Glass(Material material, int target) {
            super(material, target);
        }

        public BlockRenderLayer func_180664_k() {
            return BlockRenderLayer.TRANSLUCENT;
        }

        public EnumBlockRenderType func_149645_b(IBlockState state) {
            return EnumBlockRenderType.MODEL;
        }

        public boolean func_149686_d(IBlockState state) {
            return false;
        }

        public boolean func_149662_c(IBlockState state) {
            return false;
        }

        @SideOnly(value=Side.CLIENT)
        public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
            IBlockState iblockstate = blockAccess.func_180495_p(pos.func_177972_a(side));
            Block block = iblockstate.func_177230_c();
            return block != this && super.func_176225_a(blockState, blockAccess, pos, side);
        }
    }
}

