/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.client.renderers;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.vecmath.Matrix4f;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.opengl.GL11;
import sonar.core.client.renderers.ISonarCustomRenderer;
import sonar.core.client.renderers.ISonarModelRenderer;
import sonar.core.client.renderers.ModelTechne;
import sonar.core.client.renderers.TransformationMatrix;
import sonar.core.common.block.properties.IBlockRotated;
import sonar.core.helpers.RenderHelper;

@SideOnly(value=Side.CLIENT)
@MethodsReturnNonnullByDefault
public class BlockRenderer<T extends TileEntity>
extends TileEntitySpecialRenderer<T>
implements IModel {
    private final ISonarCustomRenderer renderer;

    public BlockRenderer(ISonarCustomRenderer renderer) {
        this.renderer = renderer;
    }

    public Collection<ResourceLocation> getDependencies() {
        return Collections.emptyList();
    }

    public Collection<ResourceLocation> getTextures() {
        return this.renderer.getAllTextures();
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        return new BakedBlockModel(format, this.renderer, bakedTextureGetter, true);
    }

    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }

    @ParametersAreNonnullByDefault
    public void func_192841_a(TileEntity te, double x, double y, double z, float partialTicks, int destroyStage, float f) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        World world = te.func_145831_w();
        BlockPos pos = te.func_174877_v();
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        IBlockState extendedState = block.getExtendedState(state, (IBlockAccess)world, pos);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        vertexbuffer.func_181669_b(255, 255, 255, 255);
        tessellator.func_78381_a();
        GL11.glTranslated((double)(-x), (double)(-y), (double)(-z));
        GL11.glPopMatrix();
    }

    public static class BakedItemModel<T extends TileEntity>
    implements IBakedModel {
        private final ISonarCustomRenderer renderer;
        private final Block block;
        private final T tile;
        private final ItemStack stack;
        private final World world;
        private final EntityLivingBase entity;
        private ItemCameraTransforms.TransformType transformType;
        private final VertexFormat format;
        private final Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter;

        private BakedItemModel(World world, Block block, T tile, ItemStack stack, EntityLivingBase entity, ISonarCustomRenderer renderer, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
            this.world = world;
            this.block = block;
            this.tile = tile;
            this.stack = stack;
            this.entity = entity;
            this.renderer = renderer;
            this.transformType = ItemCameraTransforms.TransformType.NONE;
            this.format = format;
            this.bakedTextureGetter = bakedTextureGetter;
        }

        private BakedItemModel<T> setTransformType(ItemCameraTransforms.TransformType type) {
            this.transformType = type;
            return this;
        }

        public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
            Object list;
            if (side == null) {
                ModelTechne model = ((ISonarModelRenderer)this.renderer).getModel();
                TextureAtlasSprite sprite = (TextureAtlasSprite)ModelLoader.defaultTextureGetter().apply(this.renderer.getAllTextures().get(0));
                list = model.getBakedQuads(this.format, sprite, 1.0);
                if (this.transformType == ItemCameraTransforms.TransformType.GUI) {
                    list = RenderHelper.transformQuads(RenderHelper.transformQuads((List<BakedQuad>)list, new TransformationMatrix(45.0, 0.0, 1.0, 0.0)), new TransformationMatrix(30.0, 1.0, 0.0, 0.0));
                }
            } else {
                list = ImmutableList.of();
            }
            return list;
        }

        public boolean func_177555_b() {
            return false;
        }

        public boolean func_177556_c() {
            return true;
        }

        public boolean func_188618_c() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return Minecraft.func_71410_x().func_147117_R().func_174944_f();
        }

        public ItemCameraTransforms func_177552_f() {
            return ItemCameraTransforms.field_178357_a;
        }

        public ItemOverrideList func_188617_f() {
            return ItemOverrideList.field_188022_a;
        }

        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
            return new ImmutablePair(this.setTransformType(cameraTransformType), null);
        }

        /* synthetic */ BakedItemModel(World x0, Block x1, TileEntity x2, ItemStack x3, EntityLivingBase x4, ISonarCustomRenderer x5, VertexFormat x6, Function x7, 1 x8) {
            this(x0, x1, x2, x3, x4, x5, x6, x7);
        }
    }

    public static class ItemRenderer<T extends TileEntity>
    extends ItemOverrideList {
        private final ISonarCustomRenderer renderer;
        private final Block block;
        private final T tile;
        private final VertexFormat format;
        private final Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter;

        public ItemRenderer(ISonarCustomRenderer renderer, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
            super((List)ImmutableList.of());
            this.renderer = renderer;
            this.tile = null;
            this.block = renderer.getBlock();
            this.format = format;
            this.bakedTextureGetter = bakedTextureGetter;
        }

        @ParametersAreNonnullByDefault
        public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
            return new BakedItemModel(world, this.block, (TileEntity)this.tile, stack, entity, this.renderer, this.format, this.bakedTextureGetter, null);
        }
    }

    public static class BakedBlockModel<T extends TileEntity>
    implements IBakedModel {
        private final VertexFormat format;
        private final ISonarCustomRenderer renderer;
        private final Function<ResourceLocation, TextureAtlasSprite> textures;
        private final ItemRenderer itemRenderer;

        private BakedBlockModel(VertexFormat format, ISonarCustomRenderer renderer, Function<ResourceLocation, TextureAtlasSprite> textures, boolean inventory) {
            this.format = format;
            this.renderer = renderer;
            this.textures = textures;
            this.itemRenderer = inventory ? new ItemRenderer(this.renderer, format, textures) : null;
        }

        public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
            Object list;
            if (side == null && this.renderer instanceof ISonarModelRenderer) {
                ModelTechne model = ((ISonarModelRenderer)this.renderer).getModel();
                TextureAtlasSprite sprite = (TextureAtlasSprite)ModelLoader.defaultTextureGetter().apply(this.renderer.getAllTextures().get(0));
                list = model.getBakedQuads(this.format, sprite, 1.0);
                EnumFacing face = EnumFacing.NORTH;
                if (state.func_177230_c() instanceof IBlockRotated) {
                    face = ((IBlockRotated)state.func_177230_c()).getRotation(state);
                }
                list = face == EnumFacing.UP ? RenderHelper.transformQuads((List<BakedQuad>)list, new TransformationMatrix(-90.0, 1.0, 0.0, 0.0, RenderHelper.getOffsetForFace(face))) : (face == EnumFacing.DOWN ? RenderHelper.transformQuads((List<BakedQuad>)list, new TransformationMatrix(90.0, 1.0, 0.0, 0.0, RenderHelper.getOffsetForFace(face))) : RenderHelper.transformQuads((List<BakedQuad>)list, new TransformationMatrix(-face.func_185119_l(), 0.0, 1.0, 0.0, RenderHelper.getOffsetForFace(face))));
            } else {
                list = ImmutableList.of();
            }
            return list;
        }

        public boolean func_177555_b() {
            return false;
        }

        public boolean func_177556_c() {
            return true;
        }

        public boolean func_188618_c() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return this.renderer.getIcon();
        }

        public ItemCameraTransforms func_177552_f() {
            return ItemCameraTransforms.field_178357_a;
        }

        public ItemOverrideList func_188617_f() {
            return this.itemRenderer;
        }
    }
}

