/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.client.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import sonar.core.api.machines.IPausable;
import sonar.core.api.machines.IProcessMachine;
import sonar.core.client.gui.GuiSonarTile;
import sonar.core.client.gui.SonarButtons;
import sonar.core.client.gui.SonarTextField;
import sonar.core.helpers.FontHelper;
import sonar.core.helpers.RenderHelper;
import sonar.core.upgrades.UpgradeInventory;

public abstract class GuiSonar
extends GuiContainer {
    protected List<SonarTextField> fieldList = new ArrayList<SonarTextField>();
    public boolean shouldReset = false;

    public GuiSonar(Container container) {
        super(container);
    }

    public void onButtonClicked(int i) {
    }

    public abstract ResourceLocation getBackground();

    public void reset() {
        this.shouldReset = true;
    }

    public void doReset() {
        this.field_146292_n.clear();
        this.fieldList.clear();
        this.func_73866_w_();
        this.shouldReset = false;
    }

    public void initButtons() {
        this.field_146292_n.clear();
    }

    public void setZLevel(float zLevel) {
        this.field_73735_i = zLevel;
    }

    public SonarTextField getFocusedField() {
        for (SonarTextField f : this.fieldList) {
            if (!f.func_146206_l()) continue;
            return f;
        }
        return null;
    }

    public void drawNormalToolTip(ItemStack stack, int x, int y) {
        GL11.glDisable((int)2929);
        GL11.glDisable((int)2896);
        this.func_146285_a(stack, x - this.field_147003_i, y - this.field_147009_r);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
        net.minecraft.client.renderer.RenderHelper.func_74520_c();
    }

    public void drawSpecialToolTip(List<String> list, int x, int y, FontRenderer font) {
        GL11.glDisable((int)2929);
        GL11.glDisable((int)2896);
        this.drawHoveringText(list, x - this.field_147003_i, y - this.field_147009_r, font == null ? this.field_146289_q : font);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
        net.minecraft.client.renderer.RenderHelper.func_74520_c();
    }

    public static void drawTransparentRect(int left, int top, int right, int bottom, int color) {
        if (left < right) {
            int i = left;
            left = right;
            right = i;
        }
        if (top < bottom) {
            int j = top;
            top = bottom;
            bottom = j;
        }
        float f3 = (float)(color >> 24 & 0xFF) / 255.0f;
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        RenderHelper.saveBlendState();
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)f, (float)f1, (float)f2, (float)f3);
        GlStateManager.func_179090_x();
        GlStateManager.func_179120_a((int)770, (int)1, (int)1, (int)0);
        GlStateManager.func_179131_c((float)f, (float)f1, (float)f2, (float)f3);
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        vertexbuffer.func_181662_b((double)left, (double)bottom, 0.0).func_181675_d();
        vertexbuffer.func_181662_b((double)right, (double)bottom, 0.0).func_181675_d();
        vertexbuffer.func_181662_b((double)right, (double)top, 0.0).func_181675_d();
        vertexbuffer.func_181662_b((double)left, (double)top, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
        RenderHelper.restoreBlendState();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        if (this.shouldReset) {
            this.doReset();
        }
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_146979_b(int x, int y) {
        super.func_146979_b(x, y);
        this.fieldList.forEach(SonarTextField::func_146194_f);
        net.minecraft.client.renderer.RenderHelper.func_74518_a();
        for (GuiButton guibutton : this.field_146292_n) {
            if (!guibutton.func_146115_a()) continue;
            guibutton.func_146111_b(x - this.field_147003_i, y - this.field_147009_r);
            break;
        }
        net.minecraft.client.renderer.RenderHelper.func_74520_c();
    }

    protected void func_146976_a(float v, int i, int i1) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.getBackground());
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    public void bindTexture(ResourceLocation resource) {
        this.field_146297_k.func_110434_K().func_110577_a(resource);
    }

    public void drawSonarCreativeTabHoveringText(String tabName, int mouseX, int mouseY) {
        this.func_146279_a(tabName, mouseX, mouseY);
    }

    protected void func_73869_a(char c, int i) throws IOException {
        for (SonarTextField field : this.fieldList) {
            if (!field.func_146206_l()) continue;
            if (c == '\r' || c == '\u001b') {
                field.func_146195_b(false);
            } else {
                field.func_146201_a(c, i);
                this.onTextFieldChanged(field);
            }
            return;
        }
        super.func_73869_a(c, i);
    }

    public boolean isCloseKey(int keyCode) {
        return keyCode == 1 || this.field_146297_k.field_71474_y.field_151445_Q.isActiveAndMatches(keyCode);
    }

    public void onTextFieldChanged(SonarTextField field) {
    }

    public void func_73864_a(int i, int j, int k) throws IOException {
        super.func_73864_a(i, j, k);
        this.fieldList.forEach(field -> field.func_146192_a(i - this.field_147003_i, j - this.field_147009_r, k));
    }

    public int getGuiLeft() {
        return this.field_147003_i;
    }

    public int getGuiTop() {
        return this.field_147009_r;
    }

    @SideOnly(value=Side.CLIENT)
    public class CircuitButton
    extends SonarButtons.ImageButton {
        public int field_146127_k;
        public UpgradeInventory upgrades;
        public GuiSonarTile gui;

        public CircuitButton(GuiSonarTile gui, UpgradeInventory upgrades, int id, int x, int y) {
            super(id, x, y, new ResourceLocation("Calculator:textures/gui/buttons/buttons.png"), 0, 0, 16, 16);
            this.gui = gui;
            this.upgrades = upgrades;
            this.field_146127_k = id;
        }

        public void func_146111_b(int x, int y) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(TextFormatting.BLUE + "" + TextFormatting.UNDERLINE + FontHelper.translate("buttons.circuits"));
            for (Map.Entry entry : this.upgrades.getInstalledUpgrades().entrySet()) {
                int max = (Integer)this.upgrades.maxUpgrades.get(entry.getKey());
                list.add(((String)entry.getKey()).substring(0, 1).toUpperCase() + ((String)entry.getKey()).toLowerCase().substring(1) + ": " + entry.getValue() + '/' + max);
            }
            GuiSonar.this.drawHoveringText(list, x, y, GuiSonar.this.field_146289_q);
        }

        @Override
        public void onClicked() {
            this.gui.onButtonClicked(this.field_146127_k);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class PauseButton
    extends SonarButtons.ImageButton {
        boolean paused;
        public int field_146127_k;
        public IPausable machine;
        public GuiSonarTile gui;

        public PauseButton(GuiSonarTile gui, IPausable machine, int id, int x, int y, boolean paused) {
            super(id, x, y, new ResourceLocation("Calculator:textures/gui/buttons/buttons.png"), paused ? 51 : 34, 0, 16, 16);
            this.gui = gui;
            this.paused = paused;
            this.field_146127_k = id;
            this.machine = machine;
        }

        public void func_146111_b(int x, int y) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(TextFormatting.BLUE + "" + TextFormatting.UNDERLINE + (this.paused ? FontHelper.translate("buttons.resume") : FontHelper.translate("buttons.pause")));
            if (this.machine instanceof IProcessMachine) {
                list.add("Current: " + (int)((double)((IProcessMachine)((Object)this.machine)).getCurrentProcessTime() / (double)((IProcessMachine)((Object)this.machine)).getProcessTime() * 100.0) + " %");
            }
            ((GuiSonar)this.gui).drawHoveringText(list, x, y, ((GuiSonar)this.gui).field_146289_q);
        }

        @Override
        public void onClicked() {
            this.gui.onButtonClicked(this.field_146127_k);
            ((GuiSonar)this.gui).field_146292_n.clear();
            this.gui.func_73866_w_();
        }
    }
}

