/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.client.gui;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import sonar.core.client.gui.GuiSonar;
import sonar.core.utils.Pair;

public abstract class GuiGridElement<T> {
    public List<T> gridList = new ArrayList<T>();
    public int yPos;
    public int xPos;
    public int eWidth;
    public int eHeight;
    public int gWidth;
    public int gHeight;
    public int gridID;

    public GuiGridElement(int gridID, int xPos, int yPos, int eWidth, int eHeight, int gWidth, int gHeight) {
        this.gridID = gridID;
        this.xPos = xPos;
        this.yPos = yPos;
        this.eWidth = eWidth;
        this.eHeight = eHeight;
        this.gWidth = gWidth;
        this.gHeight = gHeight;
    }

    public abstract float getCurrentScroll();

    public abstract void onGridClicked(T var1, int var2, int var3, boolean var4);

    public abstract void renderGridElement(T var1, int var2, int var3, int var4);

    public abstract void renderElementToolTip(T var1, int var2, int var3);

    public GuiGridElement<T> setList(List<T> gridList) {
        this.gridList = gridList;
        return this;
    }

    public void preRender() {
    }

    public void postRender() {
    }

    public List<T> getGridList() {
        return this.gridList;
    }

    public int getGridSize() {
        return this.gridList.size();
    }

    public boolean isScrollable() {
        return this.getGridSize() > this.gWidth * this.gHeight;
    }

    public void renderGrid(GuiSonar gui, int x, int y) {
        int pos;
        if (this.gridList.isEmpty()) {
            return;
        }
        int start = (int)((float)(this.gridList.size() / this.gWidth) * this.getCurrentScroll());
        int i = start * this.gWidth;
        int finish = Math.min(i + this.gWidth * this.gHeight, this.gridList.size());
        int X = (x - gui.getGuiLeft() - this.xPos) / this.eWidth;
        int Y = (y - gui.getGuiTop() - this.yPos) / this.eHeight;
        this.preRender();
        for (int yPos = 0; yPos < this.gHeight; ++yPos) {
            for (int xPos = 0; xPos < this.gWidth; ++xPos) {
                T selection;
                if (i < finish && (selection = this.gridList.get(i)) != null) {
                    this.renderGridElement(selection, xPos, yPos, i);
                }
                ++i;
            }
        }
        this.postRender();
        if (x - gui.getGuiLeft() >= this.xPos && x - gui.getGuiLeft() <= this.xPos + this.gWidth * this.eWidth && y - gui.getGuiTop() >= this.yPos && y - gui.getGuiTop() <= this.yPos + this.gHeight * this.eHeight && (pos = start * this.gWidth + X + Y * this.gWidth) < this.gridList.size()) {
            this.renderElementToolTip(this.gridList.get(pos), x - gui.getGuiLeft(), y - gui.getGuiTop());
        }
    }

    @Nullable
    public Pair<T, Integer> getElementHovered(GuiSonar gui, int x, int y) {
        List<T> list = this.gridList;
        int start = (int)((float)(this.gridList.size() / this.gWidth) * this.getCurrentScroll());
        int X = (x - gui.getGuiLeft() - this.xPos) / this.eWidth;
        int Y = (y - gui.getGuiTop() - this.yPos) / this.eHeight;
        if (x - gui.getGuiLeft() >= this.xPos && x - gui.getGuiLeft() <= this.xPos + this.gWidth * this.eWidth && y - gui.getGuiTop() >= this.yPos && y - gui.getGuiTop() <= this.yPos + this.gHeight * this.eHeight) {
            T e;
            int i = start * this.gWidth + this.gWidth * Y + X;
            if (i < this.gridList.size() && (e = this.gridList.get(i)) != null) {
                return new Pair<T, Integer>(e, i);
            }
            return new Pair<Object, Integer>(null, -1);
        }
        return new Pair<Object, Integer>(null, -2);
    }

    public void mouseClicked(GuiSonar gui, int x, int y, int button) {
        Pair<T, Integer> e = this.getElementHovered(gui, x, y);
        if ((Integer)e.b != -2) {
            this.onGridClicked(e.a, (Integer)e.b, button, e.a == null);
        }
    }
}

