/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg;

import gcewing.sg.BaseBlockUtils;
import gcewing.sg.BaseConfiguration;
import gcewing.sg.BaseTileInventory;
import gcewing.sg.BaseUtils;
import gcewing.sg.BlockRef;
import gcewing.sg.DHDTE;
import gcewing.sg.IComputerInterface;
import gcewing.sg.ISGEnergySource;
import gcewing.sg.IrisEntity;
import gcewing.sg.IrisState;
import gcewing.sg.SGAddressing;
import gcewing.sg.SGBaseBlock;
import gcewing.sg.SGCraft;
import gcewing.sg.SGInterfaceTE;
import gcewing.sg.SGLocation;
import gcewing.sg.SGRingTE;
import gcewing.sg.SGState;
import gcewing.sg.Trans3;
import gcewing.sg.Utils;
import gcewing.sg.Vector3;
import gcewing.sg.oc.OCWirelessEndpoint;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityEffect;
import net.minecraft.network.play.server.SPacketRespawn;
import net.minecraft.network.play.server.SPacketSetExperience;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.network.ForgeMessage;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.FMLEmbeddedChannel;
import net.minecraftforge.fml.common.network.FMLOutboundHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SGBaseTE
extends BaseTileInventory
implements ITickable {
    static boolean debugState = false;
    static boolean debugEnergyUse = false;
    static boolean debugConnect = false;
    static boolean debugTransientDamage = false;
    static boolean debugTeleport = false;
    static SoundEvent abortSound;
    static SoundEvent openSound;
    static SoundEvent closeSound;
    static SoundEvent irisOpenSound;
    static SoundEvent irisCloseSound;
    static SoundEvent irisHitSound;
    static SoundEvent diallingSound;
    static SoundEvent dhdPressSound;
    static SoundEvent dhdDialSound;
    public static final String symbolChars = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    public static final int numRingSymbols;
    public static final double ringSymbolAngle;
    public static final double irisZPosition = 0.1;
    public static final double irisThickness = 0.2;
    public static final DamageSource irisDamageSource;
    public static final float irisDamageAmount = 1000000.0f;
    static final int diallingTime = 40;
    static final int interDiallingTime = 10;
    static final int transientDuration = 20;
    static final int disconnectTime = 30;
    static final double openingTransientIntensity = 1.3;
    static final double openingTransientRandomness = 0.25;
    static final double closingTransientRandomness = 0.25;
    static final double transientDamageRate = 50.0;
    static final int maxIrisPhase = 60;
    static final int firstCamouflageSlot = 0;
    static final int numCamouflageSlots = 5;
    static final int numInventorySlots = 5;
    static float defaultChevronAngle;
    static float[][] chevronAngles;
    static double maxEnergyBuffer;
    static double energyPerFuelItem;
    static double distanceFactorMultiplier;
    static double interDimensionMultiplier;
    static int gateOpeningsPerFuelItem;
    static int minutesOpenPerFuelItem;
    static int secondsToStayOpen;
    static boolean oneWayTravel;
    static boolean closeFromEitherEnd;
    static int chunkLoadingRange;
    static boolean logStargateEvents;
    static boolean preserveInventory;
    static float soundVolume;
    static boolean variableChevronPositions;
    public static double energyToOpen;
    static double energyUsePerTick;
    static int ticksToStayOpen;
    public static boolean transparency;
    static Random random;
    static DamageSource transientDamage;
    public boolean isMerged;
    public SGState state = SGState.Idle;
    public double ringAngle;
    public double lastRingAngle;
    public double targetRingAngle;
    public int numEngagedChevrons;
    public String dialledAddress = "";
    public boolean isLinkedToController;
    public BlockPos linkedPos = new BlockPos(0, 0, 0);
    public boolean hasChevronUpgrade;
    public boolean hasIrisUpgrade;
    public IrisState irisState = IrisState.Open;
    public int irisPhase = 60;
    public int lastIrisPhase = 60;
    public OCWirelessEndpoint ocWirelessEndpoint;
    SGLocation connectedLocation;
    boolean isInitiator;
    int timeout;
    double energyInBuffer;
    double distanceFactor;
    boolean redstoneInput;
    boolean loaded;
    public String homeAddress;
    public String addressError;
    IInventory inventory = new InventoryBasic("Stargate", false, 5);
    double[][][] ehGrid;
    List<TrackedEntity> trackedEntities = new ArrayList<TrackedEntity>();
    static int[] rdx;
    static int[] rdz;

    static SoundEvent sound(String name) {
        return new SoundEvent(new ResourceLocation(name));
    }

    public static void registerSounds(SGCraft mod) {
        abortSound = mod.newSound("sg_abort");
        openSound = mod.newSound("sg_open");
        closeSound = mod.newSound("sg_close");
        irisOpenSound = mod.newSound("iris_open");
        irisCloseSound = mod.newSound("iris_close");
        irisHitSound = mod.newSound("iris_hit");
        diallingSound = mod.newSound("sg_dial7");
        dhdPressSound = mod.newSound("dhd_press");
        dhdDialSound = mod.newSound("dhd_dial");
    }

    public static void configure(BaseConfiguration cfg) {
        energyPerFuelItem = cfg.getDouble("stargate", "energyPerFuelItem", energyPerFuelItem);
        gateOpeningsPerFuelItem = cfg.getInteger("stargate", "gateOpeningsPerFuelItem", gateOpeningsPerFuelItem);
        minutesOpenPerFuelItem = cfg.getInteger("stargate", "minutesOpenPerFuelItem", minutesOpenPerFuelItem);
        secondsToStayOpen = cfg.getInteger("stargate", "secondsToStayOpen", secondsToStayOpen);
        oneWayTravel = cfg.getBoolean("stargate", "oneWayTravel", oneWayTravel);
        closeFromEitherEnd = cfg.getBoolean("stargate", "closeFromEitherEnd", closeFromEitherEnd);
        maxEnergyBuffer = cfg.getDouble("stargate", "maxEnergyBuffer", maxEnergyBuffer);
        energyToOpen = energyPerFuelItem / (double)gateOpeningsPerFuelItem;
        energyUsePerTick = energyPerFuelItem / (double)(minutesOpenPerFuelItem * 60 * 20);
        distanceFactorMultiplier = cfg.getDouble("stargate", "distanceFactorMultiplier", distanceFactorMultiplier);
        interDimensionMultiplier = cfg.getDouble("stargate", "interDimensionMultiplier", interDimensionMultiplier);
        if (debugEnergyUse) {
            System.out.printf("SGBaseTE: energyPerFuelItem = %s\n", energyPerFuelItem);
            System.out.printf("SGBaseTE: energyToOpen = %s\n", energyToOpen);
            System.out.printf("SGBaseTE: energyUsePerTick = %s\n", energyUsePerTick);
        }
        ticksToStayOpen = 20 * secondsToStayOpen;
        chunkLoadingRange = cfg.getInteger("options", "chunkLoadingRange", chunkLoadingRange);
        transparency = cfg.getBoolean("stargate", "transparency", transparency);
        logStargateEvents = cfg.getBoolean("options", "logStargateEvents", logStargateEvents);
        preserveInventory = cfg.getBoolean("iris", "preserveInventory", preserveInventory);
        soundVolume = (float)cfg.getDouble("stargate", "soundVolume", soundVolume);
        variableChevronPositions = cfg.getBoolean("stargate", "variableChevronPositions", variableChevronPositions);
    }

    public static SGBaseTE get(IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof SGBaseTE) {
            return (SGBaseTE)te;
        }
        if (te instanceof SGRingTE) {
            return ((SGRingTE)te).getBaseTE();
        }
        return null;
    }

    public String toString() {
        return String.format("SGBaseTE(%s,%s)", this.field_174879_c, this.field_145850_b.field_73011_w.getDimension());
    }

    public AxisAlignedBB getRenderBoundingBox() {
        int x = this.field_174879_c.func_177958_n();
        int y = this.field_174879_c.func_177956_o();
        int z = this.field_174879_c.func_177952_p();
        return new AxisAlignedBB((double)(x - 2), (double)y, (double)(z - 2), (double)(x + 3), (double)(y + 5), (double)(z + 3));
    }

    public double func_145833_n() {
        return 32768.0;
    }

    @Override
    public void onAddedToWorld() {
        if (SGBaseBlock.debugMerge) {
            System.out.printf("SGBaseTE.onAddedToWorld\n", new Object[0]);
        }
        this.updateChunkLoadingStatus();
    }

    void updateChunkLoadingStatus() {
        if (this.state != SGState.Idle) {
            int n = chunkLoadingRange;
            if (n >= 0) {
                SGCraft.chunkManager.setForcedChunkRange(this, -n, -n, n, n);
            }
        } else {
            SGCraft.chunkManager.clearForcedChunkRange(this);
        }
    }

    public static SGBaseTE at(IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof SGBaseTE) {
            return (SGBaseTE)te;
        }
        return null;
    }

    public static SGBaseTE at(SGLocation loc) {
        WorldServer world;
        if (loc != null && (world = SGAddressing.getWorld(loc.dimension)) != null) {
            return SGBaseTE.at((IBlockAccess)world, loc.pos);
        }
        return null;
    }

    public static SGBaseTE at(IBlockAccess world, NBTTagCompound nbt) {
        BlockPos pos = new BlockPos(nbt.func_74762_e("x"), nbt.func_74762_e("y"), nbt.func_74762_e("z"));
        return SGBaseTE.at(world, pos);
    }

    void setMerged(boolean state) {
        if (this.isMerged != state) {
            String address;
            this.isMerged = state;
            this.markBlockChanged();
            if (logStargateEvents && (address = this.tryToGetHomeAddress()) != null) {
                Logger log = LogManager.getLogger();
                String action = this.isMerged ? "ADDED" : "REMOVED";
                String name = this.func_145831_w().func_72912_H().func_76065_j();
                log.info(String.format("STARGATE %s %s %s %s", action, name, this.field_174879_c, address));
            }
            this.updateIrisEntity();
        }
    }

    String tryToGetHomeAddress() {
        try {
            return this.getHomeAddress();
        }
        catch (SGAddressing.AddressingError e) {
            return null;
        }
    }

    public int dimension() {
        if (this.field_145850_b != null) {
            return this.field_145850_b.field_73011_w.getDimension();
        }
        return -999;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.isMerged = nbt.func_74767_n("isMerged");
        this.state = SGState.valueOf(nbt.func_74762_e("state"));
        this.targetRingAngle = nbt.func_74769_h("targetRingAngle");
        this.numEngagedChevrons = nbt.func_74762_e("numEngagedChevrons");
        this.dialledAddress = nbt.func_74779_i("dialledAddress");
        this.isLinkedToController = nbt.func_74767_n("isLinkedToController");
        int x = nbt.func_74762_e("linkedX");
        int y = nbt.func_74762_e("linkedY");
        int z = nbt.func_74762_e("linkedZ");
        this.linkedPos = new BlockPos(x, y, z);
        this.hasChevronUpgrade = nbt.func_74767_n("hasChevronUpgrade");
        if (nbt.func_74764_b("connectedLocation")) {
            this.connectedLocation = new SGLocation(nbt.func_74775_l("connectedLocation"));
        }
        this.isInitiator = nbt.func_74767_n("isInitiator");
        this.timeout = nbt.func_74762_e("timeout");
        this.energyInBuffer = nbt.func_74764_b("energyInBuffer") ? nbt.func_74769_h("energyInBuffer") : (double)nbt.func_74762_e("fuelBuffer");
        this.distanceFactor = nbt.func_74769_h("distanceFactor");
        this.hasIrisUpgrade = nbt.func_74767_n("hasIrisUpgrade");
        this.irisState = IrisState.valueOf(nbt.func_74762_e("irisState"));
        this.irisPhase = nbt.func_74762_e("irisPhase");
        this.redstoneInput = nbt.func_74767_n("redstoneInput");
        this.homeAddress = this.getStringOrNull(nbt, "address");
        this.addressError = nbt.func_74779_i("addressError");
    }

    protected String getStringOrNull(NBTTagCompound nbt, String name) {
        if (nbt.func_74764_b(name)) {
            return nbt.func_74779_i(name);
        }
        return null;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74757_a("isMerged", this.isMerged);
        nbt.func_74768_a("state", this.state.ordinal());
        nbt.func_74780_a("targetRingAngle", this.targetRingAngle);
        nbt.func_74768_a("numEngagedChevrons", this.numEngagedChevrons);
        nbt.func_74778_a("dialledAddress", this.dialledAddress);
        nbt.func_74757_a("isLinkedToController", this.isLinkedToController);
        nbt.func_74768_a("linkedX", this.linkedPos.func_177958_n());
        nbt.func_74768_a("linkedY", this.linkedPos.func_177956_o());
        nbt.func_74768_a("linkedZ", this.linkedPos.func_177952_p());
        nbt.func_74757_a("hasChevronUpgrade", this.hasChevronUpgrade);
        if (this.connectedLocation != null) {
            nbt.func_74782_a("connectedLocation", (NBTBase)this.connectedLocation.toNBT());
        }
        nbt.func_74757_a("isInitiator", this.isInitiator);
        nbt.func_74768_a("timeout", this.timeout);
        nbt.func_74780_a("energyInBuffer", this.energyInBuffer);
        nbt.func_74780_a("distanceFactor", this.distanceFactor);
        nbt.func_74757_a("hasIrisUpgrade", this.hasIrisUpgrade);
        nbt.func_74768_a("irisState", this.irisState.ordinal());
        nbt.func_74768_a("irisPhase", this.irisPhase);
        nbt.func_74757_a("redstoneInput", this.redstoneInput);
        if (this.homeAddress != null) {
            nbt.func_74778_a("address", this.homeAddress);
        }
        if (this.addressError != null) {
            nbt.func_74778_a("addressError", this.addressError);
        }
        return nbt;
    }

    public boolean isActive() {
        return this.state != SGState.Idle && this.state != SGState.Disconnecting;
    }

    static boolean isValidSymbolChar(String c) {
        return SGAddressing.isValidSymbolChar(c);
    }

    static char symbolToChar(int i) {
        return SGAddressing.symbolToChar(i);
    }

    static int charToSymbol(char c) {
        return SGAddressing.charToSymbol(c);
    }

    static int charToSymbol(String c) {
        return SGAddressing.charToSymbol(c);
    }

    public EnumActionResult applyChevronUpgrade(ItemStack stack, EntityPlayer player) {
        if (!this.func_145831_w().field_72995_K && !this.hasChevronUpgrade && stack.func_190916_E() > 0) {
            this.hasChevronUpgrade = true;
            stack.func_190918_g(1);
            this.markChanged();
        }
        return EnumActionResult.SUCCESS;
    }

    public EnumActionResult applyIrisUpgrade(ItemStack stack, EntityPlayer player) {
        if (!this.func_145831_w().field_72995_K && !this.hasIrisUpgrade && stack.func_190916_E() > 0) {
            this.hasIrisUpgrade = true;
            stack.func_190918_g(1);
            this.markChanged();
            this.updateIrisEntity();
        }
        return EnumActionResult.SUCCESS;
    }

    public int getNumChevrons() {
        if (this.hasChevronUpgrade) {
            return 9;
        }
        return 7;
    }

    public boolean chevronIsEngaged(int i) {
        return i < this.numEngagedChevrons;
    }

    public float angleBetweenChevrons() {
        if (variableChevronPositions) {
            int c9 = this.getNumChevrons() > 7 ? 1 : 0;
            int bc = this.baseCornerCamouflage();
            return chevronAngles[c9][bc];
        }
        return defaultChevronAngle;
    }

    Item getItemInSlot(int slot) {
        ItemStack stack = this.func_70301_a(slot);
        return stack != null ? stack.func_77973_b() : null;
    }

    public String getHomeAddress() throws SGAddressing.AddressingError {
        return SGAddressing.addressForLocation(new SGLocation(this));
    }

    public SGBaseBlock getBlock() {
        return (SGBaseBlock)this.func_145838_q();
    }

    public double interpolatedRingAngle(double t) {
        return Utils.interpolateAngle(this.lastRingAngle, this.ringAngle, t);
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            this.clientUpdate();
        } else {
            this.serverUpdate();
            this.checkForEntitiesInPortal();
        }
        this.irisUpdate();
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (!this.field_145850_b.field_72995_K && this.ocWirelessEndpoint != null) {
            this.ocWirelessEndpoint.remove();
        }
    }

    String side() {
        return this.field_145850_b.field_72995_K ? "Client" : "Server";
    }

    void enterState(SGState newState, int newTimeout) {
        String newDesc;
        String oldDesc;
        if (debugState) {
            System.out.printf("SGBaseTE: at %s in dimension %s entering state %s with timeout %s\n", new Object[]{this.field_174879_c, this.field_145850_b.field_73011_w.getDimension(), newState, newTimeout});
        }
        SGState oldState = this.state;
        this.state = newState;
        this.timeout = newTimeout;
        this.markChanged();
        if (oldState == SGState.Idle != (newState == SGState.Idle)) {
            this.updateChunkLoadingStatus();
            this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q(), true);
        }
        if (!(oldDesc = SGBaseTE.sgStateDescription(oldState)).equals(newDesc = SGBaseTE.sgStateDescription(newState))) {
            this.postEvent("sgStargateStateChange", newDesc, oldDesc);
        }
    }

    public boolean isConnected() {
        return this.state == SGState.Transient || this.state == SGState.Connected || this.state == SGState.Disconnecting;
    }

    DHDTE getLinkedControllerTE() {
        TileEntity cte;
        if (this.isLinkedToController && (cte = this.field_145850_b.func_175625_s(this.linkedPos)) instanceof DHDTE) {
            return (DHDTE)cte;
        }
        return null;
    }

    void checkForLink() {
        int rangeXY = BaseUtils.max(DHDTE.linkRangeX, DHDTE.linkRangeY);
        int rangeZ = DHDTE.linkRangeZ;
        if (SGBaseBlock.debugMerge) {
            System.out.printf("SGBaseTE.checkForLink: in range +/-(%d,%d,%d) of %s\n", rangeXY, rangeZ, rangeXY, this.field_174879_c);
        }
        for (int i = -rangeXY; i <= rangeXY; ++i) {
            for (int j = -rangeZ; j <= rangeZ; ++j) {
                for (int k = -rangeXY; k <= rangeXY; ++k) {
                    TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(i, j, k));
                    if (!(te instanceof DHDTE)) continue;
                    ((DHDTE)te).checkForLink();
                }
            }
        }
    }

    public void unlinkFromController() {
        if (this.isLinkedToController) {
            DHDTE cte = this.getLinkedControllerTE();
            if (cte != null) {
                cte.clearLinkToStargate();
            }
            this.clearLinkToController();
        }
    }

    public void clearLinkToController() {
        if (SGBaseBlock.debugMerge) {
            System.out.printf("SGBaseTE: Unlinking stargate at %d from controller\n", this.field_174879_c);
        }
        this.isLinkedToController = false;
        this.func_70296_d();
    }

    public void connectOrDisconnect(String address, EntityPlayer player) {
        if (debugConnect) {
            System.out.printf("SGBaseTE: %s: connectOrDisconnect('%s') in state %s by %s\n", new Object[]{this.side(), address, this.state, player});
        }
        if (address.length() > 0) {
            this.connect(address, player);
        } else {
            this.attemptToDisconnect(player);
        }
    }

    public String attemptToDisconnect(EntityPlayer player) {
        boolean validConnection;
        boolean canDisconnect = this.disconnectionAllowed();
        SGBaseTE dte = this.getConnectedStargateTE();
        boolean bl = validConnection = dte != null && !dte.func_145837_r() && dte.getConnectedStargateTE() == this;
        if (canDisconnect || !validConnection) {
            if (this.state != SGState.Disconnecting) {
                this.disconnect();
            }
            return null;
        }
        return this.operationFailure(player, "incomingConnection", new Object[0]);
    }

    public boolean disconnectionAllowed() {
        return this.isInitiator || closeFromEitherEnd;
    }

    String connect(String address, EntityPlayer player) {
        SGBaseTE dte;
        if (this.state != SGState.Idle) {
            return this.diallingFailure(player, "selfBusy", new Object[0]);
        }
        String homeAddress = this.findHomeAddress();
        if (homeAddress.equals("")) {
            return this.diallingFailure(player, "selfOutOfRange", new Object[0]);
        }
        try {
            dte = SGAddressing.findAddressedStargate(address, this.field_145850_b);
        }
        catch (SGAddressing.AddressingError e) {
            return this.diallingFailure(player, e.getMessage(), new Object[0]);
        }
        if (dte == null || !dte.isMerged) {
            return this.diallingFailure(player, "unknownAddress", address);
        }
        if (this.func_145831_w() == dte.func_145831_w()) {
            address = SGAddressing.localAddress(address);
            homeAddress = SGAddressing.localAddress(homeAddress);
        }
        if (address.length() > this.getNumChevrons()) {
            return this.diallingFailure(player, "selfLackChevrons", address);
        }
        if (dte == this) {
            return this.diallingFailure(player, "diallingItself", new Object[0]);
        }
        if (debugConnect) {
            System.out.printf("SGBaseTE.connect: to %s in dimension %d with state %s\n", new Object[]{dte.func_174877_v(), dte.func_145831_w().field_73011_w.getDimension(), dte.state});
        }
        if (dte.getNumChevrons() < homeAddress.length()) {
            return this.diallingFailure(player, "targetLackChevrons", new Object[0]);
        }
        if (dte.state != SGState.Idle) {
            return this.diallingFailure(player, "targetBusy", address);
        }
        this.distanceFactor = SGBaseTE.distanceFactorForCoordDifference(this, dte);
        if (debugEnergyUse) {
            System.out.printf("SGBaseTE: distanceFactor = %s\n", this.distanceFactor);
        }
        if (!this.energyIsAvailable(energyToOpen * this.distanceFactor)) {
            return this.diallingFailure(player, "insufficientEnergy", new Object[0]);
        }
        this.startDiallingStargate(address, dte, true);
        dte.startDiallingStargate(homeAddress, this, false);
        return null;
    }

    public static double distanceFactorForCoordDifference(TileEntity te1, TileEntity te2) {
        double dx = te1.func_174877_v().func_177958_n() - te2.func_174877_v().func_177958_n();
        double dz = te1.func_174877_v().func_177952_p() - te2.func_174877_v().func_177952_p();
        double d = Math.sqrt(dx * dx + dz * dz);
        if (debugEnergyUse) {
            System.out.printf("SGBaseTE: Connection distance = %s\n", d);
        }
        double ld = Math.log(0.05 * d + 1.0);
        double lm = Math.log(223948.0);
        double lr = ld / lm;
        double f = 1.0 + 14.0 * distanceFactorMultiplier * lr * lr;
        if (te1.func_145831_w() != te2.func_145831_w()) {
            f *= interDimensionMultiplier;
        }
        return f;
    }

    public void playSGSoundEffect(SoundEvent se, float volume, float pitch) {
        this.playSoundEffect(se, volume * soundVolume, pitch);
    }

    public String diallingFailure(EntityPlayer player, String msg, Object ... args) {
        if (player != null && this.state == SGState.Idle) {
            this.playSGSoundEffect(abortSound, 1.0f, 1.0f);
        }
        return this.operationFailure(player, msg, args);
    }

    public String operationFailure(EntityPlayer player, String msg, Object ... args) {
        if (player != null) {
            SGBaseTE.sendErrorMsg(player, msg, args);
        }
        return msg;
    }

    public static void sendErrorMsg(EntityPlayer player, String msg, Object ... args) {
        TextComponentTranslation component = new TextComponentTranslation("message.sgcraft:" + msg, args);
        component.func_150256_b().func_150238_a(TextFormatting.RED);
        player.func_145747_a((ITextComponent)component);
    }

    String findHomeAddress() {
        try {
            return this.getHomeAddress();
        }
        catch (SGAddressing.AddressingError e) {
            return "";
        }
    }

    public void disconnect() {
        SGBaseTE dte;
        if (debugConnect) {
            System.out.printf("SGBaseTE: %s: disconnect()\n", this.side());
        }
        if ((dte = SGBaseTE.at(this.connectedLocation)) != null) {
            dte.clearConnection();
        }
        this.clearConnection();
    }

    public void clearConnection() {
        if (this.state != SGState.Idle || this.connectedLocation != null) {
            this.dialledAddress = "";
            this.connectedLocation = null;
            this.isInitiator = false;
            this.numEngagedChevrons = 0;
            this.markChanged();
            if (this.state == SGState.Connected) {
                this.enterState(SGState.Disconnecting, 30);
                this.playSGSoundEffect(closeSound, 1.0f, 1.0f);
            } else {
                if (this.state != SGState.Idle && this.state != SGState.Disconnecting) {
                    this.playSGSoundEffect(abortSound, 1.0f, 1.0f);
                }
                this.enterState(SGState.Idle, 0);
            }
        }
    }

    void startDiallingStargate(String address, SGBaseTE dte, boolean initiator) {
        this.dialledAddress = address;
        this.connectedLocation = new SGLocation(dte);
        this.isInitiator = initiator;
        this.func_70296_d();
        this.startDiallingNextSymbol();
        this.postEvent(initiator ? "sgDialOut" : "sgDialIn", address);
    }

    void serverUpdate() {
        if (!this.loaded) {
            this.loaded = true;
            try {
                this.homeAddress = this.getHomeAddress();
                this.addressError = "";
            }
            catch (SGAddressing.AddressingError e) {
                this.homeAddress = null;
                this.addressError = e.getMessage();
            }
            if (SGCraft.ocIntegration != null) {
                SGCraft.ocIntegration.onSGBaseTEAdded(this);
            }
        }
        if (this.isMerged) {
            if (debugState && this.state != SGState.Connected && this.timeout > 0) {
                int dimension = this.field_145850_b.field_73011_w.getDimension();
                System.out.printf("SGBaseTE.serverUpdate at %d in dimension %d: state %s, timeout %s\n", new Object[]{this.field_174879_c, dimension, this.state, this.timeout});
            }
            this.tickEnergyUsage();
            if (this.timeout > 0) {
                if (this.state == SGState.Transient && !this.irisIsClosed()) {
                    this.performTransientDamage();
                }
                --this.timeout;
            } else {
                switch (this.state) {
                    case Idle: {
                        if (!this.undialledDigitsRemaining()) break;
                        this.startDiallingNextSymbol();
                        break;
                    }
                    case Dialling: {
                        this.finishDiallingSymbol();
                        break;
                    }
                    case InterDialling: {
                        this.startDiallingNextSymbol();
                        break;
                    }
                    case Transient: {
                        this.enterState(SGState.Connected, this.isInitiator ? ticksToStayOpen : 0);
                        break;
                    }
                    case Connected: {
                        if (!this.isInitiator || ticksToStayOpen <= 0) break;
                        this.disconnect();
                        break;
                    }
                    case Disconnecting: {
                        this.enterState(SGState.Idle, 0);
                    }
                }
            }
        }
    }

    void tickEnergyUsage() {
        if (this.state == SGState.Connected && this.isInitiator && !this.useEnergy(energyUsePerTick * this.distanceFactor)) {
            this.disconnect();
        }
    }

    double availableEnergy() {
        List<ISGEnergySource> sources = this.findEnergySources();
        return this.energyInBuffer + this.energyAvailableFrom(sources);
    }

    boolean energyIsAvailable(double amount) {
        double energy = this.availableEnergy();
        if (debugEnergyUse) {
            System.out.printf("SGBaseTE.energyIsAvailable: need %s, have %s\n", amount, energy);
        }
        return energy >= amount;
    }

    boolean useEnergy(double amount) {
        if (debugEnergyUse) {
            System.out.printf("SGBaseTE.useEnergy: %s; buffered: %s\n", amount, this.energyInBuffer);
        }
        if (amount <= this.energyInBuffer) {
            this.energyInBuffer -= amount;
            return true;
        }
        List<ISGEnergySource> sources = this.findEnergySources();
        double energyAvailable = this.energyInBuffer + this.energyAvailableFrom(sources);
        if (debugEnergyUse) {
            System.out.printf("SGBaseTE.useEnergy: %s available\n", energyAvailable);
        }
        if (amount > energyAvailable) {
            System.out.printf("SGBaseTE: Not enough energy available\n", new Object[0]);
            return false;
        }
        double desiredEnergy = BaseUtils.max(amount, maxEnergyBuffer);
        double targetEnergy = BaseUtils.min(desiredEnergy, energyAvailable);
        double energyRequired = targetEnergy - this.energyInBuffer;
        if (debugEnergyUse) {
            System.out.printf("SGBaseTE.useEnergy: another %s required\n", energyRequired);
        }
        double energyOnHand = this.energyInBuffer + this.drawEnergyFrom(sources, energyRequired);
        if (debugEnergyUse) {
            System.out.printf("SGBaseTE.useEnergy: %s now on hand, need %s\n", energyOnHand, amount);
        }
        if (amount - 1.0E-4 > energyOnHand) {
            System.out.printf("SGBaseTE: Energy sources only delivered %s of promised %s\n", energyOnHand - this.energyInBuffer, energyAvailable);
            return false;
        }
        this.setEnergyInBuffer(energyOnHand - amount);
        if (debugEnergyUse) {
            System.out.printf("SGBaseTE.useEnergy: %s left over in buffer\n", this.energyInBuffer);
        }
        return true;
    }

    List<ISGEnergySource> findEnergySources() {
        ArrayList<ISGEnergySource> result = new ArrayList<ISGEnergySource>();
        Trans3 t = this.localToGlobalTransformation();
        for (int i = -2; i <= 2; ++i) {
            BlockPos bp = t.p(i, -1.0, 0.0).blockPos();
            TileEntity nte = this.field_145850_b.func_175625_s(bp);
            if (!(nte instanceof ISGEnergySource)) continue;
            result.add((ISGEnergySource)nte);
        }
        DHDTE te = this.getLinkedControllerTE();
        if (te != null) {
            result.add(te);
        }
        return result;
    }

    double energyAvailableFrom(List<ISGEnergySource> sources) {
        double energy = 0.0;
        for (ISGEnergySource source : sources) {
            double e = source.availableEnergy();
            if (debugEnergyUse) {
                System.out.printf("SGBaseTe.energyAvailableFrom: %s can supply %s\n", source, e);
            }
            energy += e;
        }
        return energy;
    }

    double drawEnergyFrom(List<ISGEnergySource> sources, double amount) {
        double total = 0.0;
        for (ISGEnergySource source : sources) {
            if (total >= amount) break;
            double e = source.drawEnergy(amount - total);
            if (debugEnergyUse) {
                System.out.printf("SGBaseTe.drawEnergyFrom: %s supplied %s\n", source, e);
            }
            total += e;
        }
        if (total < amount) {
            System.out.printf("SGCraft: Warning: Energy sources did not deliver promised energy (%s requested, %s delivered)\n", amount, total);
        }
        return total;
    }

    void setEnergyInBuffer(double amount) {
        if (this.energyInBuffer != amount) {
            this.energyInBuffer = amount;
            this.func_70296_d();
        }
    }

    void performTransientDamage() {
        Trans3 t = this.localToGlobalTransformation();
        Vector3 p0 = t.p(-1.5, 0.5, 0.5);
        Vector3 p1 = t.p(1.5, 3.5, 5.5);
        Vector3 q0 = p0.min(p1);
        Vector3 q1 = p0.max(p1);
        AxisAlignedBB box = new AxisAlignedBB(q0.x, q0.y, q0.z, q1.x, q1.y, q1.z);
        if (debugTransientDamage) {
            System.out.printf("SGBaseTE.performTransientDamage: players in world:\n", new Object[0]);
            for (Entity ent : this.field_145850_b.field_72996_f) {
                if (!(ent instanceof EntityPlayer)) continue;
                System.out.printf("--- %s\n", ent);
            }
            System.out.printf("SGBaseTE.performTransientDamage: box = %s\n", box);
        }
        List ents = this.field_145850_b.func_72872_a(EntityLivingBase.class, box);
        for (EntityLivingBase ent : ents) {
            Vector3 ep = new Vector3(ent.field_70165_t, ent.field_70163_u, ent.field_70161_v);
            Vector3 gp = t.p(0.0, 2.0, 0.5);
            double dist = ep.distance(gp);
            if (debugTransientDamage) {
                System.out.printf("SGBaseTE.performTransientDamage: found %s\n", ent);
            }
            if (dist > 1.0) {
                dist = 1.0;
            }
            int damage = (int)Math.ceil(dist * 50.0);
            if (debugTransientDamage) {
                System.out.printf("SGBaseTE.performTransientDamage: distance = %s, damage = %s\n", dist, damage);
            }
            ent.func_70097_a(transientDamage, (float)damage);
        }
    }

    boolean undialledDigitsRemaining() {
        int n = this.numEngagedChevrons;
        return n < this.dialledAddress.length();
    }

    void startDiallingNextSymbol() {
        if (debugState) {
            System.out.printf("SGBaseTE.startDiallingNextSymbol: %s of %s\n", this.numEngagedChevrons, this.dialledAddress);
        }
        this.startDiallingSymbol(this.dialledAddress.charAt(this.numEngagedChevrons));
    }

    void startDiallingSymbol(char c) {
        int i = SGAddressing.charToSymbol(c);
        if (debugState) {
            System.out.printf("SGBaseTE.startDiallingSymbol: %s\n", i);
        }
        if (i >= 0 && i < numRingSymbols) {
            this.startDiallingToAngle((double)i * ringSymbolAngle);
            this.playSGSoundEffect(diallingSound, 1.0f, 1.0f);
        } else {
            System.out.printf("SGCraft: Stargate jammed trying to dial symbol %s\n", Character.valueOf(c));
            this.dialledAddress = "";
            this.enterState(SGState.Idle, 0);
        }
    }

    void startDiallingToAngle(double a) {
        this.targetRingAngle = Utils.normaliseAngle(a);
        this.enterState(SGState.Dialling, 40);
    }

    void finishDiallingSymbol() {
        ++this.numEngagedChevrons;
        String symbol = this.dialledAddress.substring(this.numEngagedChevrons - 1, this.numEngagedChevrons);
        this.postEvent("sgChevronEngaged", this.numEngagedChevrons, symbol);
        if (this.undialledDigitsRemaining()) {
            this.enterState(SGState.InterDialling, 10);
        } else {
            this.finishDiallingAddress();
        }
    }

    void finishDiallingAddress() {
        if (!this.isInitiator || this.useEnergy(energyToOpen * this.distanceFactor)) {
            this.enterState(SGState.Transient, 20);
            this.playSGSoundEffect(openSound, 1.0f, 1.0f);
        } else {
            this.disconnect();
        }
    }

    boolean canTravelFromThisEnd() {
        return this.isInitiator || !oneWayTravel;
    }

    static String repr(Entity entity) {
        if (entity != null) {
            String s = String.format("%s#%s", entity.getClass().getSimpleName(), entity.func_145782_y());
            if (entity.field_70128_L) {
                s = s + "(dead)";
            }
            return s;
        }
        return "null";
    }

    void checkForEntitiesInPortal() {
        if (this.state == SGState.Connected) {
            for (TrackedEntity trk : this.trackedEntities) {
                this.entityInPortal(trk.entity, trk.lastPos);
            }
            this.trackedEntities.clear();
            Vector3 p0 = new Vector3(-1.5, 0.5, -3.5);
            Vector3 p1 = new Vector3(1.5, 3.5, 3.5);
            Trans3 t = this.localToGlobalTransformation();
            AxisAlignedBB box = t.box(p0, p1);
            List ents = this.field_145850_b.func_72872_a(Entity.class, box);
            for (Entity entity : ents) {
                if (entity instanceof EntityFishHook || entity.field_70128_L || entity.func_184187_bx() != null) continue;
                this.trackedEntities.add(new TrackedEntity(entity));
            }
        } else {
            this.trackedEntities.clear();
        }
    }

    public void entityInPortal(Entity entity, Vector3 prevPos) {
        if (!entity.field_70128_L && this.state == SGState.Connected && this.canTravelFromThisEnd()) {
            Trans3 t = this.localToGlobalTransformation();
            double vx = entity.field_70165_t - prevPos.x;
            double vy = entity.field_70163_u - prevPos.y;
            double vz = entity.field_70161_v - prevPos.z;
            Vector3 p1 = t.ip(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
            Vector3 p0 = t.ip(2.0 * prevPos.x - entity.field_70165_t, 2.0 * prevPos.y - entity.field_70163_u, 2.0 * prevPos.z - entity.field_70161_v);
            double z0 = 0.0;
            if (p0.z >= z0 && p1.z < z0 && p1.z > z0 - 5.0) {
                entity.field_70159_w = vx;
                entity.field_70181_x = vy;
                entity.field_70179_y = vz;
                SGBaseTE dte = this.getConnectedStargateTE();
                if (dte != null) {
                    Trans3 dt = dte.localToGlobalTransformation();
                    while (entity.func_184187_bx() != null) {
                        entity = entity.func_184187_bx();
                    }
                    this.teleportEntityAndRiders(entity, t, dt, this.connectedLocation.dimension, dte.irisIsClosed());
                }
            }
        }
    }

    Entity teleportEntityAndRiders(Entity entity, Trans3 t1, Trans3 t2, int dimension, boolean destBlocked) {
        if (debugTeleport) {
            System.out.printf("SGBaseTE.teleportEntityAndRiders: destBlocked = %s\n", destBlocked);
        }
        List riders = entity.func_184188_bt();
        for (int i = 0; i < riders.size(); ++i) {
            Entity rider = (Entity)riders.get(i);
            rider.func_184210_p();
            rider = this.teleportEntityAndRiders(rider, t1, t2, dimension, destBlocked);
            riders.set(i, rider);
        }
        SGBaseTE.unleashEntity(entity);
        entity = SGBaseTE.teleportEntity(entity, t1, t2, dimension, destBlocked);
        if (entity != null && !entity.field_70128_L) {
            for (Entity rider : riders) {
                if (rider == null || rider.field_70128_L) continue;
                rider.func_184205_a(entity, true);
            }
        }
        return entity;
    }

    protected static void unleashEntity(Entity entity) {
        if (entity instanceof EntityLiving) {
            ((EntityLiving)entity).func_110160_i(true, false);
        }
        for (EntityLiving entity2 : SGBaseTE.entitiesWithinLeashRange(entity)) {
            if (!entity2.func_110167_bD() || entity2.func_110166_bE() != entity) continue;
            entity2.func_110160_i(true, false);
        }
    }

    protected static List<EntityLiving> entitiesWithinLeashRange(Entity entity) {
        AxisAlignedBB box = new AxisAlignedBB(entity.field_70165_t - 7.0, entity.field_70163_u - 7.0, entity.field_70161_v - 7.0, entity.field_70165_t + 7.0, entity.field_70163_u + 7.0, entity.field_70161_v + 7.0);
        return entity.field_70170_p.func_72872_a(EntityLiving.class, box);
    }

    static Entity teleportEntity(Entity entity, Trans3 t1, Trans3 t2, int dimension, boolean destBlocked) {
        Entity newEntity = null;
        if (debugTeleport) {
            System.out.printf("SGBaseTE.teleportEntity: %s (in dimension %d)  to dimension %d\n", SGBaseTE.repr(entity), entity.field_71093_bK, dimension);
            System.out.printf("SGBaseTE.teleportEntity: pos (%.2f, %.2f, %.2f) prev (%.2f, %.2f, %.2f) last (%.2f, %.2f, %.2f) pitch %.2f yaw %.2f\n", entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70169_q, entity.field_70167_r, entity.field_70166_s, entity.field_70142_S, entity.field_70137_T, entity.field_70136_U, Float.valueOf(entity.field_70125_A), Float.valueOf(entity.field_70177_z));
        }
        Vector3 p = t1.ip(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        Vector3 v = t1.iv(entity.field_70159_w, entity.field_70181_x, entity.field_70179_y);
        Vector3 r = t1.iv(SGBaseTE.yawVector(entity));
        Vector3 q = t2.p(-p.x, p.y, -p.z);
        Vector3 u = t2.v(-v.x, v.y, -v.z);
        Vector3 s = t2.v(r.mul(-1.0));
        if (debugTeleport) {
            System.out.printf("SGBaseTE.teleportEntity: Facing old %s new %s\n", r, s);
        }
        double a = SGBaseTE.yawAngle(s, entity);
        if (debugTeleport) {
            System.out.printf("SGBaseTE.teleportEntity: new yaw %.2f\n", a);
        }
        if (!destBlocked) {
            if (entity.field_71093_bK == dimension) {
                newEntity = SGBaseTE.teleportWithinDimension(entity, q, u, a, destBlocked);
            } else {
                newEntity = SGBaseTE.teleportToOtherDimension(entity, q, u, a, dimension, destBlocked);
                if (newEntity != null) {
                    newEntity.field_71093_bK = dimension;
                }
            }
        } else {
            SGBaseTE.terminateEntityByIrisImpact(entity);
            SGBaseTE.playIrisHitSound((World)SGBaseTE.worldForDimension(dimension), q, entity);
        }
        return newEntity;
    }

    static void terminateEntityByIrisImpact(Entity entity) {
        if (entity instanceof EntityPlayer) {
            SGBaseTE.terminatePlayerByIrisImpact((EntityPlayer)entity);
        } else {
            entity.func_70106_y();
        }
    }

    static void terminatePlayerByIrisImpact(EntityPlayer player) {
        if (player.field_71075_bZ.field_75098_d) {
            SGBaseTE.sendErrorMsg(player, "irisAtDestination", new Object[0]);
        } else {
            if (!preserveInventory && !player.field_70170_p.func_82736_K().func_82766_b("keepInventory")) {
                player.field_71071_by.func_174888_l();
            }
            player.func_70097_a(irisDamageSource, 1000000.0f);
        }
    }

    static WorldServer worldForDimension(int dimension) {
        return SGAddressing.getWorld(dimension);
    }

    static void playIrisHitSound(World world, Vector3 pos, Entity entity) {
        double volume = BaseUtils.min(entity.field_70130_N * entity.field_70131_O, 1.0);
        double pitch = 2.0 - volume;
        if (debugTeleport) {
            System.out.printf("SGBaseTE.playIrisHitSound: at (%.3f,%.3f,%.3f) volume %.3f pitch %.3f\n", pos.x, pos.y, pos.z, volume, pitch);
        }
        world.func_184134_a(pos.x, pos.y, pos.z, irisHitSound, SoundCategory.NEUTRAL, (float)volume, (float)pitch, false);
    }

    static Entity teleportWithinDimension(Entity entity, Vector3 p, Vector3 v, double a, boolean destBlocked) {
        if (entity instanceof EntityPlayerMP) {
            return SGBaseTE.teleportPlayerWithinDimension((EntityPlayerMP)entity, p, v, a);
        }
        return SGBaseTE.teleportEntityToWorld(entity, p, v, a, (WorldServer)entity.field_70170_p, destBlocked);
    }

    static Entity teleportPlayerWithinDimension(EntityPlayerMP entity, Vector3 p, Vector3 v, double a) {
        entity.field_70177_z = (float)a;
        entity.func_70634_a(p.x, p.y, p.z);
        entity.field_70170_p.func_72866_a((Entity)entity, false);
        return entity;
    }

    static Entity teleportToOtherDimension(Entity entity, Vector3 p, Vector3 v, double a, int dimension, boolean destBlocked) {
        if (entity instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)entity;
            Vector3 q = p.add(SGBaseTE.yawVector(a));
            SGBaseTE.transferPlayerToDimension(player, dimension, q, a);
            return player;
        }
        return SGBaseTE.teleportEntityToDimension(entity, p, v, a, dimension, destBlocked);
    }

    static void sendDimensionRegister(EntityPlayerMP player, int dimensionID) {
        DimensionType providerID = DimensionManager.getProviderType((int)dimensionID);
        ForgeMessage.DimensionRegisterMessage msg = new ForgeMessage.DimensionRegisterMessage(dimensionID, providerID.toString());
        FMLEmbeddedChannel channel = NetworkRegistry.INSTANCE.getChannel("FORGE", Side.SERVER);
        channel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        channel.attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
        channel.writeAndFlush((Object)msg).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    static void transferPlayerToDimension(EntityPlayerMP player, int newDimension, Vector3 p, double a) {
        MinecraftServer server = BaseUtils.getMinecraftServer();
        PlayerList scm = server.func_184103_al();
        int oldDimension = player.field_71093_bK;
        player.field_71093_bK = newDimension;
        WorldServer oldWorld = server.func_71218_a(oldDimension);
        WorldServer newWorld = server.func_71218_a(newDimension);
        SGBaseTE.sendDimensionRegister(player, newDimension);
        player.func_71053_j();
        player.field_71135_a.func_147359_a((Packet)new SPacketRespawn(player.field_71093_bK, player.field_70170_p.func_175659_aa(), newWorld.func_72912_H().func_76067_t(), player.field_71134_c.func_73081_b()));
        oldWorld.func_72973_f((Entity)player);
        player.field_70128_L = false;
        player.func_70012_b(p.x, p.y, p.z, (float)a, player.field_70125_A);
        newWorld.func_72838_d((Entity)player);
        player.func_70029_a((World)newWorld);
        scm.func_72375_a(player, oldWorld);
        player.field_71135_a.func_147364_a(p.x, p.y, p.z, (float)a, player.field_70125_A);
        player.field_71134_c.func_73080_a(newWorld);
        scm.func_72354_b(player, newWorld);
        scm.func_72385_f(player);
        for (PotionEffect effect : player.func_70651_bq()) {
            player.field_71135_a.func_147359_a((Packet)new SPacketEntityEffect(player.func_145782_y(), effect));
        }
        player.field_71135_a.func_147359_a((Packet)new SPacketSetExperience(player.field_71106_cc, player.field_71067_cb, player.field_71068_ca));
        FMLCommonHandler.instance().firePlayerChangedDimensionEvent((EntityPlayer)player, oldDimension, newDimension);
    }

    static Entity teleportEntityToDimension(Entity entity, Vector3 p, Vector3 v, double a, int dimension, boolean destBlocked) {
        MinecraftServer server = BaseUtils.getMinecraftServer();
        WorldServer world = server.func_71218_a(dimension);
        return SGBaseTE.teleportEntityToWorld(entity, p, v, a, world, destBlocked);
    }

    static Entity teleportEntityToWorld(Entity oldEntity, Vector3 p, Vector3 v, double a, WorldServer newWorld, boolean destBlocked) {
        if (debugTeleport) {
            System.out.printf("SGBaseTE.teleportEntityToWorld: %s to %s, destBlocked = %s\n", SGBaseTE.repr(oldEntity), newWorld, destBlocked);
        }
        WorldServer oldWorld = (WorldServer)oldEntity.field_70170_p;
        NBTTagCompound nbt = new NBTTagCompound();
        oldEntity.func_189511_e(nbt);
        SGBaseTE.extractEntityFromWorld((World)oldWorld, oldEntity);
        if (destBlocked && !(oldEntity instanceof EntityLivingBase)) {
            return null;
        }
        Entity newEntity = SGBaseTE.instantiateEntityFromNBT(oldEntity.getClass(), nbt, newWorld);
        if (newEntity != null) {
            if (oldEntity instanceof EntityLiving) {
                SGBaseTE.copyMoreEntityData((EntityLiving)oldEntity, (EntityLiving)newEntity);
            }
            SGBaseTE.setVelocity(newEntity, v);
            newEntity.func_70012_b(p.x, p.y, p.z, (float)a, oldEntity.field_70125_A);
            SGBaseTE.checkChunk((World)newWorld, newEntity);
            newEntity.field_98038_p = true;
            newWorld.func_72838_d(newEntity);
            newEntity.func_70029_a((World)newWorld);
            if (debugTeleport) {
                System.out.printf("SGBaseTE.teleportEntityToWorld: Spawned %s pos (%.2f, %.2f, %.2f) vel (%.2f, %.2f, %.2f) pitch %.2f (%.2f) yaw %.2f (%.2f)\n", SGBaseTE.repr(newEntity), newEntity.field_70165_t, newEntity.field_70163_u, newEntity.field_70161_v, newEntity.field_70159_w, newEntity.field_70181_x, newEntity.field_70179_y, Float.valueOf(newEntity.field_70125_A), Float.valueOf(newEntity.field_70127_C), Float.valueOf(newEntity.field_70177_z), Float.valueOf(newEntity.field_70126_B));
            }
        }
        oldWorld.func_82742_i();
        if (oldWorld != newWorld) {
            newWorld.func_82742_i();
        }
        return newEntity;
    }

    static Entity instantiateEntityFromNBT(Class cls, NBTTagCompound nbt, WorldServer world) {
        try {
            Entity entity = (Entity)cls.getConstructor(World.class).newInstance(world);
            entity.func_70020_e(nbt);
            return entity;
        }
        catch (Exception e) {
            System.out.printf("SGCraft: SGBaseTE.instantiateEntityFromNBT: Could not instantiate %s: %s\n", cls, e);
            e.printStackTrace();
            return null;
        }
    }

    static void copyMoreEntityData(EntityLiving oldEntity, EntityLiving newEntity) {
        float s = oldEntity.func_70689_ay();
        if (s != 0.0f) {
            newEntity.func_70659_e(s);
        }
    }

    static void setVelocity(Entity entity, Vector3 v) {
        entity.field_70159_w = v.x;
        entity.field_70181_x = v.y;
        entity.field_70179_y = v.z;
    }

    static void extractEntityFromWorld(World world, Entity entity) {
        if (entity instanceof EntityPlayer) {
            world.field_73010_i.remove(entity);
            world.func_72854_c();
        }
        int i = entity.field_70176_ah;
        int j = entity.field_70164_aj;
        if (entity.field_70175_ag && ((ChunkProviderServer)world.func_72863_F()).func_73149_a(i, j)) {
            world.func_72964_e(i, j).func_76622_b(entity);
        }
        world.field_72996_f.remove(entity);
        world.func_72847_b(entity);
    }

    static void checkChunk(World world, Entity entity) {
        int cx = MathHelper.func_76128_c((double)(entity.field_70165_t / 16.0));
        int cy = MathHelper.func_76128_c((double)(entity.field_70161_v / 16.0));
        Chunk chunk = world.func_72964_e(cx, cy);
    }

    protected static int yawSign(Entity entity) {
        if (entity instanceof EntityArrow) {
            return -1;
        }
        return 1;
    }

    static Vector3 yawVector(Entity entity) {
        return SGBaseTE.yawVector((float)SGBaseTE.yawSign(entity) * entity.field_70177_z);
    }

    static Vector3 yawVector(double yaw) {
        double a = Math.toRadians(yaw);
        Vector3 v = new Vector3(-Math.sin(a), 0.0, Math.cos(a));
        return v;
    }

    static double yawAngle(Vector3 v, Entity entity) {
        double a = Math.atan2(-v.x, v.z);
        double d = Math.toDegrees(a);
        return (double)SGBaseTE.yawSign(entity) * d;
    }

    public SGBaseTE getConnectedStargateTE() {
        if (this.isConnected() && this.connectedLocation != null) {
            return this.connectedLocation.getStargateTE();
        }
        return null;
    }

    @Override
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        SGState oldState = this.state;
        super.onDataPacket(net, pkt);
        if (this.isMerged && this.state != oldState) {
            switch (this.state) {
                case Transient: {
                    this.initiateOpeningTransient();
                    break;
                }
                case Disconnecting: {
                    this.initiateClosingTransient();
                }
            }
        }
    }

    void clientUpdate() {
        this.lastRingAngle = this.ringAngle;
        switch (this.state) {
            case Dialling: {
                this.updateRingAngle();
                break;
            }
            case Transient: 
            case Connected: 
            case Disconnecting: {
                this.applyRandomImpulse();
                this.updateEventHorizon();
            }
        }
    }

    void setRingAngle(double a) {
        this.ringAngle = a;
    }

    void updateRingAngle() {
        if (this.timeout > 0) {
            double da = Utils.diffAngle(this.ringAngle, this.targetRingAngle) / (double)this.timeout;
            this.setRingAngle(Utils.addAngle(this.ringAngle, da));
            --this.timeout;
        } else {
            this.setRingAngle(this.targetRingAngle);
        }
    }

    public double[][][] getEventHorizonGrid() {
        if (this.ehGrid == null) {
            int m = 5;
            int n = 32;
            this.ehGrid = new double[2][n + 2][m + 1];
            for (int i = 0; i < 2; ++i) {
                this.ehGrid[i][0] = this.ehGrid[i][n];
                this.ehGrid[i][n + 1] = this.ehGrid[i][1];
            }
        }
        return this.ehGrid;
    }

    void initiateOpeningTransient() {
        double[][] v = this.getEventHorizonGrid()[1];
        int n = 32;
        for (int j = 0; j <= n + 1; ++j) {
            v[j][0] = 1.3;
            v[j][1] = v[j][0] + 0.25 * random.nextGaussian();
        }
    }

    void initiateClosingTransient() {
        double[][] v = this.getEventHorizonGrid()[1];
        int m = 5;
        int n = 32;
        for (int i = 1; i < m; ++i) {
            for (int j = 1; j <= n; ++j) {
                double[] dArray = v[j];
                int n2 = i;
                dArray[n2] = dArray[n2] + 0.25 * random.nextGaussian();
            }
        }
    }

    void applyRandomImpulse() {
        double[][] v = this.getEventHorizonGrid()[1];
        int m = 5;
        int n = 32;
        int i = random.nextInt(m - 1) + 1;
        int j = random.nextInt(n) + 1;
        double[] dArray = v[j];
        int n2 = i;
        dArray[n2] = dArray[n2] + 0.05 * random.nextGaussian();
    }

    void updateEventHorizon() {
        int j;
        int j2;
        int i;
        double[][][] grid = this.getEventHorizonGrid();
        double[][] u = grid[0];
        double[][] v = grid[1];
        int m = 5;
        int n = 32;
        double dt = 1.0;
        double asq = 0.03;
        double d = 0.95;
        for (i = 1; i < m; ++i) {
            for (j2 = 1; j2 <= n; ++j2) {
                double du_dr = 0.5 * (u[j2][i + 1] - u[j2][i - 1]);
                double d2u_drsq = u[j2][i + 1] - 2.0 * u[j2][i] + u[j2][i - 1];
                double d2u_dthsq = u[j2 + 1][i] - 2.0 * u[j2][i] + u[j2 - 1][i];
                v[j2][i] = d * v[j2][i] + asq * dt * (d2u_drsq + du_dr / (double)i + d2u_dthsq / (double)(i * i));
            }
        }
        for (i = 1; i < m; ++i) {
            for (j2 = 1; j2 <= n; ++j2) {
                double[] dArray = u[j2];
                int n2 = i;
                dArray[n2] = dArray[n2] + v[j2][i] * dt;
            }
        }
        double u0 = 0.0;
        double v0 = 0.0;
        for (j = 1; j <= n; ++j) {
            u0 += u[j][1];
            v0 += v[j][1];
        }
        u0 /= (double)n;
        v0 /= (double)n;
        for (j = 1; j <= n; ++j) {
            u[j][0] = u0;
            v[j][0] = v0;
        }
    }

    void dumpGrid(String label, double[][] g) {
        System.out.printf("SGBaseTE: %s:\n", label);
        int m = 5;
        int n = 32;
        for (int j = 0; j <= n + 1; ++j) {
            for (int i = 0; i <= m; ++i) {
                System.out.printf(" %6.3f", g[j][i]);
            }
            System.out.printf("\n", new Object[0]);
        }
    }

    @Override
    protected IInventory getInventory() {
        return this.inventory;
    }

    public boolean irisIsClosed() {
        return this.hasIrisUpgrade && this.irisPhase <= 30;
    }

    public double getIrisAperture(double t) {
        return ((double)this.lastIrisPhase * (1.0 - t) + (double)this.irisPhase * t) / 60.0;
    }

    void irisUpdate() {
        this.lastIrisPhase = this.irisPhase;
        switch (this.irisState) {
            case Opening: {
                if (this.irisPhase < 60) {
                    ++this.irisPhase;
                    break;
                }
                this.enterIrisState(IrisState.Open);
                break;
            }
            case Closing: {
                if (this.irisPhase > 0) {
                    --this.irisPhase;
                    break;
                }
                this.enterIrisState(IrisState.Closed);
            }
        }
    }

    void enterIrisState(IrisState newState) {
        if (this.irisState != newState) {
            String oldDesc = SGBaseTE.irisStateDescription(this.irisState);
            String newDesc = SGBaseTE.irisStateDescription(newState);
            this.irisState = newState;
            this.markChanged();
            if (!this.field_145850_b.field_72995_K) {
                switch (newState) {
                    case Opening: {
                        this.playSGSoundEffect(irisOpenSound, 1.0f, 1.0f);
                        break;
                    }
                    case Closing: {
                        this.playSGSoundEffect(irisCloseSound, 1.0f, 1.0f);
                    }
                }
            }
            if (!oldDesc.equals(newDesc)) {
                this.postEvent("sgIrisStateChange", newDesc, oldDesc);
            }
        }
    }

    public void openIris() {
        if (this.isMerged && this.hasIrisUpgrade && this.irisState != IrisState.Open) {
            this.enterIrisState(IrisState.Opening);
        }
    }

    public void closeIris() {
        if (this.isMerged && this.hasIrisUpgrade && this.irisState != IrisState.Closed) {
            this.enterIrisState(IrisState.Closing);
        }
    }

    public void onNeighborBlockChange() {
        boolean newInput;
        if (!this.field_145850_b.field_72995_K && this.redstoneInput != (newInput = BaseBlockUtils.blockIsGettingExternallyPowered(this.field_145850_b, this.field_174879_c))) {
            this.redstoneInput = newInput;
            this.func_70296_d();
            if (this.redstoneInput) {
                this.closeIris();
            } else {
                this.openIris();
            }
        }
    }

    void updateIrisEntity() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.isMerged && this.hasIrisUpgrade) {
                if (!this.hasIrisEntity()) {
                    IrisEntity ent = new IrisEntity(this);
                    this.field_145850_b.func_72838_d((Entity)ent);
                }
            } else {
                for (IrisEntity ent : this.findIrisEntities()) {
                    this.field_145850_b.func_72900_e((Entity)ent);
                }
            }
        }
    }

    boolean hasIrisEntity() {
        return this.findIrisEntities().size() != 0;
    }

    List<IrisEntity> findIrisEntities() {
        int x = this.field_174879_c.func_177958_n();
        int y = this.field_174879_c.func_177956_o();
        int z = this.field_174879_c.func_177952_p();
        AxisAlignedBB box = new AxisAlignedBB((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 2), (double)(z + 1));
        return this.field_145850_b.func_72872_a(IrisEntity.class, box);
    }

    ItemStack getCamouflageStack(BlockPos cpos) {
        int i;
        Trans3 t = this.localToGlobalTransformation();
        Vector3 p = t.ip(Vector3.blockCenter(cpos));
        if (p.y == 0.0 && (i = 2 + p.roundX()) >= 0 && i < 5) {
            return this.func_70301_a(0 + i);
        }
        return null;
    }

    boolean isCamouflageSlot(int slot) {
        return slot >= 0 && slot < 5;
    }

    @Override
    protected void onInventoryChanged(int slot) {
        super.onInventoryChanged(slot);
        if (this.isCamouflageSlot(slot)) {
            for (int dx = -2; dx <= 2; ++dx) {
                for (int dz = -2; dz <= 2; ++dz) {
                    BaseBlockUtils.markBlockForUpdate(this.field_145850_b, this.field_174879_c.func_177982_a(dx, 0, dz));
                }
            }
        }
    }

    public int numItemsInSlot(int slot) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            return stack.func_190916_E();
        }
        return 0;
    }

    protected int baseCornerCamouflage() {
        return BaseUtils.max(this.baseCamouflageAt(0), this.baseCamouflageAt(4));
    }

    protected int baseCamouflageAt(int i) {
        ItemStack stack = this.func_70301_a(i);
        if (stack != null) {
            Item item = stack.func_77973_b();
            Block block = Block.func_149634_a((Item)stack.func_77973_b());
            if (block != null) {
                if (block instanceof BlockSlab) {
                    return 1;
                }
                int meta = item.getMetadata(stack);
                IBlockState state = block.func_176203_a(meta);
                if (block.func_149686_d(state)) {
                    return 2;
                }
            }
        }
        return 0;
    }

    public Collection<BlockRef> adjacentTiles() {
        ArrayList<BlockRef> result = new ArrayList<BlockRef>();
        Trans3 t = this.localToGlobalTransformation();
        for (int i = -2; i <= 2; ++i) {
            BlockPos bp = t.p(i, -1.0, 0.0).blockPos();
            TileEntity te = BaseBlockUtils.getWorldTileEntity((IBlockAccess)this.field_145850_b, bp);
            if (te == null) continue;
            result.add(new BlockRef(te));
        }
        return result;
    }

    public void forwardNetworkPacket(Object packet) {
        SGBaseTE dte = this.getConnectedStargateTE();
        if (dte != null) {
            dte.rebroadcastNetworkPacket(packet);
        }
    }

    void rebroadcastNetworkPacket(Object packet) {
        for (BlockRef ref : this.adjacentTiles()) {
            TileEntity te = ref.getTileEntity();
            if (!(te instanceof SGInterfaceTE)) continue;
            ((SGInterfaceTE)te).rebroadcastNetworkPacket(packet);
        }
    }

    public String sendMessage(Object[] args) {
        SGBaseTE dte = this.getConnectedStargateTE();
        if (dte != null) {
            dte.postEvent("sgMessageReceived", args);
            return null;
        }
        return "Stargate not connected";
    }

    void postEvent(String name, Object ... args) {
        for (BlockRef b : this.adjacentTiles()) {
            TileEntity te = b.getTileEntity();
            if (!(te instanceof IComputerInterface)) continue;
            ((IComputerInterface)te).postEvent(this, name, args);
        }
    }

    public String sgStateDescription() {
        return SGBaseTE.sgStateDescription(this.state);
    }

    static String sgStateDescription(SGState state) {
        switch (state) {
            case Idle: {
                return "Idle";
            }
            case Dialling: 
            case InterDialling: {
                return "Dialling";
            }
            case Transient: {
                return "Opening";
            }
            case Connected: {
                return "Connected";
            }
            case Disconnecting: {
                return "Closing";
            }
        }
        return "Unknown";
    }

    public String irisStateDescription() {
        return SGBaseTE.irisStateDescription(this.irisState);
    }

    static String irisStateDescription(IrisState state) {
        return state.toString();
    }

    public static SGBaseTE getBaseTE(SGInterfaceTE ite) {
        return SGBaseTE.get((IBlockAccess)ite.func_145831_w(), ite.func_174877_v().func_177982_a(0, 1, 0));
    }

    static {
        numRingSymbols = SGAddressing.numSymbols;
        ringSymbolAngle = 360.0 / (double)numRingSymbols;
        irisDamageSource = new DamageSource("sgcraft:iris");
        defaultChevronAngle = 40.0f;
        chevronAngles = new float[][]{{45.0f, 45.0f, 40.0f}, {36.0f, 33.0f, 30.0f}};
        maxEnergyBuffer = 1000.0;
        energyPerFuelItem = 96000.0;
        distanceFactorMultiplier = 1.0;
        interDimensionMultiplier = 4.0;
        gateOpeningsPerFuelItem = 24;
        minutesOpenPerFuelItem = 80;
        secondsToStayOpen = 300;
        oneWayTravel = false;
        closeFromEitherEnd = true;
        chunkLoadingRange = 1;
        logStargateEvents = false;
        preserveInventory = false;
        soundVolume = 1.0f;
        variableChevronPositions = true;
        transparency = true;
        random = new Random();
        transientDamage = new DamageSource("sgcraft:transient");
        rdx = new int[]{1, 0, -1, 0};
        rdz = new int[]{0, -1, 0, 1};
    }

    class TrackedEntity {
        public Entity entity;
        public Vector3 lastPos;

        public TrackedEntity(Entity entity) {
            this.entity = entity;
            this.lastPos = new Vector3(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        }
    }
}

