/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg;

import gcewing.sg.BaseBlock;
import gcewing.sg.BaseBlockUtils;
import gcewing.sg.BaseConfiguration;
import gcewing.sg.BaseMod;
import gcewing.sg.BaseOrientation;
import gcewing.sg.SGBaseTE;
import gcewing.sg.SGBlock;
import gcewing.sg.SGCraft;
import gcewing.sg.SGGui;
import gcewing.sg.SGRingBlock;
import gcewing.sg.SGState;
import gcewing.sg.Trans3;
import gcewing.sg.Vector3;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class SGBaseBlock
extends SGBlock<SGBaseTE> {
    static boolean debugMerge = false;
    static int explosionRadius = 10;
    static boolean fieryExplosion = true;
    static boolean smokyExplosion = true;
    static int[][] pattern = new int[][]{{2, 1, 2, 1, 2}, {1, 0, 0, 0, 1}, {2, 0, 0, 0, 2}, {1, 0, 0, 0, 1}, {2, 1, 0, 1, 2}};
    protected static String[] textures = new String[]{"stargateblock", "stargatering", "stargatebase_front"};
    protected static BaseMod.ModelSpec model = new BaseMod.ModelSpec("block/sg_base_block.smeg", textures);
    protected static Trans3 itemTrans = Trans3.sideTurn(0, 2);

    public static void configure(BaseConfiguration config) {
        explosionRadius = config.getInteger("stargate", "explosionRadius", explosionRadius);
        fieryExplosion = config.getBoolean("stargate", "explosionFlame", fieryExplosion);
        smokyExplosion = config.getBoolean("stargate", "explosionSmoke", smokyExplosion);
    }

    public SGBaseBlock() {
        super(Material.field_151576_e, SGBaseTE.class);
        this.func_149711_c(1.5f);
        this.func_149647_a(CreativeTabs.field_78026_f);
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return true;
    }

    @Override
    public BaseBlock.IOrientationHandler getOrientationHandler() {
        return BaseOrientation.orient4WaysByState;
    }

    @Override
    public String[] getTextureNames() {
        return textures;
    }

    @Override
    public BaseMod.ModelSpec getModelSpec(IBlockState state) {
        return model;
    }

    @Override
    public SGBaseTE getBaseTE(IBlockAccess world, BlockPos pos) {
        return (SGBaseTE)this.getTileEntity(world, pos);
    }

    @Override
    protected String getRendererClassName() {
        return "SGRingBlockRenderer";
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    public boolean canHarvestBlock(IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return true;
    }

    @Override
    public boolean isMerged(IBlockAccess world, BlockPos pos) {
        SGBaseTE te = (SGBaseTE)this.getTileEntity(world, pos);
        return te != null && te.isMerged;
    }

    @Override
    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        if (debugMerge) {
            System.out.printf("SGBaseBlock.onBlockAdded: at %d\n", pos);
        }
        this.checkForMerge(world, pos);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float cx, float cy, float cz) {
        String Side2 = world.field_72995_K ? "Client" : "Server";
        SGBaseTE te = (SGBaseTE)this.getTileEntity((IBlockAccess)world, pos);
        if (te != null) {
            if (debugMerge) {
                System.out.printf("SGBaseBlock.onBlockActivated: %s: isMerged = %s\n", Side2, te.isMerged);
            }
            if (te.isMerged) {
                SGCraft.mod.openGui(player, (Enum)SGGui.SGBase, world, pos);
                return true;
            }
        }
        return false;
    }

    public boolean getWeakChanges(IBlockAccess world, BlockPos pos) {
        return true;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos from) {
        System.out.printf("SGBaseBlock.neighborChanged: %s\n", pos);
        this.neighbourChanged((IBlockAccess)world, pos);
    }

    protected void neighbourChanged(IBlockAccess world, BlockPos pos) {
        SGBaseTE te = (SGBaseTE)this.getTileEntity(world, pos);
        if (te != null) {
            te.onNeighborBlockChange();
        }
    }

    void checkForMerge(World world, BlockPos pos) {
        if (debugMerge) {
            System.out.printf("SGBaseBlock.checkForMerge at %s\n", pos);
        }
        if (!this.isMerged((IBlockAccess)world, pos)) {
            Trans3 t = this.localToGlobalTransformation((IBlockAccess)world, pos);
            for (int i = -2; i <= 2; ++i) {
                for (int j = 0; j <= 4; ++j) {
                    if (i == 0 && j == 0) continue;
                    BlockPos rp = t.p(i, j, 0.0).blockPos();
                    int type = this.getRingBlockType(world, rp);
                    int pat = pattern[4 - j][2 + i];
                    if (pat == 0 || type == pat) continue;
                    if (debugMerge) {
                        System.out.printf("SGBaseBlock: world %d != pattern %d at %s\n", type, pattern[j][2 + i], rp);
                    }
                    return;
                }
            }
            if (debugMerge) {
                System.out.printf("SGBaseBlock: Merging\n", new Object[0]);
            }
            SGBaseTE te = (SGBaseTE)this.getTileEntity((IBlockAccess)world, pos);
            te.setMerged(true);
            BaseBlockUtils.markBlockForUpdate(world, pos);
            for (int i = -2; i <= 2; ++i) {
                for (int j = 0; j <= 4; ++j) {
                    BlockPos rp;
                    Block block;
                    if (i == 0 && j == 0 || !((block = world.func_180495_p(rp = t.p(i, j, 0.0).blockPos()).func_177230_c()) instanceof SGRingBlock)) continue;
                    ((SGRingBlock)block).mergeWith(world, rp, pos);
                }
            }
            te.checkForLink();
        }
    }

    int getRingBlockType(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block == Blocks.field_150350_a) {
            return 0;
        }
        if (block == SGCraft.sgRingBlock && !SGCraft.sgRingBlock.isMerged((IBlockAccess)world, pos)) {
            switch ((Integer)state.func_177229_b(SGRingBlock.VARIANT)) {
                case 0: {
                    return 1;
                }
                case 1: {
                    return 2;
                }
            }
        }
        return -1;
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        this.unmerge(world, pos);
        this.dropUpgrades(world, pos);
        super.func_180663_b(world, pos, state);
    }

    void dropUpgrades(World world, BlockPos pos) {
        SGBaseTE te = (SGBaseTE)this.getTileEntity((IBlockAccess)world, pos);
        if (te != null) {
            if (te.hasChevronUpgrade) {
                SGBaseBlock.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack(SGCraft.sgChevronUpgrade));
            }
            if (te.hasIrisUpgrade) {
                SGBaseBlock.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack(SGCraft.sgIrisUpgrade));
            }
        }
    }

    public void unmerge(World world, BlockPos pos) {
        SGBaseTE te = (SGBaseTE)this.getTileEntity((IBlockAccess)world, pos);
        boolean goBang = false;
        if (te != null) {
            if (te.isMerged && te.state == SGState.Connected) {
                te.state = SGState.Idle;
                goBang = true;
            }
            te.disconnect();
            te.unlinkFromController();
            te.setMerged(false);
            BaseBlockUtils.markBlockForUpdate(world, pos);
            this.unmergeRing(world, pos);
        }
        if (goBang && explosionRadius > 0) {
            this.explode(world, new Vector3((Vec3i)pos).add(0.5, 2.5, 0.5), explosionRadius);
        }
    }

    void explode(World world, Vector3 p, double s) {
        world.func_72885_a(null, p.x, p.y, p.z, (float)s, fieryExplosion, smokyExplosion);
    }

    void unmergeRing(World world, BlockPos pos) {
        for (int i = -2; i <= 2; ++i) {
            for (int j = 0; j <= 4; ++j) {
                for (int k = -2; k <= 2; ++k) {
                    this.unmergeRingBlock(world, pos, pos.func_177982_a(i, j, k));
                }
            }
        }
    }

    void unmergeRingBlock(World world, BlockPos pos, BlockPos ringPos) {
        Block block = world.func_180495_p(ringPos).func_177230_c();
        if (debugMerge) {
            System.out.printf("SGBaseBlock.unmergeRingBlock: found %s at %s\n", block, ringPos);
        }
        if (block instanceof SGRingBlock) {
            ((SGRingBlock)block).unmergeFrom(world, ringPos, pos);
        }
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public int func_176211_b(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return this.func_180656_a(state, world, pos, side);
    }

    public int func_180656_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        SGBaseTE te = (SGBaseTE)this.getTileEntity(world, pos);
        return te != null && te.state != SGState.Idle ? 15 : 0;
    }

    @Override
    public Trans3 itemTransformation() {
        return itemTrans;
    }
}

