/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg;

import gcewing.sg.BaseConfiguration;
import gcewing.sg.BaseReflectionUtils;
import gcewing.sg.SGStructureMap;
import java.lang.reflect.Field;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraftforge.event.terraingen.InitMapGenEvent;

public class FeatureGeneration {
    public static boolean augmentStructures = false;
    public static boolean debugStructures = false;
    public static int structureAugmentationChance = 25;
    static Field structureMap = BaseReflectionUtils.getFieldDef(MapGenStructure.class, "structureMap", "field_75053_d");

    public static void configure(BaseConfiguration config) {
        augmentStructures = config.getBoolean("options", "augmentStructures", augmentStructures);
        structureAugmentationChance = config.getInteger("options", "structureAugmentationChance", structureAugmentationChance);
        debugStructures = config.getBoolean("debug", "debugStructures", debugStructures);
    }

    public static void onInitMapGen(InitMapGenEvent e) {
        if (debugStructures) {
            System.out.printf("SGCraft: FeatureGeneration.onInitMapGen: %s\n", e.getType());
        }
        if (augmentStructures) {
            switch (e.getType()) {
                case SCATTERED_FEATURE: {
                    MapGenBase newGen = e.getNewGen();
                    if (newGen instanceof MapGenStructure) {
                        e.setNewGen((MapGenBase)FeatureGeneration.modifyScatteredFeatureGen((MapGenStructure)newGen));
                        if (!debugStructures) break;
                        System.out.printf("SGCraft: FeatureGeneration: Installed SGStructureMap\n", new Object[0]);
                        break;
                    }
                    System.out.printf("SGCraft: FeatureGeneration: SCATTERED_FEATURE generator is not a MapGenStructure, cannot customise\n", new Object[0]);
                }
            }
        }
    }

    static MapGenStructure modifyScatteredFeatureGen(MapGenStructure gen) {
        BaseReflectionUtils.setField(gen, structureMap, (Object)new SGStructureMap());
        return gen;
    }
}

