/*
 * Decompiled with CFR 0.152.
 */
package romelo333.notenoughwands.Items;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import romelo333.notenoughwands.Config;
import romelo333.notenoughwands.Items.GenericWand;
import romelo333.notenoughwands.varia.Tools;

public class MovingWand
extends GenericWand {
    private float maxHardness = 50.0f;
    private int placeDistance = 4;

    public MovingWand() {
        this.setup("moving_wand").xpUsage(3).loot(5);
    }

    @Override
    public void initConfig(Configuration cfg) {
        super.initConfig(cfg, 200, 100000, 100, 200000, 50, 500000);
        this.maxHardness = (float)cfg.get(Config.CATEGORY_WANDS, this.getConfigPrefix() + "_maxHardness", (double)this.maxHardness, "Max hardness this block can move.)").getDouble();
        this.placeDistance = cfg.get(Config.CATEGORY_WANDS, this.getConfigPrefix() + "_placeDistance", this.placeDistance, "Distance at which to place blocks in 'in-air' mode").getInt();
    }

    @Override
    public void func_77624_a(ItemStack stack, World player, List<String> list, ITooltipFlag b) {
        super.func_77624_a(stack, player, list, b);
        NBTTagCompound compound = stack.func_77978_p();
        if (!this.hasBlock(compound)) {
            list.add(TextFormatting.RED + "Wand is empty.");
        } else {
            int id = compound.func_74762_e("block");
            Block block = (Block)Block.field_149771_c.func_148754_a(id);
            int meta = compound.func_74762_e("meta");
            String name = Tools.getBlockName(block, meta);
            list.add(TextFormatting.GREEN + "Block: " + name);
        }
        list.add("Right click to take a block.");
        list.add("Right click again on block to place it down.");
    }

    private boolean hasBlock(NBTTagCompound compound) {
        return compound != null && compound.func_74764_b("block");
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        NBTTagCompound compound;
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K && this.hasBlock(compound = stack.func_77978_p())) {
            int distance;
            Vec3d end;
            Vec3d lookVec = player.func_70040_Z();
            Vec3d start = new Vec3d(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v);
            RayTraceResult position = world.func_72933_a(start, end = start.func_72441_c(lookVec.field_72450_a * (double)(distance = this.placeDistance), lookVec.field_72448_b * (double)distance, lookVec.field_72449_c * (double)distance));
            if (position == null) {
                this.place(stack, world, new BlockPos(end), null, player);
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            NBTTagCompound compound = stack.func_77978_p();
            if (this.hasBlock(compound)) {
                this.place(stack, world, pos, side, player);
            } else {
                this.pickup(stack, player, world, pos);
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return EnumActionResult.SUCCESS;
    }

    private void place(ItemStack stack, World world, BlockPos pos, EnumFacing side, EntityPlayer player) {
        BlockPos pp = side == null ? pos : pos.func_177972_a(side);
        IBlockState old = world.func_180495_p(pp);
        if (!world.func_175623_d(pp) && !old.func_177230_c().func_176200_f((IBlockAccess)world, pp)) {
            Tools.error(player, "Something is in the way!");
            return;
        }
        NBTTagCompound tagCompound = stack.func_77978_p();
        int id = tagCompound.func_74762_e("block");
        Block block = (Block)Block.field_149771_c.func_148754_a(id);
        int meta = tagCompound.func_74762_e("meta");
        IBlockState blockState = block.func_176203_a(meta);
        world.func_180501_a(pp, blockState, 3);
        if (tagCompound.func_74764_b("tedata")) {
            NBTTagCompound tc = (NBTTagCompound)tagCompound.func_74781_a("tedata");
            tc.func_74768_a("x", pp.func_177958_n());
            tc.func_74768_a("y", pp.func_177956_o());
            tc.func_74768_a("z", pp.func_177952_p());
            TileEntity tileEntity = TileEntity.func_190200_a((World)world, (NBTTagCompound)tc);
            if (tileEntity != null) {
                world.func_175726_f(pp).func_150813_a(tileEntity);
                tileEntity.func_70296_d();
                world.func_184138_a(pp, blockState, blockState, 3);
            }
        }
        tagCompound.func_82580_o("block");
        tagCompound.func_82580_o("tedata");
        tagCompound.func_82580_o("meta");
        stack.func_77982_d(tagCompound);
    }

    private void pickup(ItemStack stack, EntityPlayer player, World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        int meta = block.func_176201_c(state);
        double cost = MovingWand.checkPickup(player, world, pos, block, this.maxHardness);
        if (cost < 0.0) {
            return;
        }
        if (!this.checkUsage(stack, player, (float)cost)) {
            return;
        }
        NBTTagCompound tagCompound = Tools.getTagCompound(stack);
        ItemStack s = block.getPickBlock(state, null, world, pos, player);
        String name = s.func_190926_b() ? Tools.getBlockName(block, meta) : s.func_82833_r();
        if (name == null) {
            Tools.error(player, "You cannot select this block!");
        } else {
            int id = Block.field_149771_c.func_148757_b((Object)block);
            tagCompound.func_74768_a("block", id);
            tagCompound.func_74768_a("meta", meta);
            TileEntity tileEntity = world.func_175625_s(pos);
            if (tileEntity != null) {
                NBTTagCompound tc = new NBTTagCompound();
                tileEntity.func_189515_b(tc);
                world.func_175713_t(pos);
                tc.func_82580_o("x");
                tc.func_82580_o("y");
                tc.func_82580_o("z");
                tagCompound.func_74782_a("tedata", (NBTBase)tc);
            }
            world.func_175698_g(pos);
            Tools.notify(player, "You took: " + name);
            this.registerUsage(stack, player, (float)cost);
        }
    }
}

