/*
 * Decompiled with CFR 0.152.
 */
package reauth;

import com.mojang.realmsclient.gui.ChatFormatting;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiMultiplayer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import reauth.CachedProperty;
import reauth.GuiLogin;
import reauth.Secure;
import reauth.VersionChecker;

@Mod.EventBusSubscriber(modid="reauth", value={Side.CLIENT})
public class GuiHandler {
    private static final CachedProperty<ValidationStatus> status = new CachedProperty<ValidationStatus>(300000L, ValidationStatus.Unknown);
    private static Thread validator;
    static boolean enabled;
    static boolean bold;

    @SubscribeEvent
    public static void open(GuiScreenEvent.InitGuiEvent.Post e) {
        boolean run = false;
        if (e.getGui() instanceof GuiMultiplayer) {
            e.getButtonList().add(new GuiButton(17325, 5, 5, 100, 20, "Re-Login"));
            run = true;
            if (enabled && !status.check()) {
                if (validator != null) {
                    validator.interrupt();
                }
                validator = new Thread(() -> status.set(Secure.SessionValid() ? ValidationStatus.Valid : ValidationStatus.Invalid), "Session-Validator");
                validator.setDaemon(true);
                validator.start();
            }
        } else if (e.getGui() instanceof GuiMainMenu) {
            run = true;
            e.getButtonList().add(new GuiButton(17325, -50, -50, 20, 20, "ReAuth"));
        }
        if (run && VersionChecker.shouldRun()) {
            VersionChecker.update();
        }
    }

    @SubscribeEvent
    public static void draw(GuiScreenEvent.DrawScreenEvent.Post e) {
        if (enabled && e.getGui() instanceof GuiMultiplayer) {
            e.getGui().func_73731_b(e.getGui().field_146297_k.field_71466_p, "Online:", 110, 10, -1);
            ValidationStatus state = status.get();
            e.getGui().func_73731_b(e.getGui().field_146297_k.field_71466_p, (bold ? ChatFormatting.BOLD : "") + state.text, 145, 10, state.color);
        }
    }

    @SubscribeEvent
    public static void action(GuiScreenEvent.ActionPerformedEvent.Post e) {
        if ((e.getGui() instanceof GuiMainMenu || e.getGui() instanceof GuiMultiplayer) && e.getButton().field_146127_k == 17325) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiLogin(Minecraft.func_71410_x().field_71462_r));
        }
    }

    @SubscribeEvent
    public static void action(GuiScreenEvent.ActionPerformedEvent.Pre e) {
        if (enabled && e.getGui() instanceof GuiMultiplayer && e.getButton().field_146127_k == 8 && GuiScreen.func_146272_n()) {
            status.invalidate();
        }
    }

    static void invalidateStatus() {
        status.invalidate();
    }

    static {
        enabled = true;
        bold = true;
    }

    private static enum ValidationStatus {
        Unknown("?", Color.GRAY.getRGB()),
        Valid("\u2714", Color.GREEN.getRGB()),
        Invalid("\u2718", Color.RED.getRGB());

        private final String text;
        private final int color;

        private ValidationStatus(String text, int color) {
            this.text = text;
            this.color = color;
        }
    }
}

