/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc.common.event;

import java.util.List;
import java.util.Set;
import li.cil.oc.OpenComputers$;
import li.cil.oc.api.event.RobotMoveEvent;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.Node;
import li.cil.oc.common.event.ChunkloaderUpgradeHandler$;
import li.cil.oc.server.component.UpgradeChunkloader;
import li.cil.oc.util.BlockPosition;
import li.cil.oc.util.BlockPosition$;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.convert.WrapAsScala$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class ChunkloaderUpgradeHandler$
implements ForgeChunkManager.LoadingCallback {
    public static final ChunkloaderUpgradeHandler$ MODULE$;
    private final Map<String, ForgeChunkManager.Ticket> restoredTickets;

    static {
        new ChunkloaderUpgradeHandler$();
    }

    public Map<String, ForgeChunkManager.Ticket> restoredTickets() {
        return this.restoredTickets;
    }

    public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
        WrapAsScala$.MODULE$.asScalaBuffer(tickets).foreach((Function1)new Serializable(){

            public final void apply(ForgeChunkManager.Ticket ticket) {
                NBTTagCompound data = ticket.getModData();
                String address = data.func_74779_i("address");
                ChunkloaderUpgradeHandler$.MODULE$.restoredTickets().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)address), (Object)ticket));
                if (data.func_74764_b("x") && data.func_74764_b("z")) {
                    int x = data.func_74762_e("x");
                    int z = data.func_74762_e("z");
                    OpenComputers$.MODULE$.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Restoring chunk loader ticket for upgrade at chunk (", ", ", ") with address ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)x), BoxesRunTime.boxToInteger((int)z), address})));
                    ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)new ChunkPos(x, z));
                }
            }
        });
    }

    @SubscribeEvent
    public void onWorldSave(WorldEvent.Save e) {
        this.restoredTickets().values().foreach((Function1)new Serializable(){

            public final void apply(ForgeChunkManager.Ticket ticket) {
                try {
                    NBTTagCompound data = ticket.getModData();
                    OpenComputers$.MODULE$.log().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A chunk loader ticket has been orphaned! Address: ", ", position: (", ", ", "). Removing..."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{data.func_74779_i("address"), BoxesRunTime.boxToInteger((int)data.func_74762_e("x")), BoxesRunTime.boxToInteger((int)data.func_74762_e("z"))})));
                    ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
                }
                catch (Throwable throwable) {}
            }
        });
        this.restoredTickets().clear();
    }

    @SubscribeEvent
    public void onMove(RobotMoveEvent.Post e) {
        Node machineNode = e.agent.machine().node();
        WrapAsScala$.MODULE$.iterableAsScalaIterable(machineNode.reachableNodes()).foreach((Function1)new Serializable(){

            public final void apply(Node x$1) {
                Environment environment = x$1.host();
                if (environment instanceof UpgradeChunkloader) {
                    UpgradeChunkloader upgradeChunkloader = (UpgradeChunkloader)environment;
                    ChunkloaderUpgradeHandler$.MODULE$.updateLoadedChunk(upgradeChunkloader);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
        });
    }

    public void updateLoadedChunk(UpgradeChunkloader loader) {
        BlockPosition blockPos = BlockPosition$.MODULE$.apply(loader.host());
        ChunkPos centerChunk = new ChunkPos(blockPos.x() >> 4, blockPos.z() >> 4);
        scala.collection.immutable.Set robotChunks = ((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(-1), 1).flatMap((Function1)new Serializable(centerChunk){
            public final ChunkPos centerChunk$1;

            public final IndexedSeq<ChunkPos> apply(int x) {
                return (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(-1), 1).map((Function1)new Serializable(this, x){
                    private final /* synthetic */ anonfun.1 $outer;
                    private final int x$2;

                    public final ChunkPos apply(int z) {
                        return new ChunkPos(this.$outer.centerChunk$1.field_77276_a + this.x$2, this.$outer.centerChunk$1.field_77275_b + z);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.x$2 = x$2;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
            }
            {
                this.centerChunk$1 = centerChunk$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toSet();
        loader.ticket().foreach((Function1)new Serializable(loader, centerChunk, robotChunks){
            private final UpgradeChunkloader loader$1;
            private final ChunkPos centerChunk$1;
            public final scala.collection.immutable.Set robotChunks$1;

            public final void apply(ForgeChunkManager.Ticket ticket) {
                WrapAsScala$.MODULE$.asScalaSet((Set)ticket.getChunkList()).collect((PartialFunction)new Serializable(this, ticket){
                    private final /* synthetic */ anonfun.updateLoadedChunk.1 $outer;
                    private final ForgeChunkManager.Ticket ticket$1;

                    public final <A1 extends ChunkPos, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1;
                        A1 A12 = x1;
                        if (A12 != null && !this.$outer.robotChunks$1.contains(A1 = A12)) {
                            ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)this.ticket$1, A1);
                            object = BoxedUnit.UNIT;
                        } else {
                            object = function1.apply(x1);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(ChunkPos x1) {
                        ChunkPos chunkPos;
                        ChunkPos chunkPos2 = x1;
                        boolean bl = chunkPos2 != null && !this.$outer.robotChunks$1.contains((Object)(chunkPos = chunkPos2));
                        return bl;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.ticket$1 = ticket$1;
                    }
                }, Set$.MODULE$.canBuildFrom());
                this.robotChunks$1.foreach((Function1)new Serializable(this, ticket){
                    private final ForgeChunkManager.Ticket ticket$1;

                    public final void apply(ChunkPos chunk) {
                        ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.ticket$1, (ChunkPos)chunk);
                    }
                    {
                        this.ticket$1 = ticket$1;
                    }
                });
                ticket.getModData().func_74778_a("address", this.loader$1.node().address());
                ticket.getModData().func_74768_a("x", this.centerChunk$1.field_77276_a);
                ticket.getModData().func_74768_a("z", this.centerChunk$1.field_77275_b);
            }
            {
                this.loader$1 = loader$1;
                this.centerChunk$1 = centerChunk$1;
                this.robotChunks$1 = robotChunks$1;
            }
        });
    }

    private ChunkloaderUpgradeHandler$() {
        MODULE$ = this;
        this.restoredTickets = Map$.MODULE$.empty();
    }
}

