/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.structures.lib;

import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

public final class RenderUtil {
    public static final float QUARTER = 90.0f;
    public static final float HALF = 180.0f;

    private RenderUtil() {
        throw new IllegalArgumentException("Utility Class");
    }

    public static void applyRotationToYAxis(@NotNull Rotation rotation) {
        float angle;
        GlStateManager.func_179109_b((float)0.5f, (float)0.0f, (float)0.5f);
        switch (rotation) {
            case NONE: {
                angle = 0.0f;
                break;
            }
            case CLOCKWISE_90: {
                angle = -90.0f;
                break;
            }
            case CLOCKWISE_180: {
                angle = -180.0f;
                break;
            }
            case COUNTERCLOCKWISE_90: {
                angle = 90.0f;
                break;
            }
            default: {
                angle = 0.0f;
            }
        }
        GlStateManager.func_179114_b((float)angle, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)-0.5f, (float)0.0f, (float)-0.5f);
    }

    public static void applyMirror(@NotNull Mirror mirror, @NotNull BlockPos appliedPrimaryBlockOff) {
        switch (mirror) {
            case NONE: {
                GlStateManager.func_179152_a((float)1.0f, (float)1.0f, (float)1.0f);
                break;
            }
            case FRONT_BACK: {
                GlStateManager.func_179109_b((float)(2 * appliedPrimaryBlockOff.func_177958_n() + 1), (float)0.0f, (float)0.0f);
                GlStateManager.func_179152_a((float)-1.0f, (float)1.0f, (float)1.0f);
                break;
            }
            case LEFT_RIGHT: {
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)(2 * appliedPrimaryBlockOff.func_177952_p() + 1));
                GlStateManager.func_179152_a((float)1.0f, (float)1.0f, (float)-1.0f);
                break;
            }
        }
    }
}

