/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.structures.client;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.minecolonies.blockout.Log;
import com.minecolonies.structures.client.TemplateBlockAccess;
import com.minecolonies.structures.client.TemplateBlockAccessTransformHandler;
import com.minecolonies.structures.client.TemplateTessellator;
import com.minecolonies.structures.lib.TemplateUtils;
import java.util.concurrent.ExecutionException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.Vector3d;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.gen.structure.template.Template;

public final class TemplateRenderHandler {
    private static final TemplateRenderHandler ourInstance = new TemplateRenderHandler();
    private final Cache<Template, TemplateTessellator> templateBufferBuilderCache = CacheBuilder.newBuilder().maximumSize(50L).removalListener(notification -> ((TemplateTessellator)notification.getValue()).getBuffer().func_177362_c()).build();
    private BlockRendererDispatcher rendererDispatcher;

    private TemplateRenderHandler() {
    }

    public static TemplateRenderHandler getInstance() {
        return ourInstance;
    }

    public void draw(Template template, Rotation rotation, Mirror mirror, Vector3d drawingOffset) {
        if (this.rendererDispatcher == null) {
            this.rendererDispatcher = Minecraft.func_71410_x().func_175602_ab();
        }
        TemplateBlockAccess blockAccess = new TemplateBlockAccess(template);
        try {
            ((TemplateTessellator)this.templateBufferBuilderCache.get((Object)template, () -> {
                TemplateTessellator tessellator = new TemplateTessellator();
                tessellator.getBuilder().func_181668_a(7, DefaultVertexFormats.field_176600_a);
                template.field_186270_a.stream().map(b -> TemplateBlockAccessTransformHandler.getInstance().Transform((Template.BlockInfo)b)).forEach(b -> this.rendererDispatcher.func_175018_a(b.field_186243_b, b.field_186242_a, (IBlockAccess)blockAccess, tessellator.getBuilder()));
                return tessellator;
            })).draw(rotation, mirror, drawingOffset, TemplateUtils.getPrimaryBlockOffset(template));
        }
        catch (ExecutionException e) {
            Log.getLogger().error((Object)e);
        }
    }
}

