/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.structures.client;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.world.gen.structure.template.Template;
import org.jetbrains.annotations.NotNull;

public class TemplateBlockAccessTransformHandler {
    private static TemplateBlockAccessTransformHandler ourInstance = new TemplateBlockAccessTransformHandler();
    private Map<Predicate<Template.BlockInfo>, Function<Template.BlockInfo, Template.BlockInfo>> blockInfoTransformHandler = new HashMap<Predicate<Template.BlockInfo>, Function<Template.BlockInfo, Template.BlockInfo>>();

    public static TemplateBlockAccessTransformHandler getInstance() {
        return ourInstance;
    }

    private TemplateBlockAccessTransformHandler() {
    }

    public void AddTransformHandler(@NotNull Predicate<Template.BlockInfo> transformPredicate, @NotNull Function<Template.BlockInfo, Template.BlockInfo> transformHandler) {
        this.blockInfoTransformHandler.put(transformPredicate, transformHandler);
    }

    public Template.BlockInfo Transform(@NotNull Template.BlockInfo blockInfo) {
        return this.getTransformHandler(blockInfo).apply(blockInfo);
    }

    private Function<Template.BlockInfo, Template.BlockInfo> getTransformHandler(@NotNull Template.BlockInfo blockInfo) {
        return this.blockInfoTransformHandler.keySet().stream().filter(p -> p.test(blockInfo)).findFirst().map(p -> this.blockInfoTransformHandler.get(p)).orElse(Function.identity());
    }
}

