/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.util;

import com.minecolonies.api.configuration.Configurations;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.BlockUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.blocks.AbstractBlockHut;
import com.minecolonies.coremod.blocks.BlockMinecoloniesRack;
import com.minecolonies.coremod.blocks.ModBlocks;
import com.minecolonies.coremod.blocks.schematic.BlockWaypoint;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.placementhandlers.IPlacementHandler;
import com.minecolonies.coremod.placementhandlers.PlacementHandlers;
import com.minecolonies.structures.helpers.StructureProxy;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Mirror;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.Template;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StructureWrapper {
    private static final BlockPos NULL_POS = new BlockPos(-1, -1, -1);
    private final BlockPos.MutableBlockPos progressPos = new BlockPos.MutableBlockPos(-1, -1, -1);
    private final World world;
    private final StructureProxy structure;
    private final String name;
    private BlockPos position;

    public StructureWrapper(World worldObj, String name) {
        this(worldObj, new StructureProxy(worldObj, name), name);
    }

    private StructureWrapper(World worldObj, StructureProxy structure, String name) {
        this.world = worldObj;
        this.structure = structure;
        this.name = name;
    }

    public static void loadAndPlaceStructureWithRotation(World worldObj, @NotNull String name, @NotNull BlockPos pos, int rotations, @NotNull Mirror mirror, boolean complete) {
        try {
            StructureWrapper structureWrapper = new StructureWrapper(worldObj, name);
            structureWrapper.position = pos;
            structureWrapper.rotate(rotations, worldObj, pos, mirror);
            structureWrapper.placeStructure(pos.func_177973_b((Vec3i)structureWrapper.getOffset()), complete);
        }
        catch (IllegalStateException e) {
            Log.getLogger().warn("Could not load structure!", (Throwable)e);
        }
    }

    public void rotate(int times, @NotNull World world, @NotNull BlockPos rotatePos, @NotNull Mirror mirror) {
        this.structure.rotateWithMirror(times, world, rotatePos, mirror);
    }

    private void placeStructure(@NotNull BlockPos pos, boolean complete) {
        TileEntity entity;
        BlockPos localPos;
        this.setLocalPosition(pos);
        ArrayList<BlockPos> delayedBlocks = new ArrayList<BlockPos>();
        for (int j = 0; j < this.structure.getHeight(); ++j) {
            for (int k = 0; k < this.structure.getLength(); ++k) {
                for (int i = 0; i < this.structure.getWidth(); ++i) {
                    localPos = new BlockPos(i, j, k);
                    IBlockState localState = this.structure.getBlockState(localPos);
                    Block localBlock = localState.func_177230_c();
                    BlockPos worldPos = pos.func_177971_a((Vec3i)localPos);
                    if (localBlock == ModBlocks.blockSubstitution && !complete || localBlock instanceof AbstractBlockHut) continue;
                    if (!localState.func_185904_a().func_76220_a()) {
                        delayedBlocks.add(localPos);
                        continue;
                    }
                    this.handleBlockPlacement(worldPos, localState, complete);
                    NBTTagCompound tileEntityData = this.structure.getBlockInfo((BlockPos)localPos).field_186244_c;
                    if (tileEntityData == null) continue;
                    TileEntity entity2 = TileEntity.func_190200_a((World)this.world, (NBTTagCompound)tileEntityData);
                    this.world.func_175690_a(worldPos, entity2);
                    this.world.func_175704_b(worldPos, worldPos);
                }
            }
        }
        for (BlockPos coords : delayedBlocks) {
            IBlockState localState = this.structure.getBlockState(coords);
            BlockPos newWorldPos = pos.func_177971_a((Vec3i)coords);
            this.handleBlockPlacement(newWorldPos, localState, complete);
            NBTTagCompound tileEntityData = this.structure.getBlockInfo((BlockPos)coords).field_186244_c;
            if (tileEntityData == null) continue;
            entity = TileEntity.func_190200_a((World)this.world, (NBTTagCompound)tileEntityData);
            this.world.func_175690_a(newWorldPos, entity);
            this.world.func_175704_b(newWorldPos, newWorldPos);
        }
        for (int j = 0; j < this.structure.getHeight(); ++j) {
            for (int k = 0; k < this.structure.getLength(); ++k) {
                for (int i = 0; i < this.structure.getWidth(); ++i) {
                    localPos = new BlockPos(i, j, k);
                    Template.EntityInfo info = this.structure.getEntityinfo(localPos);
                    if (info == null) continue;
                    try {
                        entity = EntityList.func_75615_a((NBTTagCompound)info.field_186249_c, (World)this.world);
                        entity.func_184221_a(UUID.randomUUID());
                        this.world.func_72838_d((Entity)entity);
                        continue;
                    }
                    catch (RuntimeException e) {
                        Log.getLogger().info("Couldn't restore entitiy", (Throwable)e);
                    }
                }
            }
        }
    }

    public BlockPos getOffset() {
        return this.structure.getOffset();
    }

    private void handleBlockPlacement(BlockPos pos, IBlockState localState, boolean complete) {
        for (IPlacementHandler handlers : PlacementHandlers.handlers) {
            Object result = handlers.handle(this.world, pos, localState, null, true, complete);
            if (result instanceof IBlockState) {
                AbstractBuilding building;
                IBlockState blockState = (IBlockState)result;
                Colony colony = ColonyManager.getColony(this.world, pos);
                if (colony != null && (building = colony.getBuildingManager().getBuilding(this.position)) != null) {
                    building.registerBlockPosition(blockState, pos, this.world);
                }
                return;
            }
            if (result instanceof IPlacementHandler.ActionProcessingResult && result == IPlacementHandler.ActionProcessingResult.IGNORE) continue;
            return;
        }
    }

    public static boolean tryToLoadAndPlaceSupplyCampWithRotation(World worldObj, @NotNull String name, @NotNull BlockPos pos, int rotations, @NotNull Mirror mirror) {
        try {
            StructureWrapper structureWrapper = new StructureWrapper(worldObj, name);
            structureWrapper.rotate(rotations, worldObj, pos, mirror);
            if (structureWrapper.checkForFreeSpace(pos)) {
                structureWrapper.placeStructure(pos, false);
                return true;
            }
            return false;
        }
        catch (IllegalStateException e) {
            Log.getLogger().warn("Could not load structure!", (Throwable)e);
            return false;
        }
    }

    private boolean checkForFreeSpace(@NotNull BlockPos pos) {
        this.setLocalPosition(pos);
        for (int j = 0; j < this.structure.getHeight(); ++j) {
            for (int k = 0; k < this.structure.getLength(); ++k) {
                for (int i = 0; i < this.structure.getWidth(); ++i) {
                    BlockPos localPos = new BlockPos(i, j, k);
                    BlockPos worldPos = pos.func_177971_a((Vec3i)localPos);
                    if (worldPos.func_177956_o() <= pos.func_177956_o() && !this.world.func_180495_p(worldPos.func_177977_b()).func_185904_a().func_76220_a()) {
                        return false;
                    }
                    IBlockState worldState = this.world.func_180495_p(worldPos);
                    if (worldState.func_177230_c() == Blocks.field_150357_h) {
                        return false;
                    }
                    if (worldPos.func_177956_o() <= pos.func_177956_o() || worldState.func_177230_c() == Blocks.field_150350_a) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public boolean findNextBlock() {
        int count = 0;
        do {
            ++count;
            if (this.incrementBlock()) continue;
            return false;
        } while (this.isStructureBlockEqualWorldBlock() && count < Configurations.gameplay.maxBlocksCheckedByBuilder);
        return true;
    }

    public boolean incrementBlock() {
        if (this.progressPos.equals((Object)NULL_POS)) {
            this.progressPos.func_181079_c(-1, 0, 0);
        }
        this.progressPos.func_181079_c(this.progressPos.func_177958_n() + 1, this.progressPos.func_177956_o(), this.progressPos.func_177952_p());
        if (this.progressPos.func_177958_n() == this.structure.getWidth()) {
            this.progressPos.func_181079_c(0, this.progressPos.func_177956_o(), this.progressPos.func_177952_p() + 1);
            if (this.progressPos.func_177952_p() == this.structure.getLength()) {
                this.progressPos.func_181079_c(this.progressPos.func_177958_n(), this.progressPos.func_177956_o() + 1, 0);
                if (this.progressPos.func_177956_o() == this.structure.getHeight()) {
                    this.reset();
                    return false;
                }
            }
        }
        return true;
    }

    public boolean isStructureBlockEqualWorldBlock() {
        IBlockState structureBlockState = this.structure.getBlockState(this.getLocalPosition());
        Block structureBlock = structureBlockState.func_177230_c();
        if (structureBlock == ModBlocks.blockSubstitution) {
            return true;
        }
        BlockPos worldPos = this.getBlockPosition();
        IBlockState worldBlockState = this.world.func_180495_p(worldPos);
        if (structureBlock == ModBlocks.blockSolidSubstitution && worldBlockState.func_185904_a().func_76220_a()) {
            return true;
        }
        Block worldBlock = worldBlockState.func_177230_c();
        if (structureBlock instanceof BlockDoor || structureBlock == Blocks.field_150457_bL) {
            return structureBlock == worldBlock;
        }
        if (worldBlock == ModBlocks.blockRack) {
            return BlockMinecoloniesRack.shouldBlockBeReplacedWithRack(structureBlock);
        }
        if (structureBlock instanceof BlockStairs && structureBlockState == worldBlockState || BlockUtils.isGrassOrDirt(structureBlock, worldBlock, structureBlockState, worldBlockState) || structureBlock instanceof BlockWaypoint) {
            return true;
        }
        Template.EntityInfo entityInfo = this.structure.getEntityinfo(this.getLocalPosition());
        if (entityInfo != null) {
            return false;
        }
        return worldPos.func_177956_o() <= 0 || structureBlockState == worldBlockState;
    }

    public void reset() {
        BlockPosUtil.set(this.progressPos, NULL_POS);
    }

    @NotNull
    public BlockPos getLocalPosition() {
        return this.progressPos.func_185334_h();
    }

    public void setLocalPosition(@NotNull BlockPos localPosition) {
        BlockPosUtil.set(this.progressPos, localPosition);
    }

    public BlockPos getBlockPosition() {
        return this.progressPos.func_177971_a((Vec3i)this.getOffsetPosition());
    }

    public BlockPos getOffsetPosition() {
        return this.position.func_177973_b((Vec3i)this.getOffset());
    }

    public boolean findNextBlockToClear() {
        int count = 0;
        do {
            ++count;
            if (this.decrementBlock()) continue;
            return false;
        } while ((this.worldBlockAir() || this.isStructureBlockEqualWorldBlock()) && count < Configurations.gameplay.maxBlocksCheckedByBuilder);
        return true;
    }

    public boolean findNextBlockSolid() {
        int count = 0;
        do {
            ++count;
            if (this.incrementBlock()) continue;
            return false;
        } while ((this.isStructureBlockEqualWorldBlock() || this.isBlockNonSolid()) && count < Configurations.gameplay.maxBlocksCheckedByBuilder);
        return true;
    }

    private boolean isBlockNonSolid() {
        IBlockState state = this.getBlockState();
        return state != null && !state.func_185904_a().func_76220_a();
    }

    @Nullable
    public IBlockState getBlockState() {
        if (this.progressPos.equals((Object)NULL_POS)) {
            return null;
        }
        return this.structure.getBlockState((BlockPos)this.progressPos);
    }

    public boolean findNextBlockNonSolid() {
        int count = 0;
        do {
            ++count;
            if (this.incrementBlock()) continue;
            return false;
        } while ((this.isStructureBlockEqualWorldBlock() || this.isBlockSolid()) && count < Configurations.gameplay.maxBlocksCheckedByBuilder);
        return true;
    }

    private boolean isBlockSolid() {
        IBlockState state = this.getBlockState();
        return state != null && state.func_185904_a().func_76220_a();
    }

    public boolean decrementBlock() {
        if (this.progressPos.equals((Object)NULL_POS)) {
            this.progressPos.func_181079_c(this.structure.getWidth(), this.structure.getHeight() - 1, this.structure.getLength() - 1);
        }
        this.progressPos.func_181079_c(this.progressPos.func_177958_n() - 1, this.progressPos.func_177956_o(), this.progressPos.func_177952_p());
        if (this.progressPos.func_177958_n() == -1) {
            this.progressPos.func_181079_c(this.structure.getWidth() - 1, this.progressPos.func_177956_o(), this.progressPos.func_177952_p() - 1);
            if (this.progressPos.func_177952_p() == -1) {
                this.progressPos.func_181079_c(this.progressPos.func_177958_n(), this.progressPos.func_177956_o() - 1, this.structure.getLength() - 1);
                if (this.progressPos.func_177956_o() == -1) {
                    this.reset();
                    return false;
                }
            }
        }
        return true;
    }

    private boolean worldBlockAir() {
        BlockPos pos = this.getBlockPosition();
        return pos.func_177956_o() <= 0 || this.world.func_175623_d(pos);
    }

    @NotNull
    public List<Template.EntityInfo> getEntities() {
        return this.structure.getTileEntities();
    }

    public BlockPos getPosition() {
        if (this.position == null) {
            return new BlockPos(0, 0, 0);
        }
        return this.position;
    }

    public void setPosition(BlockPos position) {
        this.position = position;
    }

    @Nullable
    public Item getItem() {
        Block block = this.getBlock();
        IBlockState blockState = this.getBlockState();
        if (block == null || blockState == null || block == Blocks.field_150350_a || blockState.func_185904_a().func_76224_d()) {
            return null;
        }
        ItemStack stack = BlockUtils.getItemStackFromBlockState(blockState);
        if (!ItemStackUtils.isEmpty(stack).booleanValue()) {
            return stack.func_77973_b();
        }
        return null;
    }

    @Nullable
    public Block getBlock() {
        IBlockState state = this.getBlockState();
        if (state == null) {
            return null;
        }
        return state.func_177230_c();
    }

    public String getName() {
        return this.name;
    }

    public int getHeight() {
        return this.structure.getHeight();
    }

    public int getWidth() {
        return this.structure.getWidth();
    }

    public int getLength() {
        return this.structure.getLength();
    }

    public StructureProxy getStructure() {
        return this.structure;
    }

    @Nullable
    public Template.BlockInfo getBlockInfo() {
        if (this.progressPos.equals((Object)NULL_POS)) {
            return null;
        }
        return this.structure.getBlockInfo((BlockPos)this.progressPos);
    }

    @Nullable
    public Template.EntityInfo getEntityinfo() {
        if (this.progressPos.equals((Object)NULL_POS)) {
            return null;
        }
        return this.structure.getEntityinfo((BlockPos)this.progressPos);
    }
}

