/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.sounds;

import com.minecolonies.coremod.sounds.AbstractWorkerSounds;
import com.minecolonies.coremod.sounds.ModSoundEvents;
import com.minecolonies.coremod.util.SoundUtils;
import java.util.Random;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public final class ArcherSounds
extends AbstractWorkerSounds {
    private static final int NUMBER_OF_SOUNDS = 3;
    private static final Random rand = new Random();

    @Override
    public void playSound(World worldIn, BlockPos position, boolean isFemale, double saturation) {
        if (!isFemale) {
            return;
        }
        switch (rand.nextInt(4)) {
            case 1: {
                SoundEvent noises = Female.noises;
                SoundUtils.playSoundAtCitizenWithChance(worldIn, position, noises, this.getBasicSoundChance());
                break;
            }
            case 2: {
                this.playSaturationSound(worldIn, position, isFemale, saturation);
                break;
            }
            case 3: {
                SoundEvent greeting = Female.greeting;
                SoundUtils.playSoundAtCitizenWithChance(worldIn, position, greeting, this.getBasicSoundChance() * 2);
                break;
            }
            case 4: {
                SoundEvent farewell = Female.farewell;
                SoundUtils.playSoundAtCitizenWithChance(worldIn, position, farewell, this.getBasicSoundChance());
                break;
            }
            default: {
                SoundEvent generalPhrases = Female.generalPhrases;
                SoundUtils.playSoundAtCitizenWithChance(worldIn, position, generalPhrases, this.getPhraseChance());
            }
        }
    }

    @Override
    public String getWorkerString() {
        return "archer";
    }

    @Override
    public void playInteractionSound(World worldIn, BlockPos position, boolean isFemale) {
        if (!isFemale) {
            return;
        }
        SoundUtils.playSoundAtCitizenWithChance(worldIn, position, Female.interaction, this.getBasicSoundChance());
    }

    public void playSaturationSound(World worldIn, BlockPos position, boolean isFemale, double saturation) {
        if (!isFemale) {
            return;
        }
        SoundEvent saturationFeedback = saturation < 3.0 ? Female.saturationVeryLow : (saturation < 5.0 ? Female.saturationLow : Female.saturationHigh);
        SoundUtils.playSoundAtCitizenWithChance(worldIn, position, saturationFeedback, this.getBasicSoundChance());
    }

    public static final class Male {
        private Male() {
        }
    }

    public static final class Female {
        public static final SoundEvent generalPhrases = ModSoundEvents.getSoundID("mob.guard.archer.female.generalPhrases");
        public static final SoundEvent noises = ModSoundEvents.getSoundID("mob.guard.archer.female.noise");
        public static final SoundEvent retrieve = ModSoundEvents.getSoundID("mob.guard.archer.female.retrieve");
        public static final SoundEvent offToBed = ModSoundEvents.getSoundID("mob.guard.archer.female.offToBed");
        public static final SoundEvent badWeather = ModSoundEvents.getSoundID("mob.guard.archer.female.badWeather");
        public static final SoundEvent saturationVeryLow = ModSoundEvents.getSoundID("mob.guard.archer.female.saturationVeryLow");
        public static final SoundEvent saturationLow = ModSoundEvents.getSoundID("mob.guard.archer.female.saturationLow");
        public static final SoundEvent saturationHigh = ModSoundEvents.getSoundID("mob.guard.archer.female.saturationHigh");
        public static final SoundEvent levelUp = ModSoundEvents.getSoundID("mob.guard.archer.female.levelup");
        public static final SoundEvent greeting = ModSoundEvents.getSoundID("mob.guard.archer.female.greeting");
        public static final SoundEvent farewell = ModSoundEvents.getSoundID("mob.guard.archer.female.farewell");
        public static final SoundEvent interaction = ModSoundEvents.getSoundID("mob.guard.archer.female.interaction");

        private Female() {
        }
    }
}

