/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.permissions;

import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.configuration.Configurations;
import com.minecolonies.api.util.EntityUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.coremod.blocks.AbstractBlockHut;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.jobs.AbstractJobGuard;
import com.minecolonies.coremod.colony.permissions.PermissionEvent;
import com.minecolonies.coremod.colony.permissions.Permissions;
import com.minecolonies.coremod.entity.EntityCitizen;
import com.minecolonies.coremod.items.ItemScanTool;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColonyPermissionEventHandler {
    private final Colony colony;

    public ColonyPermissionEventHandler(Colony colony) {
        this.colony = colony;
    }

    @SubscribeEvent
    public void on(BlockEvent.PlaceEvent event) {
        Action action;
        Action action2 = action = event.getPlacedBlock().func_177230_c() instanceof AbstractBlockHut ? Action.PLACE_HUTS : Action.PLACE_BLOCKS;
        if (Configurations.gameplay.enableColonyProtection && this.checkBlockEventDenied(event.getWorld(), event.getPos(), event.getPlayer(), event.getPlacedBlock(), action)) {
            ColonyPermissionEventHandler.cancelEvent((Event)event, event.getPlayer(), this.colony, action, event.getPos());
        }
    }

    private boolean checkBlockEventDenied(World worldIn, BlockPos posIn, EntityPlayer playerIn, IBlockState blockState, Action action) {
        EntityPlayer player = EntityUtils.getPlayerOfFakePlayer(playerIn, worldIn);
        if (this.colony.isCoordInColony(worldIn, posIn)) {
            if (!this.colony.getPermissions().isColonyMember(player)) {
                return true;
            }
            if (blockState.func_177230_c() instanceof AbstractBlockHut && this.colony.getPermissions().hasPermission(player, action)) {
                return false;
            }
            return !this.colony.getPermissions().hasPermission(player, action);
        }
        return false;
    }

    private static void cancelEvent(Event event, @Nullable EntityPlayer player, Colony colony, Action action, BlockPos pos) {
        event.setResult(Event.Result.DENY);
        if (event.isCancelable()) {
            event.setCanceled(true);
            if (player == null) {
                if (colony.hasTownHall()) {
                    colony.getBuildingManager().getTownHall().addPermissionEvent(new PermissionEvent(null, "-", action, pos));
                }
                return;
            }
            if (colony.hasTownHall()) {
                colony.getBuildingManager().getTownHall().addPermissionEvent(new PermissionEvent(player.func_110124_au(), player.func_70005_c_(), action, pos));
            }
            if (player instanceof FakePlayer) {
                return;
            }
            LanguageHandler.sendPlayerMessage(player, "com.minecolonies.coremod.permission.no", new Object[0]);
        }
    }

    @SubscribeEvent
    public void on(BlockEvent.BreakEvent event) {
        Action action;
        Action action2 = action = event.getWorld().func_180495_p(event.getPos()).func_177230_c() instanceof AbstractBlockHut ? Action.BREAK_HUTS : Action.BREAK_BLOCKS;
        if (Configurations.gameplay.enableColonyProtection && this.checkBlockEventDenied(event.getWorld(), event.getPos(), event.getPlayer(), event.getWorld().func_180495_p(event.getPos()), action)) {
            ColonyPermissionEventHandler.cancelEvent((Event)event, event.getPlayer(), this.colony, action, event.getPos());
        }
    }

    @SubscribeEvent
    public void on(ExplosionEvent.Detonate event) {
        if (!Configurations.gameplay.turnOffExplosionsInColonies) {
            return;
        }
        World eventWorld = event.getWorld();
        Predicate<BlockPos> getBlocksInColony = pos -> this.colony.isCoordInColony(eventWorld, (BlockPos)pos);
        Predicate<Entity> getEntitiesInColony = entity -> this.colony.isCoordInColony(entity.func_130014_f_(), entity.func_180425_c());
        List blocksToRemove = event.getAffectedBlocks().stream().filter(getBlocksInColony).collect(Collectors.toList());
        List entitiesToRemove = event.getAffectedEntities().stream().filter(getEntitiesInColony).collect(Collectors.toList());
        event.getAffectedBlocks().removeAll(blocksToRemove);
        event.getAffectedEntities().removeAll(entitiesToRemove);
    }

    @SubscribeEvent
    public void on(ExplosionEvent.Start event) {
        if (Configurations.gameplay.enableColonyProtection && Configurations.gameplay.turnOffExplosionsInColonies && this.colony.isCoordInColony(event.getWorld(), new BlockPos(event.getExplosion().getPosition()))) {
            ColonyPermissionEventHandler.cancelEvent((Event)event, null, this.colony, Action.EXPLODE, new BlockPos(event.getExplosion().getPosition()));
        }
    }

    @SubscribeEvent
    public void on(PlayerInteractEvent event) {
        if (this.colony.isCoordInColony(event.getWorld(), event.getPos()) && !(event instanceof PlayerInteractEvent.EntityInteract) && !(event instanceof PlayerInteractEvent.EntityInteractSpecific)) {
            Block block = event.getWorld().func_180495_p(event.getPos()).func_177230_c();
            if (block instanceof AbstractBlockHut && !this.colony.getPermissions().hasPermission(event.getEntityPlayer(), Action.ACCESS_HUTS)) {
                ColonyPermissionEventHandler.cancelEvent((Event)event, event.getEntityPlayer(), this.colony, Action.ACCESS_HUTS, event.getPos());
                return;
            }
            Permissions perms = this.colony.getPermissions();
            if (this.isFreeToInteractWith(block, event.getPos()) && perms.hasPermission(event.getEntityPlayer(), Action.ACCESS_FREE_BLOCKS)) {
                return;
            }
            if (Configurations.gameplay.enableColonyProtection) {
                if (!perms.hasPermission(event.getEntityPlayer(), Action.RIGHTCLICK_BLOCK) && block != null && block != Blocks.field_150350_a) {
                    ColonyPermissionEventHandler.cancelEvent((Event)event, event.getEntityPlayer(), this.colony, Action.RIGHTCLICK_BLOCK, event.getPos());
                    return;
                }
                if (block instanceof BlockContainer && !perms.hasPermission(event.getEntityPlayer(), Action.OPEN_CONTAINER)) {
                    ColonyPermissionEventHandler.cancelEvent((Event)event, event.getEntityPlayer(), this.colony, Action.OPEN_CONTAINER, event.getPos());
                    return;
                }
                if (event.getWorld().func_175625_s(event.getPos()) != null && !perms.hasPermission(event.getEntityPlayer(), Action.RIGHTCLICK_ENTITY)) {
                    ColonyPermissionEventHandler.cancelEvent((Event)event, event.getEntityPlayer(), this.colony, Action.RIGHTCLICK_ENTITY, event.getPos());
                    return;
                }
                ItemStack stack = event.getItemStack();
                if (ItemStackUtils.isEmpty(stack).booleanValue() || stack.func_77973_b() instanceof ItemFood) {
                    return;
                }
                if (stack.func_77973_b() instanceof ItemPotion && !perms.hasPermission(event.getEntityPlayer(), Action.THROW_POTION)) {
                    ColonyPermissionEventHandler.cancelEvent((Event)event, event.getEntityPlayer(), this.colony, Action.THROW_POTION, event.getPos());
                    return;
                }
                if (stack.func_77973_b() instanceof ItemScanTool && !perms.hasPermission(event.getEntityPlayer(), Action.USE_SCAN_TOOL)) {
                    ColonyPermissionEventHandler.cancelEvent((Event)event, event.getEntityPlayer(), this.colony, Action.USE_SCAN_TOOL, event.getPos());
                    return;
                }
            }
        }
    }

    private boolean isFreeToInteractWith(@Nullable Block block, BlockPos pos) {
        return block != null && this.colony.getFreeBlocks().stream().anyMatch(b -> b.equals(block)) || this.colony.getFreePositions().stream().anyMatch(position -> position.equals((Object)pos));
    }

    @SubscribeEvent
    public void on(PlayerInteractEvent.EntityInteract event) {
        if (this.isFreeToInteractWith(null, event.getPos()) && this.colony.getPermissions().hasPermission(event.getEntityPlayer(), Action.ACCESS_FREE_BLOCKS)) {
            return;
        }
        this.checkEventCancelation(Action.RIGHTCLICK_ENTITY, event.getEntityPlayer(), event.getWorld(), (Event)event, event.getPos());
    }

    private boolean checkEventCancelation(Action action, @NotNull EntityPlayer playerIn, @NotNull World world, @NotNull Event event, @Nullable BlockPos pos) {
        EntityPlayer player = EntityUtils.getPlayerOfFakePlayer(playerIn, world);
        BlockPos positionToCheck = pos;
        if (null == positionToCheck) {
            positionToCheck = player.func_180425_c();
        }
        if (Configurations.gameplay.enableColonyProtection && this.colony.isCoordInColony(player.func_130014_f_(), positionToCheck) && !this.colony.getPermissions().hasPermission(player, action)) {
            ColonyPermissionEventHandler.cancelEvent(event, player, this.colony, action, positionToCheck);
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public void on(PlayerInteractEvent.EntityInteractSpecific event) {
        if (this.isFreeToInteractWith(null, event.getPos()) && this.colony.getPermissions().hasPermission(event.getEntityPlayer(), Action.ACCESS_FREE_BLOCKS)) {
            return;
        }
        this.checkEventCancelation(Action.RIGHTCLICK_ENTITY, event.getEntityPlayer(), event.getWorld(), (Event)event, event.getPos());
    }

    @SubscribeEvent
    public void on(ItemTossEvent event) {
        if (this.checkEventCancelation(Action.TOSS_ITEM, event.getPlayer(), event.getPlayer().func_130014_f_(), (Event)event, event.getPlayer().func_180425_c())) {
            event.getPlayer().field_71071_by.func_70441_a(event.getEntityItem().func_92059_d());
        }
    }

    @SubscribeEvent
    public void on(EntityItemPickupEvent event) {
        this.checkEventCancelation(Action.PICKUP_ITEM, event.getEntityPlayer(), event.getEntityPlayer().func_130014_f_(), (Event)event, event.getEntityPlayer().func_180425_c());
    }

    @SubscribeEvent
    public void on(FillBucketEvent event) {
        BlockPos targetBlockPos = null;
        if (null != event.getTarget()) {
            targetBlockPos = event.getTarget().func_178782_a();
        }
        this.checkEventCancelation(Action.FILL_BUCKET, event.getEntityPlayer(), event.getEntityPlayer().func_130014_f_(), (Event)event, targetBlockPos);
    }

    @SubscribeEvent
    public void on(ArrowLooseEvent event) {
        this.checkEventCancelation(Action.SHOOT_ARROW, event.getEntityPlayer(), event.getEntityPlayer().func_130014_f_(), (Event)event, event.getEntity().func_180425_c());
    }

    @SubscribeEvent
    public void on(AttackEntityEvent event) {
        if (event.getTarget() instanceof EntityMob) {
            return;
        }
        EntityPlayer player = EntityUtils.getPlayerOfFakePlayer(event.getEntityPlayer(), event.getEntityPlayer().func_130014_f_());
        if (Configurations.gameplay.enableColonyProtection && this.colony.isCoordInColony(player.func_130014_f_(), player.func_180425_c())) {
            Permissions perms = this.colony.getPermissions();
            if (event.getTarget() instanceof EntityCitizen) {
                EntityCitizen citizen = (EntityCitizen)event.getTarget();
                if (citizen.getCitizenJobHandler().getColonyJob() instanceof AbstractJobGuard && perms.hasPermission(event.getEntityPlayer(), Action.GUARDS_ATTACK)) {
                    return;
                }
                if (perms.hasPermission(event.getEntityPlayer(), Action.ATTACK_CITIZEN)) {
                    return;
                }
                ColonyPermissionEventHandler.cancelEvent((Event)event, event.getEntityPlayer(), this.colony, Action.ATTACK_CITIZEN, event.getTarget().func_180425_c());
                return;
            }
            if (!(event.getTarget() instanceof EntityMob) && !perms.hasPermission(event.getEntityPlayer(), Action.ATTACK_ENTITY)) {
                ColonyPermissionEventHandler.cancelEvent((Event)event, event.getEntityPlayer(), this.colony, Action.ATTACK_ENTITY, event.getTarget().func_180425_c());
            }
        }
    }
}

