/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingWareHouse;
import com.minecolonies.coremod.network.messages.AbstractMessage;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class UpgradeWarehouseMessage
extends AbstractMessage<UpgradeWarehouseMessage, IMessage> {
    private BlockPos buildingId;
    private int colonyId;

    public UpgradeWarehouseMessage() {
    }

    public UpgradeWarehouseMessage(@NotNull AbstractBuildingView building) {
        this.colonyId = building.getColony().getID();
        this.buildingId = building.getID();
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.colonyId = buf.readInt();
        this.buildingId = BlockPosUtil.readFromByteBuf(buf);
    }

    public void toBytes(@NotNull ByteBuf buf) {
        buf.writeInt(this.colonyId);
        BlockPosUtil.writeToByteBuf(buf, this.buildingId);
    }

    @Override
    public void messageOnServerThread(UpgradeWarehouseMessage message, EntityPlayerMP player) {
        Colony colony = ColonyManager.getColony(message.colonyId);
        if (colony == null) {
            Log.getLogger().warn("UpgradeWarehouseMessage colony is null");
            return;
        }
        if (!colony.getPermissions().hasPermission((EntityPlayer)player, Action.MANAGE_HUTS)) {
            return;
        }
        AbstractBuilding building = colony.getBuildingManager().getBuilding(message.buildingId);
        if (!(building instanceof BuildingWareHouse)) {
            Log.getLogger().warn("UpgradeWarehouseMessage building is not a Warehouse");
            return;
        }
        ((BuildingWareHouse)building).upgradeContainers(player.field_70170_p);
        boolean isCreative = player.field_71075_bZ.field_75098_d;
        if (!isCreative) {
            int slot = InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)new InvWrapper((IInventory)player.field_71071_by), itemStack -> itemStack.func_77969_a(new ItemStack(Blocks.field_150475_bE)));
            player.field_71071_by.func_70298_a(slot, 1);
        }
    }
}

