/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.BlockUtils;
import com.minecolonies.coremod.network.messages.AbstractMessage;
import com.mojang.authlib.GameProfile;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.BlockBed;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockDoubleStoneSlab;
import net.minecraft.block.BlockDoubleStoneSlabNew;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockRotatedPillar;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemBed;
import net.minecraft.item.ItemDoor;
import net.minecraft.item.ItemSlab;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class ReplaceBlockMessage
extends AbstractMessage<ReplaceBlockMessage, IMessage> {
    private BlockPos from;
    private BlockPos to;
    private ItemStack blockFrom;
    private ItemStack blockTo;

    public ReplaceBlockMessage() {
    }

    public ReplaceBlockMessage(@NotNull BlockPos pos1, @NotNull BlockPos pos2, @NotNull ItemStack blockFrom, @NotNull ItemStack blockTo) {
        this.from = pos1;
        this.to = pos2;
        this.blockFrom = blockFrom;
        this.blockTo = blockTo;
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.from = BlockPosUtil.readFromByteBuf(buf);
        this.to = BlockPosUtil.readFromByteBuf(buf);
        this.blockTo = ByteBufUtils.readItemStack((ByteBuf)buf);
        this.blockFrom = ByteBufUtils.readItemStack((ByteBuf)buf);
    }

    public void toBytes(@NotNull ByteBuf buf) {
        BlockPosUtil.writeToByteBuf(buf, this.from);
        BlockPosUtil.writeToByteBuf(buf, this.to);
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.blockTo);
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.blockFrom);
    }

    @Override
    public void messageOnServerThread(ReplaceBlockMessage message, EntityPlayerMP player) {
        if (!player.field_71075_bZ.field_75098_d) {
            return;
        }
        WorldServer world = player.func_71121_q();
        FakePlayer fakePlayer = new FakePlayer(player.func_71121_q(), new GameProfile(player.func_110124_au(), "placeStuffForMePl0x"));
        for (int x = Math.min(message.from.func_177958_n(), message.to.func_177958_n()); x <= Math.max(message.from.func_177958_n(), message.to.func_177958_n()); ++x) {
            for (int y = Math.min(message.from.func_177956_o(), message.to.func_177956_o()); y <= Math.max(message.from.func_177956_o(), message.to.func_177956_o()); ++y) {
                for (int z = Math.min(message.from.func_177952_p(), message.to.func_177952_p()); z <= Math.max(message.from.func_177952_p(), message.to.func_177952_p()); ++z) {
                    IBlockState transformation;
                    BlockPos here = new BlockPos(x, y, z);
                    IBlockState blockState = world.func_180495_p(here);
                    ItemStack stack = BlockUtils.getItemStackFromBlockState(blockState);
                    if (!ReplaceBlockMessage.correctBlockToRemoveOrReplace(stack, blockState, message.blockFrom) || blockState.func_177230_c() instanceof BlockDoor && blockState.func_177229_b((IProperty)BlockDoor.field_176523_O) == BlockDoor.EnumDoorHalf.UPPER || blockState.func_177230_c() instanceof BlockBed && blockState.func_177229_b((IProperty)BlockBed.field_176472_a) == BlockBed.EnumPartType.HEAD) continue;
                    world.func_175698_g(here);
                    ItemStack stackToPlace = message.blockTo.func_77946_l();
                    stackToPlace.func_190920_e(stackToPlace.func_77976_d());
                    fakePlayer.func_184611_a(EnumHand.MAIN_HAND, stackToPlace);
                    if (message.blockTo.func_77973_b() instanceof ItemBed) {
                        fakePlayer.field_70177_z = ((EnumFacing)blockState.func_177229_b((IProperty)BlockBed.field_185512_D)).func_176736_b() * 90;
                    }
                    EnumFacing facing = message.blockTo.func_77973_b() instanceof ItemDoor || message.blockTo.func_77973_b() instanceof ItemBed || message.blockTo.func_77973_b() instanceof ItemSlab ? EnumFacing.UP : EnumFacing.NORTH;
                    ForgeHooks.onPlaceItemIntoWorld((ItemStack)stackToPlace, (EntityPlayer)fakePlayer, (World)world, (BlockPos)here, (EnumFacing)facing, (float)0.0f, (float)0.0f, (float)0.0f, (EnumHand)EnumHand.MAIN_HAND);
                    IBlockState newBlockState = world.func_180495_p(here);
                    if (newBlockState.func_177230_c() instanceof BlockStairs && blockState.func_177230_c() instanceof BlockStairs) {
                        transformation = newBlockState.func_177226_a((IProperty)BlockStairs.field_176309_a, blockState.func_177229_b((IProperty)BlockStairs.field_176309_a));
                        transformation = transformation.func_177226_a((IProperty)BlockStairs.field_176308_b, blockState.func_177229_b((IProperty)BlockStairs.field_176308_b));
                        transformation = transformation.func_177226_a((IProperty)BlockStairs.field_176310_M, blockState.func_177229_b((IProperty)BlockStairs.field_176310_M));
                        world.func_175656_a(here, transformation);
                        continue;
                    }
                    if (newBlockState.func_177230_c() instanceof BlockHorizontal && blockState.func_177230_c() instanceof BlockHorizontal && !(blockState.func_177230_c() instanceof BlockBed)) {
                        transformation = newBlockState.func_177226_a((IProperty)BlockHorizontal.field_185512_D, blockState.func_177229_b((IProperty)BlockHorizontal.field_185512_D));
                        world.func_175656_a(here, transformation);
                        continue;
                    }
                    if (newBlockState.func_177230_c() instanceof BlockDirectional && blockState.func_177230_c() instanceof BlockDirectional) {
                        transformation = newBlockState.func_177226_a((IProperty)BlockDirectional.field_176387_N, blockState.func_177229_b((IProperty)BlockDirectional.field_176387_N));
                        world.func_175656_a(here, transformation);
                        continue;
                    }
                    if (newBlockState.func_177230_c() instanceof BlockSlab && blockState.func_177230_c() instanceof BlockSlab) {
                        transformation = blockState.func_177230_c() instanceof BlockDoubleStoneSlab || blockState.func_177230_c() instanceof BlockDoubleStoneSlabNew ? blockState.func_177226_a((IProperty)BlockDoubleStoneSlab.field_176556_M, newBlockState.func_177229_b((IProperty)BlockDoubleStoneSlab.field_176556_M)) : newBlockState.func_177226_a((IProperty)BlockSlab.field_176554_a, blockState.func_177229_b((IProperty)BlockSlab.field_176554_a));
                        world.func_175656_a(here, transformation);
                        continue;
                    }
                    if (newBlockState.func_177230_c() instanceof BlockLog && blockState.func_177230_c() instanceof BlockLog) {
                        transformation = newBlockState.func_177226_a((IProperty)BlockLog.field_176299_a, blockState.func_177229_b((IProperty)BlockLog.field_176299_a));
                        world.func_175656_a(here, transformation);
                        continue;
                    }
                    if (newBlockState.func_177230_c() instanceof BlockRotatedPillar && blockState.func_177230_c() instanceof BlockRotatedPillar) {
                        transformation = newBlockState.func_177226_a((IProperty)BlockRotatedPillar.field_176298_M, blockState.func_177229_b((IProperty)BlockRotatedPillar.field_176298_M));
                        world.func_175656_a(here, transformation);
                        continue;
                    }
                    if (newBlockState.func_177230_c() instanceof BlockTrapDoor && blockState.func_177230_c() instanceof BlockTrapDoor) {
                        transformation = newBlockState.func_177226_a((IProperty)BlockTrapDoor.field_176285_M, blockState.func_177229_b((IProperty)BlockTrapDoor.field_176285_M));
                        transformation = transformation.func_177226_a((IProperty)BlockTrapDoor.field_176284_a, blockState.func_177229_b((IProperty)BlockTrapDoor.field_176284_a));
                        transformation = transformation.func_177226_a((IProperty)BlockTrapDoor.field_176283_b, blockState.func_177229_b((IProperty)BlockTrapDoor.field_176283_b));
                        world.func_175656_a(here, transformation);
                        continue;
                    }
                    if (newBlockState.func_177230_c() instanceof BlockDoor && blockState.func_177230_c() instanceof BlockDoor) {
                        transformation = newBlockState.func_177226_a((IProperty)BlockDoor.field_176520_a, blockState.func_177229_b((IProperty)BlockDoor.field_176520_a));
                        world.func_175656_a(here, transformation);
                        continue;
                    }
                    if (stackToPlace.func_77973_b() == Items.field_151129_at) {
                        world.func_175656_a(here, Blocks.field_150353_l.func_176223_P());
                        continue;
                    }
                    if (stackToPlace.func_77973_b() != Items.field_151131_as) continue;
                    world.func_175656_a(here, Blocks.field_150355_j.func_176223_P());
                }
            }
        }
    }

    public static boolean correctBlockToRemoveOrReplace(ItemStack worldStack, IBlockState worldState, ItemStack compareStack) {
        return worldStack != null && worldStack.func_77969_a(compareStack) || compareStack.func_77973_b() == Items.field_151129_at && (worldState.func_177230_c() == Blocks.field_150353_l || worldState.func_177230_c() == Blocks.field_150356_k) || compareStack.func_77973_b() == Items.field_151131_as && (worldState.func_177230_c() == Blocks.field_150355_j || worldState.func_177230_c() == Blocks.field_150358_i) || compareStack.func_77973_b() == Items.field_190931_a && worldState.func_177230_c() == Blocks.field_150350_a;
    }
}

