/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.BlockUtils;
import com.minecolonies.coremod.network.messages.AbstractMessage;
import com.minecolonies.coremod.network.messages.ReplaceBlockMessage;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class RemoveBlockMessage
extends AbstractMessage<RemoveBlockMessage, IMessage> {
    private BlockPos from;
    private BlockPos to;
    private ItemStack block;

    public RemoveBlockMessage() {
    }

    public RemoveBlockMessage(@NotNull BlockPos pos1, @NotNull BlockPos pos2, @NotNull ItemStack stack) {
        this.from = pos1;
        this.to = pos2;
        this.block = stack;
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.from = BlockPosUtil.readFromByteBuf(buf);
        this.to = BlockPosUtil.readFromByteBuf(buf);
        this.block = ByteBufUtils.readItemStack((ByteBuf)buf);
    }

    public void toBytes(@NotNull ByteBuf buf) {
        BlockPosUtil.writeToByteBuf(buf, this.from);
        BlockPosUtil.writeToByteBuf(buf, this.to);
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.block);
    }

    @Override
    public void messageOnServerThread(RemoveBlockMessage message, EntityPlayerMP player) {
        if (!player.field_71075_bZ.field_75098_d) {
            return;
        }
        WorldServer world = player.func_71121_q();
        for (int x = Math.min(message.from.func_177958_n(), message.to.func_177958_n()); x <= Math.max(message.from.func_177958_n(), message.to.func_177958_n()); ++x) {
            for (int y = Math.min(message.from.func_177956_o(), message.to.func_177956_o()); y <= Math.max(message.from.func_177956_o(), message.to.func_177956_o()); ++y) {
                for (int z = Math.min(message.from.func_177952_p(), message.to.func_177952_p()); z <= Math.max(message.from.func_177952_p(), message.to.func_177952_p()); ++z) {
                    BlockPos here = new BlockPos(x, y, z);
                    IBlockState blockState = world.func_180495_p(here);
                    ItemStack stack = BlockUtils.getItemStackFromBlockState(blockState);
                    if (!ReplaceBlockMessage.correctBlockToRemoveOrReplace(stack, blockState, message.block)) continue;
                    world.func_175698_g(here);
                }
            }
        }
    }
}

