/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.coremod.colony.buildings.views.MobEntryView;
import com.minecolonies.coremod.network.messages.AbstractMessage;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class MobEntryChangeMessage
extends AbstractMessage<MobEntryChangeMessage, IMessage> {
    private int colonyId;
    private BlockPos buildingId;
    private List<MobEntryView> mobsToAttack = new ArrayList<MobEntryView>();

    public MobEntryChangeMessage() {
    }

    public MobEntryChangeMessage(@NotNull AbstractBuildingGuards.View building, List<MobEntryView> mobsToAttack) {
        this.colonyId = building.getColony().getID();
        this.buildingId = building.getID();
        this.mobsToAttack = new ArrayList<MobEntryView>(mobsToAttack);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.colonyId);
        BlockPosUtil.writeToByteBuf(buf, this.buildingId);
        buf.writeInt(this.mobsToAttack.size());
        for (MobEntryView entry : this.mobsToAttack) {
            MobEntryView.writeToByteBuf(buf, entry);
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.colonyId = buf.readInt();
        this.buildingId = BlockPosUtil.readFromByteBuf(buf);
        int mobSize = buf.readInt();
        for (int i = 0; i < mobSize; ++i) {
            MobEntryView mobEntry = MobEntryView.readFromByteBuf(buf);
            this.mobsToAttack.add(mobEntry);
        }
    }

    @Override
    public void messageOnServerThread(MobEntryChangeMessage message, EntityPlayerMP player) {
        Colony colony = ColonyManager.getColony(message.colonyId);
        if (colony != null) {
            if (!colony.getPermissions().hasPermission((EntityPlayer)player, Action.MANAGE_HUTS)) {
                return;
            }
            AbstractBuildingGuards building = colony.getBuildingManager().getBuilding(message.buildingId, AbstractBuildingGuards.class);
            if (building != null) {
                building.setMobsToAttack(message.mobsToAttack);
            }
        }
    }
}

