/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingLumberjack;
import com.minecolonies.coremod.network.messages.AbstractMessage;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class LumberjackSaplingSelectorMessage
extends AbstractMessage<LumberjackSaplingSelectorMessage, IMessage> {
    private int colonyId;
    private BlockPos buildingId;
    private ItemStack stack;
    private boolean shouldCut;

    public LumberjackSaplingSelectorMessage() {
    }

    public LumberjackSaplingSelectorMessage(BuildingLumberjack.View building, ItemStack saplingStack, boolean shouldCut) {
        this.colonyId = building.getColony().getID();
        this.buildingId = building.getID();
        this.stack = saplingStack;
        this.shouldCut = shouldCut;
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.colonyId = buf.readInt();
        this.buildingId = BlockPosUtil.readFromByteBuf(buf);
        this.stack = ByteBufUtils.readItemStack((ByteBuf)buf);
        this.shouldCut = buf.readBoolean();
    }

    public void toBytes(@NotNull ByteBuf buf) {
        buf.writeInt(this.colonyId);
        BlockPosUtil.writeToByteBuf(buf, this.buildingId);
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.stack);
        buf.writeBoolean(this.shouldCut);
    }

    @Override
    public void messageOnServerThread(LumberjackSaplingSelectorMessage message, EntityPlayerMP player) {
        Colony colony = ColonyManager.getColony(message.colonyId);
        if (colony != null) {
            if (!colony.getPermissions().hasPermission((EntityPlayer)player, Action.MANAGE_HUTS)) {
                return;
            }
            AbstractBuildingWorker building = colony.getBuildingManager().getBuilding(message.buildingId, AbstractBuildingWorker.class);
            if (building instanceof BuildingLumberjack) {
                ((BuildingLumberjack)building).setTreeToCut(message.stack, message.shouldCut);
            }
        }
    }
}

