/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.coremod.network.messages.AbstractMessage;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuardRecalculateMessage
extends AbstractMessage<GuardRecalculateMessage, IMessage> {
    private BlockPos buildingId;
    private int colonyId;

    public GuardRecalculateMessage() {
    }

    public GuardRecalculateMessage(int colonyId, BlockPos buildingId) {
        this.colonyId = colonyId;
        this.buildingId = buildingId;
    }

    public void fromBytes(ByteBuf byteBuf) {
        this.colonyId = byteBuf.readInt();
        this.buildingId = BlockPosUtil.readFromByteBuf(byteBuf);
    }

    public void toBytes(ByteBuf byteBuf) {
        byteBuf.writeInt(this.colonyId);
        BlockPosUtil.writeToByteBuf(byteBuf, this.buildingId);
    }

    @Override
    public void messageOnServerThread(GuardRecalculateMessage message, EntityPlayerMP player) {
        Colony colony = ColonyManager.getColony(message.colonyId);
        if (colony != null) {
            if (!colony.getPermissions().hasPermission((EntityPlayer)player, Action.MANAGE_HUTS)) {
                return;
            }
            AbstractBuildingGuards building = colony.getBuildingManager().getBuilding(message.buildingId, AbstractBuildingGuards.class);
            if (building != null) {
                building.setMobsToAttack(building.calculateMobs());
            }
        }
    }
}

