/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.ColonyView;
import com.minecolonies.coremod.network.messages.AbstractMessage;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.jetbrains.annotations.NotNull;

public class ColonyViewMessage
extends AbstractMessage<ColonyViewMessage, IMessage> {
    private int colonyId;
    private boolean isNewSubscription;
    private ByteBuf colonyBuffer;

    public ColonyViewMessage() {
    }

    public ColonyViewMessage(@NotNull Colony colony, boolean isNewSubscription) {
        this.colonyId = colony.getID();
        this.isNewSubscription = isNewSubscription;
        this.colonyBuffer = Unpooled.buffer();
        ColonyView.serializeNetworkData(colony, this.colonyBuffer, isNewSubscription);
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        ByteBuf newBuf = buf.retain();
        this.colonyId = newBuf.readInt();
        this.isNewSubscription = newBuf.readBoolean();
        this.colonyBuffer = newBuf;
    }

    public void toBytes(@NotNull ByteBuf buf) {
        buf.writeInt(this.colonyId);
        buf.writeBoolean(this.isNewSubscription);
        buf.writeBytes(this.colonyBuffer);
    }

    @Override
    protected void messageOnClientThread(ColonyViewMessage message, MessageContext ctx) {
        if (MineColonies.proxy.getWorldFromMessage(ctx) != null) {
            ColonyManager.handleColonyViewMessage(message.colonyId, message.colonyBuffer, MineColonies.proxy.getWorldFromMessage(ctx), message.isNewSubscription);
        }
    }
}

