/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.coremod.network.messages.AbstractMessage;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class ChangeRecipePriorityMessage
extends AbstractMessage<ChangeRecipePriorityMessage, IMessage> {
    private int colonyId;
    private BlockPos buildingId;
    private int recipeLocation;
    private boolean up;

    public ChangeRecipePriorityMessage() {
    }

    public ChangeRecipePriorityMessage(@NotNull AbstractBuildingView building, int location, boolean up) {
        this.colonyId = building.getColony().getID();
        this.buildingId = building.getLocation();
        this.recipeLocation = location;
        this.up = up;
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.colonyId = buf.readInt();
        this.buildingId = BlockPosUtil.readFromByteBuf(buf);
        this.recipeLocation = buf.readInt();
        this.up = buf.readBoolean();
    }

    public void toBytes(@NotNull ByteBuf buf) {
        buf.writeInt(this.colonyId);
        BlockPosUtil.writeToByteBuf(buf, this.buildingId);
        buf.writeInt(this.recipeLocation);
        buf.writeBoolean(this.up);
    }

    @Override
    public void messageOnServerThread(ChangeRecipePriorityMessage message, EntityPlayerMP player) {
        Colony colony = ColonyManager.getColony(message.colonyId);
        if (colony != null && colony.getPermissions().hasPermission((EntityPlayer)player, Action.ACCESS_HUTS)) {
            if (!colony.getPermissions().hasPermission((EntityPlayer)player, Action.MANAGE_HUTS)) {
                return;
            }
            AbstractBuilding building = colony.getBuildingManager().getBuilding(message.buildingId);
            if (building instanceof AbstractBuildingWorker) {
                if (message.up) {
                    ((AbstractBuildingWorker)building).switchIndex(message.recipeLocation, message.recipeLocation + 1);
                } else {
                    ((AbstractBuildingWorker)building).switchIndex(message.recipeLocation, message.recipeLocation - 1);
                }
            }
        }
    }
}

