/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.util.BlockUtils;
import com.minecolonies.api.util.CompatibilityUtils;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.blocks.AbstractBlockHut;
import com.minecolonies.coremod.blocks.ModBlocks;
import com.minecolonies.coremod.client.gui.WindowBuildTool;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.StructureName;
import com.minecolonies.coremod.colony.Structures;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuildBuilding;
import com.minecolonies.coremod.entity.ai.citizen.builder.ConstructionTapeHelper;
import com.minecolonies.coremod.event.EventHandler;
import com.minecolonies.coremod.items.ModItems;
import com.minecolonies.coremod.network.messages.AbstractMessage;
import com.minecolonies.coremod.util.StructureWrapper;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.Mirror;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildToolPasteMessage
extends AbstractMessage<BuildToolPasteMessage, IMessage> {
    private static final int SUPPLY_SHIP_CHEST_HEIGHT = 6;
    private boolean complete;
    private String structureName;
    private String workOrderName;
    private int rotation;
    private BlockPos pos;
    private boolean isHut;
    private boolean mirror;
    private WindowBuildTool.FreeMode freeMode;
    @GameRegistry.ItemStackHolder(value="gbook:guidebook", nbt="{Book:\"minecolonies:book/minecolonies.xml\"}")
    public static ItemStack guideBook;

    public BuildToolPasteMessage() {
    }

    public BuildToolPasteMessage(String structureName, String workOrderName, BlockPos pos, int rotation, boolean isHut, Mirror mirror, boolean complete, WindowBuildTool.FreeMode freeMode) {
        this.structureName = structureName;
        this.workOrderName = workOrderName;
        this.pos = pos;
        this.rotation = rotation;
        this.isHut = isHut;
        this.mirror = mirror == Mirror.FRONT_BACK;
        this.complete = complete;
        this.freeMode = freeMode;
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.structureName = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.workOrderName = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        this.rotation = buf.readInt();
        this.isHut = buf.readBoolean();
        this.mirror = buf.readBoolean();
        this.complete = buf.readBoolean();
        int modeId = buf.readInt();
        if (modeId >= 0) {
            this.freeMode = WindowBuildTool.FreeMode.values()[modeId];
        }
    }

    public void toBytes(@NotNull ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.structureName);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.workOrderName);
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        buf.writeInt(this.rotation);
        buf.writeBoolean(this.isHut);
        buf.writeBoolean(this.mirror);
        buf.writeBoolean(this.complete);
        if (this.freeMode == null) {
            buf.writeInt(-1);
        } else {
            buf.writeInt(this.freeMode.ordinal());
        }
    }

    @Override
    public void messageOnServerThread(BuildToolPasteMessage message, EntityPlayerMP player) {
        StructureName sn = new StructureName(message.structureName);
        if (!Structures.hasMD5(sn)) {
            player.func_145747_a((ITextComponent)new TextComponentString("Can not build " + message.workOrderName + ": schematic missing!"));
            return;
        }
        if (player.field_71075_bZ.field_75098_d) {
            AbstractBuilding building;
            if (message.isHut) {
                BuildToolPasteMessage.handleHut(CompatibilityUtils.getWorld((Entity)player), (EntityPlayer)player, sn, message.rotation, message.pos, message.mirror);
            }
            StructureWrapper.loadAndPlaceStructureWithRotation(player.field_70170_p, message.structureName, message.pos, message.rotation, message.mirror ? Mirror.FRONT_BACK : Mirror.NONE, message.complete);
            if (message.isHut && (building = ColonyManager.getBuilding(CompatibilityUtils.getWorld((Entity)player), message.pos)) != null) {
                WorkOrderBuildBuilding workOrder = new WorkOrderBuildBuilding(building, 1);
                ConstructionTapeHelper.removeConstructionTape(workOrder, CompatibilityUtils.getWorld((Entity)player));
            }
        } else if (message.freeMode != null) {
            int chestHeight;
            if (player.func_147099_x().func_77444_a(StatList.func_188057_b((Item)ModItems.supplyChest)) > 0) {
                LanguageHandler.sendPlayerMessage((EntityPlayer)player, "com.minecolonies.coremod.error.supplyChestAlreadyPlaced", new Object[0]);
                return;
            }
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            if (message.freeMode == WindowBuildTool.FreeMode.SUPPLYSHIP) {
                stacks.add(new ItemStack(ModItems.supplyChest));
                chestHeight = 6;
            } else if (message.freeMode == WindowBuildTool.FreeMode.SUPPLYCAMP) {
                stacks.add(new ItemStack(ModItems.supplyCamp));
                chestHeight = 1;
            } else {
                chestHeight = 0;
            }
            player.func_71029_a(StatList.func_188057_b((Item)ModItems.supplyChest));
            if (InventoryUtils.removeStacksFromItemHandler((IItemHandler)new InvWrapper((IInventory)player.field_71071_by), stacks)) {
                StructureWrapper.loadAndPlaceStructureWithRotation(player.field_70170_p, message.structureName, message.pos, message.rotation, message.mirror ? Mirror.FRONT_BACK : Mirror.NONE, message.complete);
                player.func_71121_q().func_175656_a(message.pos.func_177981_b(chestHeight), Blocks.field_150486_ae.func_176223_P().func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)player.func_174811_aO()));
                BuildToolPasteMessage.fillChest((TileEntityChest)player.func_71121_q().func_175625_s(message.pos.func_177981_b(chestHeight)));
            } else {
                LanguageHandler.sendPlayerMessage((EntityPlayer)player, "item.supplyChestDeployer.missing", new Object[0]);
            }
        }
    }

    private static void fillChest(@Nullable TileEntityChest chest) {
        if (chest == null) {
            Log.getLogger().error("Supply chest tile entity was null.");
            return;
        }
        chest.func_70299_a(0, new ItemStack((Block)ModBlocks.blockHutTownHall));
        chest.func_70299_a(1, new ItemStack(ModItems.buildTool));
        chest.func_70299_a(2, guideBook);
    }

    private static void handleHut(@NotNull World world, @NotNull EntityPlayer player, StructureName sn, int rotation, @NotNull BlockPos buildPos, boolean mirror) {
        Colony tempColony = ColonyManager.getClosestColony(world, buildPos);
        if (tempColony != null && !tempColony.getPermissions().hasPermission(player, Action.MANAGE_HUTS) && !ColonyManager.isTooCloseToColony(world, buildPos)) {
            return;
        }
        String hut = sn.getSection();
        Block block = Block.func_149684_b((String)("minecolonies:blockHut" + hut));
        if (block != null && EventHandler.onBlockHutPlaced(world, player, block, buildPos)) {
            world.func_175655_b(buildPos, true);
            world.func_175656_a(buildPos, block.func_176223_P().func_185907_a(BlockUtils.getRotation(rotation)));
            ((AbstractBlockHut)block).onBlockPlacedByBuildTool(world, buildPos, world.func_180495_p(buildPos), (EntityLivingBase)player, null, mirror, sn.getStyle());
            BuildToolPasteMessage.setupBuilding(world, player, sn, rotation, buildPos, mirror);
        }
    }

    private static void setupBuilding(@NotNull World world, @NotNull EntityPlayer player, StructureName sn, int rotation, @NotNull BlockPos buildPos, boolean mirror) {
        AbstractBuilding building = ColonyManager.getBuilding(world, buildPos);
        if (building == null) {
            Log.getLogger().error("BuildTool: building is null!");
        } else {
            if (building.getTileEntity() != null) {
                Colony colony = ColonyManager.getColony(world, buildPos);
                if (colony == null) {
                    Log.getLogger().info("No colony for " + player.func_70005_c_());
                } else {
                    building.getTileEntity().setColony(colony);
                }
            }
            String name = sn.toString();
            name = name.substring(name.length() - 1);
            try {
                int level = Integer.parseInt(name);
                building.setBuildingLevel(level);
            }
            catch (NumberFormatException e) {
                Log.getLogger().warn("Couldn't parse the level.", (Throwable)e);
            }
            building.setStyle(sn.getStyle());
            building.setRotation(rotation);
            if (mirror) {
                building.invertMirror();
            }
        }
    }
}

