/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.coremod.network.messages.AbstractMessage;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class BuildRequestMessage
extends AbstractMessage<BuildRequestMessage, IMessage> {
    public static final int BUILD = 0;
    public static final int REPAIR = 1;
    private BlockPos buildingId;
    private int colonyId;
    private int mode;

    public BuildRequestMessage() {
    }

    public BuildRequestMessage(@NotNull AbstractBuildingView building, int mode) {
        this.colonyId = building.getColony().getID();
        this.buildingId = building.getID();
        this.mode = mode;
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.colonyId = buf.readInt();
        this.buildingId = BlockPosUtil.readFromByteBuf(buf);
        this.mode = buf.readInt();
    }

    public void toBytes(@NotNull ByteBuf buf) {
        buf.writeInt(this.colonyId);
        BlockPosUtil.writeToByteBuf(buf, this.buildingId);
        buf.writeInt(this.mode);
    }

    @Override
    public void messageOnServerThread(BuildRequestMessage message, EntityPlayerMP player) {
        Colony colony = ColonyManager.getColony(message.colonyId);
        if (colony == null) {
            return;
        }
        AbstractBuilding building = colony.getBuildingManager().getBuilding(message.buildingId);
        if (building == null) {
            return;
        }
        if (!colony.getPermissions().hasPermission((EntityPlayer)player, Action.MANAGE_HUTS)) {
            return;
        }
        if (building.hasWorkOrder()) {
            building.removeWorkOrder();
        } else {
            switch (message.mode) {
                case 0: {
                    building.requestUpgrade((EntityPlayer)player);
                    break;
                }
                case 1: {
                    building.requestRepair();
                    break;
                }
            }
        }
    }
}

