/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.event;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyTagCapability;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.configuration.Configurations;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.blocks.AbstractBlockHut;
import com.minecolonies.coremod.blocks.huts.BlockHutField;
import com.minecolonies.coremod.blocks.huts.BlockHutTownHall;
import com.minecolonies.coremod.blocks.huts.BlockHutWareHouse;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.event.capabilityproviders.MinecoloniesChunkCapabilityProvider;
import com.minecolonies.coremod.event.capabilityproviders.MinecoloniesWorldCapabilityProvider;
import com.minecolonies.coremod.items.ModItems;
import com.minecolonies.coremod.network.messages.UpdateChunkCapabilityMessage;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSilverfish;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

public class EventHandler {
    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onDebugOverlay(RenderGameOverlayEvent.Text event) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71474_y.field_74330_P) {
                WorldClient world = mc.field_71441_e;
                EntityPlayerSP player = mc.field_71439_g;
                IColony colony = ColonyManager.getIColony((World)world, player.func_180425_c());
                if (colony == null) {
                    if (!ColonyManager.isTooCloseToColony((World)world, player.func_180425_c())) {
                        event.getLeft().add(LanguageHandler.format("com.minecolonies.coremod.gui.debugScreen.noCloseColony", new Object[0]));
                        return;
                    }
                    colony = ColonyManager.getClosestIColony((World)world, player.func_180425_c());
                    if (colony == null) {
                        return;
                    }
                    event.getLeft().add(LanguageHandler.format("com.minecolonies.coremod.gui.debugScreen.nextColony", (int)Math.sqrt(colony.getDistanceSquared(player.func_180425_c())), ColonyManager.getMinimumDistanceBetweenTownHalls()));
                    return;
                }
                event.getLeft().add(colony.getName() + " : " + LanguageHandler.format("com.minecolonies.coremod.gui.debugScreen.blocksFromCenter", (int)Math.sqrt(colony.getDistanceSquared(player.func_180425_c()))));
            }
        }
    }

    @SubscribeEvent
    public void onAttachingCapabilitiesChunk(@NotNull AttachCapabilitiesEvent<Chunk> event) {
        event.addCapability(new ResourceLocation("minecolonies", "closeColony"), (ICapabilityProvider)new MinecoloniesChunkCapabilityProvider());
    }

    @SubscribeEvent
    public void onAttachingCapabilitiesWorld(@NotNull AttachCapabilitiesEvent<World> event) {
        event.addCapability(new ResourceLocation("minecolonies", "chunkUpdate"), (ICapabilityProvider)new MinecoloniesWorldCapabilityProvider());
    }

    @SubscribeEvent
    public void onChunkLoad(@NotNull ChunkEvent.Load event) {
        if (event.getWorld() instanceof WorldServer) {
            ColonyManager.loadChunk(event.getChunk(), event.getWorld());
        }
    }

    @SubscribeEvent
    public void onEnteringChunk(@NotNull EntityEvent.EnteringChunk event) {
        Entity entity = event.getEntity();
        if (entity instanceof EntityPlayerMP && entity.field_71093_bK == 0) {
            Colony colony;
            World world = entity.func_130014_f_();
            Chunk newChunk = world.func_72964_e(event.getNewChunkX(), event.getNewChunkZ());
            ColonyManager.loadChunk(newChunk, entity.field_70170_p);
            IColonyTagCapability newCloseColonies = (IColonyTagCapability)newChunk.getCapability(MineColonies.CLOSE_COLONY_CAP, null);
            MineColonies.getNetwork().sendToAll((IMessage)new UpdateChunkCapabilityMessage(newCloseColonies, newChunk.field_76635_g, newChunk.field_76647_h));
            EntityPlayerMP player = (EntityPlayerMP)entity;
            Chunk oldChunk = world.func_72964_e(event.getOldChunkX(), event.getOldChunkZ());
            IColonyTagCapability oldCloseColonies = (IColonyTagCapability)oldChunk.getCapability(MineColonies.CLOSE_COLONY_CAP, null);
            for (int colonyId : newCloseColonies.getAllCloseColonies()) {
                colony = ColonyManager.getColony(colonyId);
                if (colony == null) continue;
                colony.getPackageManager().addSubscribers(player);
            }
            for (int colonyId : oldCloseColonies.getAllCloseColonies()) {
                if (newCloseColonies.getAllCloseColonies().contains(colonyId) || (colony = ColonyManager.getColony(colonyId)) == null) continue;
                colony.getPackageManager().removeSubscriber(player);
            }
            if (newCloseColonies.getOwningColony() != oldCloseColonies.getOwningColony()) {
                Colony colony2;
                if (newCloseColonies.getOwningColony() == 0) {
                    colony2 = ColonyManager.getColony(oldCloseColonies.getOwningColony());
                    if (colony2 != null) {
                        colony2.removeVisitingPlayer((EntityPlayer)player);
                    }
                    return;
                }
                colony2 = ColonyManager.getColony(newCloseColonies.getOwningColony());
                if (colony2 != null) {
                    colony2.addVisitingPlayer((EntityPlayer)player);
                }
            }
        }
    }

    @SubscribeEvent
    public void onBlockBreak(@NotNull BlockEvent.BreakEvent event) {
        World world = event.getWorld();
        if (!world.field_72995_K && event.getState().func_177230_c() instanceof AbstractBlockHut) {
            AbstractBuilding building = ColonyManager.getBuilding(world, event.getPos());
            if (building == null) {
                return;
            }
            if (!building.getColony().getPermissions().hasPermission(event.getPlayer(), Action.BREAK_HUTS)) {
                event.setCanceled(true);
                return;
            }
            building.destroy();
        }
        if (event.getPlayer() instanceof EntityPlayer && event.getPlayer().func_184586_b(EnumHand.MAIN_HAND).func_77973_b() == ModItems.scanTool) {
            ItemStack itemstack = event.getPlayer().func_184586_b(EnumHand.MAIN_HAND);
            if (!itemstack.func_77942_o()) {
                itemstack.func_77982_d(new NBTTagCompound());
            }
            NBTTagCompound compound = itemstack.func_77978_p();
            BlockPosUtil.writeToNBT(compound, "pos1", event.getPos());
            LanguageHandler.sendPlayerMessage(event.getPlayer(), "item.scepterSteel.point", event.getPos().func_177958_n(), event.getPos().func_177956_o(), event.getPos().func_177952_p());
            itemstack.func_77982_d(compound);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(@NotNull PlayerInteractEvent.RightClickBlock event) {
        EntityPlayer player = event.getEntityPlayer();
        World world = event.getWorld();
        if (event.getHand() == EnumHand.MAIN_HAND && !event.getWorld().field_72995_K) {
            if (EventHandler.playerRightClickInteract(player, world, event.getPos()) && world.func_180495_p(event.getPos()).func_177230_c() instanceof AbstractBlockHut) {
                IColony colony = ColonyManager.getIColony(world, event.getPos());
                if (colony != null && !colony.getPermissions().hasPermission(player, Action.ACCESS_HUTS)) {
                    event.setCanceled(true);
                }
                return;
            }
            if ("pmardle".equalsIgnoreCase(event.getEntityPlayer().func_70005_c_()) && Block.func_149634_a((Item)event.getItemStack().func_77973_b()) instanceof BlockSilverfish) {
                LanguageHandler.sendPlayerMessage(event.getEntityPlayer(), "Stop that you twat!!!", new Object[0]);
                event.setCanceled(true);
            }
            if (player.func_184614_ca() == null || player.func_184614_ca().func_77973_b() == null) {
                return;
            }
            EventHandler.handleEventCancellation((PlayerInteractEvent)event, player);
        }
    }

    private static boolean playerRightClickInteract(@NotNull EntityPlayer player, World world, BlockPos pos) {
        return !player.func_70093_af() || player.func_184614_ca() == null || player.func_184614_ca().func_77973_b() == null || player.func_184614_ca().func_77973_b().doesSneakBypassUse(player.func_184614_ca(), (IBlockAccess)world, pos, player);
    }

    private static void handleEventCancellation(@NotNull PlayerInteractEvent event, @NotNull EntityPlayer player) {
        Block heldBlock = Block.func_149634_a((Item)player.func_184614_ca().func_77973_b());
        if (heldBlock instanceof AbstractBlockHut || heldBlock instanceof BlockHutField) {
            event.setCanceled(!EventHandler.onBlockHutPlaced(event.getWorld(), player, heldBlock, event.getPos().func_177972_a(event.getFace())));
        }
    }

    public static boolean onBlockHutPlaced(@NotNull World world, @NotNull EntityPlayer player, Block block, BlockPos pos) {
        if (!Configurations.gameplay.allowOtherDimColonies && world.field_73011_w.getDimension() != 0) {
            LanguageHandler.sendPlayerMessage(player, "com.minecolonies.coremod.dimension.no", new Object[0]);
            return false;
        }
        if (block instanceof BlockHutTownHall) {
            return EventHandler.onTownHallPlaced(world, player, pos);
        }
        if (block instanceof BlockHutWareHouse) {
            return EventHandler.onWareHousePlaced(world, player, pos);
        }
        return EventHandler.onBlockHutPlaced(world, player, pos);
    }

    protected static boolean onTownHallPlaced(@NotNull World world, @NotNull EntityPlayer player, BlockPos pos) {
        IColony colony = ColonyManager.getIColonyByOwner(world, player);
        if (colony != null) {
            return EventHandler.canOwnerPlaceTownHallHere(world, player, colony, pos);
        }
        if (Configurations.gameplay.restrictColonyPlacement) {
            double spawnDistance = Math.sqrt(BlockPosUtil.getDistanceSquared2D(pos, world.func_175694_M()));
            if (spawnDistance < (double)Configurations.gameplay.minDistanceFromWorldSpawn) {
                LanguageHandler.sendPlayerMessage(player, "com.minecolonies.coremod.tooClose", Configurations.gameplay.minDistanceFromWorldSpawn);
                return false;
            }
            if (spawnDistance > (double)Configurations.gameplay.maxDistanceFromWorldSpawn) {
                LanguageHandler.sendPlayerMessage(player, "com.minecolonies.coremod.tooFar", Configurations.gameplay.maxDistanceFromWorldSpawn);
                return false;
            }
        }
        if ((colony = ColonyManager.getClosestIColony(world, pos)) == null) {
            return true;
        }
        return EventHandler.canPlayerPlaceTownHallHere(world, player, pos, colony);
    }

    private static boolean onWareHousePlaced(World world, EntityPlayer player, BlockPos pos) {
        if (EventHandler.onBlockHutPlaced(world, player, pos)) {
            IColony colony = ColonyManager.getClosestIColony(world, pos);
            if (!(colony == null || Configurations.gameplay.limitToOneWareHousePerColony && colony.hasWarehouse())) {
                return true;
            }
            LanguageHandler.sendPlayerMessage(player, "tile.blockHut.warehouse.limit", new Object[0]);
        }
        return false;
    }

    private static boolean onBlockHutPlaced(World world, @NotNull EntityPlayer player, BlockPos pos) {
        IColony colony = ColonyManager.getIColony(world, pos);
        if (colony == null) {
            if (ColonyManager.getIColonyByOwner(world, player) == null) {
                LanguageHandler.sendPlayerMessage(player, "tile.blockHut.messageNoTownHall", new Object[0]);
            } else {
                LanguageHandler.sendPlayerMessage(player, "tile.blockHut.messageTooFarFromTownHall", new Object[0]);
            }
            return false;
        }
        if (!colony.getPermissions().hasPermission(player, Action.PLACE_HUTS)) {
            LanguageHandler.sendPlayerMessage(player, "tile.blockHut.messageNoPermission", colony.getName());
            return false;
        }
        return true;
    }

    private static boolean canOwnerPlaceTownHallHere(World world, @NotNull EntityPlayer player, @NotNull IColony colony, BlockPos pos) {
        if (!colony.isCoordInColony(world, pos) || colony.hasTownHall()) {
            LanguageHandler.sendPlayerMessage(player, "tile.blockHutTownHall.messagePlacedAlready", new Object[0]);
            return false;
        }
        IColony currentColony = ColonyManager.getIColony(world, pos);
        if (currentColony != colony) {
            LanguageHandler.sendPlayerMessage(player, "tile.blockHutTownhall.messageTooFar", new Object[0]);
            return false;
        }
        return true;
    }

    private static boolean canPlayerPlaceTownHallHere(@NotNull World world, @NotNull EntityPlayer player, BlockPos pos, @NotNull IColony closestColony) {
        if (closestColony.isCoordInColony(world, pos)) {
            if (closestColony.hasTownHall() || !closestColony.getPermissions().isColonyMember(player)) {
                Log.getLogger().info("Can't place at: " + pos.func_177958_n() + "." + pos.func_177956_o() + "." + pos.func_177952_p() + ". Because of townhall of: " + closestColony.getName() + " at " + closestColony.getCenter().func_177958_n() + "." + closestColony.getCenter().func_177956_o() + "." + closestColony.getCenter().func_177952_p());
                LanguageHandler.sendPlayerMessage(player, "tile.blockHutTownHall.messageTooClose", new Object[0]);
                return false;
            }
            if (!closestColony.getPermissions().hasPermission(player, Action.PLACE_HUTS)) {
                LanguageHandler.sendPlayerMessage(player, "tile.blockHut.messageNoPermissionPlace", closestColony.getName());
                return false;
            }
            return true;
        }
        if (ColonyManager.isTooCloseToColony(world, pos)) {
            Log.getLogger().info("Can't place at: " + pos.func_177958_n() + "." + pos.func_177956_o() + "." + pos.func_177952_p() + ". Because of townhall of: " + closestColony.getName() + " at " + closestColony.getCenter().func_177958_n() + "." + closestColony.getCenter().func_177956_o() + "." + closestColony.getCenter().func_177952_p());
            LanguageHandler.sendPlayerMessage(player, "tile.blockHutTownHall.messageTooClose", new Object[0]);
            return false;
        }
        if (Configurations.gameplay.protectVillages && world.func_175714_ae().func_176056_a(pos, Configurations.gameplay.workingRangeTownHallChunks * 16) != null) {
            Log.getLogger().warn("Village close by!");
            return false;
        }
        return true;
    }

    @SubscribeEvent
    public void onWorldLoad(@NotNull WorldEvent.Load event) {
        ColonyManager.onWorldLoad(event.getWorld());
    }

    @SubscribeEvent
    public void onWorldUnload(@NotNull WorldEvent.Unload event) {
        ColonyManager.onWorldUnload(event.getWorld());
    }
}

