/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.event;

import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.coremod.colony.CitizenDataView;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.ColonyView;
import com.minecolonies.coremod.entity.EntityCitizen;
import com.minecolonies.coremod.entity.pathfinding.Pathfinding;
import com.minecolonies.structures.helpers.Settings;
import com.minecolonies.structures.helpers.Structure;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

public class ClientEventHandler {
    private static final List<BlockPos> colonyBorder = new ArrayList<BlockPos>();
    private static final int SECONDS_TO_SHOW = 5;
    private CitizenDataView citizen = null;
    private double ticksPassed = 0.0;

    @SubscribeEvent
    public void renderWorldLastEvent(@NotNull RenderWorldLastEvent event) {
        Pathfinding.debugDraw(event.getPartialTicks());
        Structure structure = Settings.instance.getActiveStructure();
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (structure != null) {
            if (Settings.instance.getStructureName().contains("infrastructure")) {
                // empty if block
            }
            return;
        }
        if (Settings.instance.getBox() != null) {
            BlockPos posA = (BlockPos)Settings.instance.getBox().func_76341_a();
            BlockPos posB = (BlockPos)Settings.instance.getBox().func_76340_b();
            int x1 = posA.func_177958_n();
            int y1 = posA.func_177956_o();
            int z1 = posA.func_177952_p();
            int x2 = posB.func_177958_n();
            int y2 = posB.func_177956_o();
            int z2 = posB.func_177952_p();
            if (x1 > x2) {
                ++x1;
            } else {
                ++x2;
            }
            if (y1 > y2) {
                ++y1;
            } else {
                ++y2;
            }
            if (z1 > z2) {
                ++z1;
            } else {
                ++z2;
            }
            double renderPosX = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)event.getPartialTicks();
            double renderPosY = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)event.getPartialTicks();
            double renderPosZ = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)event.getPartialTicks();
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_187441_d((float)2.0f);
            GlStateManager.func_179090_x();
            GlStateManager.func_179132_a((boolean)false);
            AxisAlignedBB axisalignedbb = new AxisAlignedBB((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2);
            RenderGlobal.func_189697_a((AxisAlignedBB)axisalignedbb.func_186662_g(0.002).func_72317_d(-renderPosX, -renderPosY, -renderPosZ), (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179098_w();
            GlStateManager.func_179084_k();
        } else {
            if (this.citizen != null) {
                Entity entityCitizen = world.func_73045_a(this.citizen.getEntityId());
                if (entityCitizen instanceof EntityCitizen) {
                    this.ticksPassed += (double)event.getPartialTicks();
                    if (this.ticksPassed > 100.0) {
                        this.ticksPassed = 0.0;
                        this.citizen = null;
                    }
                } else {
                    this.citizen = null;
                    this.ticksPassed = 0.0;
                }
                return;
            }
            ColonyView colony = ColonyManager.getClosestColonyView((World)world, player.func_180425_c());
            if (colony != null && player != null && colony.getPermissions().hasPermission((EntityPlayer)player, Action.ACCESS_HUTS)) {
                for (CitizenDataView citizenDataView : new ArrayList<CitizenDataView>(colony.getCitizens().values())) {
                    Entity entityCitizen = world.func_73045_a(citizenDataView.getEntityId());
                    if (!(entityCitizen instanceof EntityCitizen) || !(entityCitizen.func_180425_c().func_177951_i((Vec3i)player.func_180425_c()) <= 2.0)) continue;
                    this.citizen = citizenDataView;
                    return;
                }
            }
        }
        colonyBorder.clear();
    }
}

