/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.pathfinding;

import com.minecolonies.api.configuration.Configurations;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.entity.pathfinding.AbstractPathJob;
import com.minecolonies.coremod.entity.pathfinding.Node;
import java.util.Random;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PathJobMoveAwayFromLocation
extends AbstractPathJob {
    private static final double TIE_BREAKER = 1.001;
    private static final int DIRECTIONS_TO_TRY = 4;
    private static final Random rand = new Random();
    @NotNull
    protected final BlockPos avoid;
    @NotNull
    protected final BlockPos heuristicPoint;
    protected final int avoidDistance;
    private final EnumFacing direction;

    public PathJobMoveAwayFromLocation(World world, @NotNull BlockPos start, @NotNull BlockPos avoid, int avoidDistance, int range) {
        super(world, start, avoid, range);
        this.avoid = new BlockPos((Vec3i)avoid);
        this.avoidDistance = avoidDistance;
        double dx = start.func_177958_n() - avoid.func_177958_n();
        double dz = start.func_177952_p() - avoid.func_177952_p();
        double scalar = (double)avoidDistance / Math.sqrt(dx * dx + dz * dz);
        dx *= scalar;
        dz *= scalar;
        int randomValue = rand.nextInt(4);
        if (randomValue == 0) {
            this.heuristicPoint = new BlockPos(start.func_177958_n() + (int)dx, start.func_177956_o(), start.func_177952_p());
            this.direction = EnumFacing.EAST;
        } else if (randomValue == 1) {
            this.heuristicPoint = new BlockPos(start.func_177958_n() - (int)dx, start.func_177956_o(), start.func_177952_p());
            this.direction = EnumFacing.WEST;
        } else if (randomValue == 2) {
            this.heuristicPoint = new BlockPos(start.func_177958_n(), start.func_177956_o(), start.func_177952_p() - (int)dz);
            this.direction = EnumFacing.NORTH;
        } else {
            this.heuristicPoint = new BlockPos(start.func_177958_n(), start.func_177956_o(), start.func_177952_p() + (int)dz);
            this.direction = EnumFacing.SOUTH;
        }
    }

    @Override
    @Nullable
    protected Path search() {
        if (Configurations.pathfinding.pathfindingDebugVerbosity > 0) {
            Log.getLogger().info(String.format("Pathfinding from [%d,%d,%d] away from [%d,%d,%d]", this.start.func_177958_n(), this.start.func_177956_o(), this.start.func_177952_p(), this.avoid.func_177958_n(), this.avoid.func_177956_o(), this.avoid.func_177952_p()));
        }
        return super.search();
    }

    @Override
    protected double computeHeuristic(@NotNull BlockPos pos) {
        int dx = pos.func_177958_n() - this.heuristicPoint.func_177958_n();
        int dy = pos.func_177956_o() - this.heuristicPoint.func_177956_o();
        int dz = pos.func_177952_p() - this.heuristicPoint.func_177952_p();
        return (double)(Math.abs(dx) + Math.abs(dy) + Math.abs(dz)) * 1.001;
    }

    @Override
    protected boolean isAtDestination(@NotNull Node n) {
        BlockPos vector = n.pos.func_177973_b((Vec3i)this.avoid);
        return this.getNodeResultScore(n) >= (double)(this.avoidDistance * this.avoidDistance) && EnumFacing.func_176737_a((float)vector.func_177958_n(), (float)0.0f, (float)vector.func_177952_p()).equals((Object)this.direction);
    }

    @Override
    protected double getNodeResultScore(@NotNull Node n) {
        return this.avoid.func_177954_c((double)n.pos.func_177958_n(), (double)n.pos.func_177956_o(), (double)n.pos.func_177952_p());
    }
}

