/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.pathfinding;

import com.minecolonies.api.entity.ai.pathfinding.AbstractWalkToProxy;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.Vec2i;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingMiner;
import com.minecolonies.coremod.colony.jobs.JobBuilder;
import com.minecolonies.coremod.colony.jobs.JobMiner;
import com.minecolonies.coremod.entity.EntityCitizen;
import com.minecolonies.coremod.entity.ai.citizen.miner.Level;
import com.minecolonies.coremod.entity.ai.citizen.miner.Node;
import com.minecolonies.coremod.util.WorkerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

public class EntityCitizenWalkToProxy
extends AbstractWalkToProxy {
    private static final int OTHER_SIDE_OF_SHAFT = 6;
    private final EntityCitizen citizen;

    public EntityCitizenWalkToProxy(EntityCitizen entity) {
        super((EntityLiving)entity);
        this.citizen = entity;
    }

    @Override
    public Set<BlockPos> getWayPoints() {
        if (this.citizen.getCitizenColonyHandler().getColony() == null) {
            return Collections.emptySet();
        }
        return this.citizen.getCitizenColonyHandler().getColony().getWayPoints().keySet();
    }

    @Override
    public boolean careAboutY() {
        return this.citizen.getCitizenJobHandler().getColonyJob() instanceof JobBuilder;
    }

    @Override
    public BlockPos getSpecializedProxy(BlockPos target, double distanceToPath) {
        AbstractBuildingWorker building = this.citizen.getCitizenColonyHandler().getWorkBuilding();
        if (this.citizen.getCitizenJobHandler().getColonyJob() != null && this.citizen.getCitizenJobHandler().getColonyJob() instanceof JobMiner && building instanceof BuildingMiner) {
            return this.getMinerProxy(target, distanceToPath, (BuildingMiner)building);
        }
        return null;
    }

    @NotNull
    private BlockPos getMinerProxy(BlockPos target, double distanceToPath, @NotNull BuildingMiner building) {
        Level level = building.getCurrentLevel();
        BlockPos ladderPos = building.getLadderLocation();
        if (level != null) {
            int levelDepth = level.getDepth() + 2;
            int targetY = target.func_177956_o();
            int workerY = this.citizen.func_180425_c().func_177956_o();
            if (workerY <= levelDepth && targetY > levelDepth) {
                if (building.getActiveNode() != null && building.getActiveNode().getParent() != null) {
                    Node currentNode = level.getNode(building.getActiveNode().getParent());
                    while (new Vec2i(currentNode.getX(), currentNode.getZ()).equals(currentNode.getParent()) && currentNode.getParent() != null) {
                        this.addToProxyList(new BlockPos(currentNode.getX(), levelDepth, currentNode.getZ()));
                        currentNode = level.getNode(currentNode.getParent());
                    }
                }
                this.addToProxyList(new BlockPos(ladderPos.func_177958_n() + building.getVectorX() * 6, level.getDepth(), ladderPos.func_177952_p() + building.getVectorZ() * 6));
                return this.getProxy(target, this.citizen.func_180425_c(), distanceToPath);
            }
            if (targetY <= levelDepth && workerY > levelDepth) {
                BlockPos buildingPos = building.getLocation();
                BlockPos newProxy = this.getProxy(buildingPos, this.citizen.func_180425_c(), BlockPosUtil.getDistanceSquared(this.citizen.func_180425_c(), buildingPos));
                this.addToProxyList(new BlockPos(ladderPos.func_177958_n() + building.getVectorX() * 6, level.getDepth(), ladderPos.func_177952_p() + building.getVectorZ() * 6));
                if (building.getActiveNode() != null && building.getActiveNode().getParent() != null) {
                    this.calculateNodes(level, levelDepth, building);
                }
                return newProxy;
            }
            if (targetY <= levelDepth) {
                double closestNode = Double.MAX_VALUE;
                Node lastNode = null;
                for (Map.Entry<Vec2i, Node> node : level.getNodes().entrySet()) {
                    double distanceToNode = node.getKey().distanceSq(this.citizen.func_180425_c().func_177958_n(), this.citizen.func_180425_c().func_177952_p());
                    if (!(distanceToNode < closestNode)) continue;
                    lastNode = node.getValue();
                    closestNode = distanceToNode;
                }
                if (lastNode != null && lastNode.getParent() != null) {
                    Node currentNode = level.getNode(lastNode.getParent());
                    while (new Vec2i(currentNode.getX(), currentNode.getZ()).equals(currentNode.getParent()) && currentNode.getParent() != null) {
                        this.addToProxyList(new BlockPos(currentNode.getX(), levelDepth, currentNode.getZ()));
                        currentNode = level.getNode(currentNode.getParent());
                    }
                }
                if (building.getActiveNode().getParent() != null) {
                    this.calculateNodes(level, levelDepth, building);
                }
                if (!this.getProxyList().isEmpty()) {
                    return this.getProxyList().get(0);
                }
                return target;
            }
        }
        return this.getProxy(target, this.citizen.func_180425_c(), distanceToPath);
    }

    private void calculateNodes(Level level, int levelDepth, BuildingMiner buildingMiner) {
        ArrayList<BlockPos> nodesToTarget = new ArrayList<BlockPos>();
        Node currentNode = level.getNode(buildingMiner.getActiveNode().getParent());
        while (currentNode != null && new Vec2i(currentNode.getX(), currentNode.getZ()).equals(currentNode.getParent()) && currentNode.getParent() != null) {
            nodesToTarget.add(new BlockPos(currentNode.getX(), levelDepth, currentNode.getZ()));
            currentNode = level.getNode(currentNode.getParent());
        }
        for (int i = nodesToTarget.size() - 1; i >= 0; --i) {
            this.addToProxyList((BlockPos)nodesToTarget.get(i));
        }
    }

    @Override
    public boolean isLivingAtSiteWithMove(EntityLiving entity, int x, int y, int z, int range) {
        return WorkerUtil.isWorkerAtSiteWithMove((EntityCitizen)entity, x, y, z, range);
    }
}

