/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.citizenhandlers;

import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.coremod.client.render.RenderBipedCitizen;
import com.minecolonies.coremod.colony.jobs.AbstractJob;
import com.minecolonies.coremod.entity.AbstractEntityCitizen;
import com.minecolonies.coremod.entity.EntityCitizen;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAIInteract;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAITasks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CitizenJobHandler {
    private final EntityCitizen citizen;
    private String lastJob = "";

    public CitizenJobHandler(EntityCitizen citizen) {
        this.citizen = citizen;
    }

    @NotNull
    public String getLastJob() {
        return this.lastJob;
    }

    public void setLastJob(@NotNull String jobName) {
        this.lastJob = jobName;
    }

    public void onJobChanged(@Nullable AbstractJob job) {
        Object[] currentTasks;
        if (job == null) {
            if (this.citizen.getCitizenData() != null) {
                switch (this.citizen.getCitizenData().getLevel()) {
                    case 1: {
                        this.citizen.setModelId(RenderBipedCitizen.Model.CITIZEN);
                        break;
                    }
                    case 2: {
                        this.citizen.setModelId(RenderBipedCitizen.Model.NOBLE);
                        break;
                    }
                    case 3: {
                        this.citizen.setModelId(RenderBipedCitizen.Model.ARISTOCRAT);
                        break;
                    }
                    default: {
                        this.citizen.setModelId(RenderBipedCitizen.Model.SETTLER);
                        break;
                    }
                }
            }
        } else {
            this.citizen.setModelId(job.getModel());
        }
        this.citizen.func_184212_Q().func_187227_b(AbstractEntityCitizen.DATA_MODEL, (Object)this.citizen.getModelID().name());
        this.citizen.setRenderMetadata("");
        for (Object task : currentTasks = this.citizen.field_70714_bg.field_75782_a.toArray()) {
            if (!(((EntityAITasks.EntityAITaskEntry)task).field_75733_a instanceof AbstractEntityAIInteract)) continue;
            this.citizen.field_70714_bg.func_85156_a(((EntityAITasks.EntityAITaskEntry)task).field_75733_a);
        }
        if (job != null) {
            job.addTasks(this.citizen.field_70714_bg);
            if (this.citizen.field_70173_aa > 0 && this.citizen.getCitizenColonyHandler().getWorkBuilding() != null) {
                BlockPosUtil.tryMoveLivingToXYZ((EntityLiving)this.citizen, this.citizen.getCitizenColonyHandler().getWorkBuilding().getLocation());
            }
        }
    }

    @Nullable
    public <J extends AbstractJob> J getColonyJob(@NotNull Class<J> type) {
        return this.citizen.getCitizenData() == null ? null : (J)this.citizen.getCitizenData().getJob(type);
    }

    @Nullable
    public AbstractJob getColonyJob() {
        return this.citizen.getCitizenData() == null ? null : this.citizen.getCitizenData().getJob();
    }
}

