/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.mobs.util;

import com.minecolonies.api.configuration.Configurations;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.constant.ColonyConstants;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.entity.ai.mobs.util.BarbarianSpawnUtils;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public final class MobEventsUtils {
    private static final int SPAWN_MODIFIER = 3;

    private MobEventsUtils() {
    }

    public static void barbarianEvent(World world, Colony colony) {
        if (world == null || !colony.isCanHaveBarbEvents()) {
            return;
        }
        Horde horde = MobEventsUtils.numberOfSpawns(colony);
        int hordeSize = horde.hordeSize;
        if (hordeSize == 0) {
            return;
        }
        BlockPos targetSpawnPoint = MobEventsUtils.calculateSpawnLocation(world, colony);
        Log.getLogger().info("[BarbarianEvent]: Spawning: " + targetSpawnPoint.func_177958_n() + " " + targetSpawnPoint.func_177952_p());
        if (targetSpawnPoint.equals((Object)colony.getCenter())) {
            return;
        }
        if (Configurations.gameplay.enableInDevelopmentFeatures) {
            LanguageHandler.sendPlayersMessage(colony.getMessageEntityPlayers(), "Horde Spawn Point: " + targetSpawnPoint, new Object[0]);
        }
        colony.getBarbManager().addBarbarianSpawnPoint(targetSpawnPoint);
        colony.markDirty();
        int raidNumber = 4;
        if (hordeSize < 5) {
            raidNumber = 1;
        } else if (hordeSize < 10) {
            raidNumber = 2;
        } else if (hordeSize < 20) {
            raidNumber = 3;
        }
        LanguageHandler.sendPlayersMessage(colony.getMessageEntityPlayers(), "event.minecolonies.raidMessage" + raidNumber, colony.getName());
        colony.setNightsSinceLastRaid(0);
        BarbarianSpawnUtils.spawn(ColonyConstants.BARBARIAN, horde.numberOfBarbarians, targetSpawnPoint, world);
        BarbarianSpawnUtils.spawn(ColonyConstants.ARCHER, horde.numberOfArchers, targetSpawnPoint, world);
        BarbarianSpawnUtils.spawn(ColonyConstants.CHIEF, horde.numberOfChiefs, targetSpawnPoint, world);
    }

    private static Horde numberOfSpawns(Colony colony) {
        int numberOfChiefs;
        int numberOfArchers;
        if (colony.getCitizenManager().getCitizens().size() < 5) {
            return new Horde(0, 0, 0, 0);
        }
        int raidLevel = MobEventsUtils.getColonyRaidLevel(colony);
        int numberOfBarbarians = (int)(0.5 * (double)raidLevel / 3.0);
        int hordeTotal = numberOfBarbarians + (numberOfArchers = (int)(0.25 * (double)raidLevel / 3.0)) + (numberOfChiefs = (int)(0.1 * (double)raidLevel / 3.0));
        if (hordeTotal > 40 && ColonyConstants.MAX_SIZE == 40) {
            numberOfBarbarians = 22;
            numberOfArchers = 16;
            numberOfChiefs = 2;
        } else if (hordeTotal > ColonyConstants.MAX_SIZE) {
            numberOfBarbarians = MobEventsUtils.equalizeBarbarianSpawns(hordeTotal, numberOfBarbarians);
            hordeTotal = numberOfArchers + numberOfBarbarians + numberOfChiefs;
            numberOfArchers = MobEventsUtils.equalizeBarbarianSpawns(hordeTotal, numberOfArchers);
            hordeTotal = numberOfArchers + numberOfBarbarians + numberOfChiefs;
            numberOfChiefs = MobEventsUtils.equalizeBarbarianSpawns(hordeTotal, numberOfChiefs);
        }
        return new Horde(hordeTotal, numberOfBarbarians, numberOfArchers, numberOfChiefs);
    }

    private static BlockPos calculateSpawnLocation(World world, @NotNull Colony colony) {
        Random random = new Random();
        BlockPos pos = colony.getBarbManager().getRandomOutsiderInDirection(random.nextInt(2) < 1 ? EnumFacing.EAST : EnumFacing.WEST, random.nextInt(2) < 1 ? EnumFacing.NORTH : EnumFacing.SOUTH);
        if (pos.equals((Object)colony.getCenter())) {
            Log.getLogger().info("Spawning at colony center: " + colony.getCenter().func_177958_n() + " " + colony.getCenter().func_177952_p());
            return colony.getCenter();
        }
        return BlockPosUtil.findLand(pos, world);
    }

    public static int getColonyRaidLevel(Colony colony) {
        int levels = 0;
        ArrayList<CitizenData> citizensList = new ArrayList<CitizenData>();
        citizensList.addAll(colony.getCitizenManager().getCitizens());
        for (CitizenData citizen : citizensList) {
            levels += citizen.getLevel();
        }
        return levels;
    }

    private static int equalizeBarbarianSpawns(int total, int numberOf) {
        int returnValue = numberOf;
        if (total > ColonyConstants.MAX_SIZE) {
            returnValue = total - ColonyConstants.MAX_SIZE;
            if (returnValue < 0) {
                return 0;
            }
            return returnValue;
        }
        return returnValue;
    }

    public static boolean isItTimeToRaid(World world, Colony colony) {
        if (colony.getCitizenManager().getCitizens().size() < 5) {
            return false;
        }
        if (world.func_72935_r() && !colony.isHasRaidBeenCalculated()) {
            colony.getBarbManager().setHasRaidBeenCalculated(true);
            if (!colony.hasWillRaidTonight()) {
                boolean raid = MobEventsUtils.raidThisNight(world, colony);
                if (Configurations.gameplay.enableInDevelopmentFeatures) {
                    LanguageHandler.sendPlayersMessage(colony.getMessageEntityPlayers(), "Will raid tonight: " + raid, new Object[0]);
                }
                colony.getBarbManager().setWillRaidTonight(raid);
            }
            return false;
        }
        if (colony.hasWillRaidTonight() && !world.func_72935_r() && colony.isHasRaidBeenCalculated()) {
            colony.getBarbManager().setHasRaidBeenCalculated(false);
            colony.getBarbManager().setWillRaidTonight(false);
            if (Configurations.gameplay.enableInDevelopmentFeatures) {
                LanguageHandler.sendPlayersMessage(colony.getMessageEntityPlayers(), "Night reached: raiding", new Object[0]);
            }
            return true;
        }
        if (!world.func_72935_r() && colony.isHasRaidBeenCalculated()) {
            colony.getBarbManager().setHasRaidBeenCalculated(false);
        }
        return false;
    }

    private static boolean raidThisNight(World world, Colony colony) {
        return colony.getNightsSinceLastRaid() > Configurations.gameplay.minimumNumberOfNightsBetweenRaids && world.field_73012_v.nextDouble() < 1.0 / (double)Configurations.gameplay.averageNumberOfNightsBetweenRaids;
    }

    private static class Horde {
        private final int numberOfBarbarians;
        private final int numberOfArchers;
        private final int numberOfChiefs;
        private final int hordeSize;

        public Horde(int hordeSize, int numberOfBarbarians, int numberOfArchers, int numberOfChiefs) {
            this.hordeSize = hordeSize;
            this.numberOfBarbarians = numberOfBarbarians;
            this.numberOfArchers = numberOfArchers;
            this.numberOfChiefs = numberOfChiefs;
        }
    }
}

