/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.mobs.barbarians;

import com.minecolonies.api.configuration.Configurations;
import com.minecolonies.api.util.CompatibilityUtils;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.entity.ai.mobs.util.BarbarianSpawnUtils;
import com.minecolonies.coremod.entity.ai.mobs.util.BarbarianUtils;
import com.minecolonies.coremod.items.ItemChiefSword;
import com.minecolonies.coremod.sounds.BarbarianSounds;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;

public abstract class AbstractEntityBarbarian
extends EntityMob {
    private static final String TAG_TIME = "time";
    private static final int BARBARIAN_EXP_DROP = 1;
    private static final int BARBARIAN_HORDE_DIFFICULTY_FIVE = 5;
    private static final int OUT_OF_ONE_HUNDRED = 100;
    private static final int ONE = 1;
    private static final Potion SPEED_EFFECT = Potion.func_188412_a((int)1);
    private static final int TIME_TO_COUNTDOWN = 240;
    private static final int COUNTDOWN_SECOND_MULTIPLIER = 4;
    private static final int SPEED_EFFECT_DISTANCE = 7;
    private static final int SPEED_EFFECT_DURATION = 240;
    private static final int SPEED_EFFECT_MULTIPLIER = 2;
    private static final int TICKS_TO_DESPAWN = 12000;
    private static final int EVERY_X_TICKS = 20;
    private Colony colony;
    private final Random random = new Random();
    private int currentCount = 0;
    private long worldTimeAtSpawn = 0L;
    private int currentTick = 1;

    public AbstractEntityBarbarian(World world) {
        super(world);
    }

    protected void func_184651_r() {
        BarbarianSpawnUtils.setBarbarianAI(this);
    }

    protected void func_70088_a() {
        this.worldTimeAtSpawn = this.field_70170_p.func_82737_E();
        this.func_110163_bv();
        super.func_70088_a();
    }

    public void func_70642_aH() {
        SoundEvent soundevent = this.func_184639_G();
        if (soundevent != null && this.field_70170_p.field_73012_v.nextInt(100) <= 1) {
            this.func_184185_a(soundevent, this.func_70599_aP(), this.func_70647_i());
        }
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return BarbarianSounds.barbarianSay;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return BarbarianSpawnUtils.getBarbarianLootTable(this);
    }

    protected boolean func_70692_ba() {
        return this.shouldDespawn() || this.getColony() == null;
    }

    public Colony getColony() {
        if (!this.field_70170_p.field_72995_K && this.colony == null) {
            this.colony = ColonyManager.getClosestColony(CompatibilityUtils.getWorld((Entity)this), this.func_180425_c());
            if (this.colony != null) {
                this.colony.getBarbManager().registerBarbarian(this);
            }
        }
        return this.colony;
    }

    private boolean shouldDespawn() {
        return this.worldTimeAtSpawn != 0L && this.field_70170_p.func_82737_E() - this.worldTimeAtSpawn >= 12000L;
    }

    protected void func_82160_b(boolean wasRecentlyHit, int lootingModifier) {
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        BarbarianSpawnUtils.setBarbarianEquipment(this);
        return super.func_180482_a(difficulty, livingdata);
    }

    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K) {
            super.func_70636_d();
            return;
        }
        if (this.currentTick % (this.random.nextInt(20) + 1) == 0) {
            if (this.worldTimeAtSpawn == 0L) {
                this.worldTimeAtSpawn = this.field_70170_p.func_82737_E();
            }
            if (this.shouldDespawn()) {
                this.func_70106_y();
            }
            if (this.currentCount <= 0) {
                this.currentCount = 960;
                BarbarianSpawnUtils.setBarbarianAttributes(this, this.getColony());
                if (this.func_184614_ca() != null && SPEED_EFFECT != null && this.func_184614_ca().func_77973_b() instanceof ItemChiefSword && Configurations.gameplay.barbarianHordeDifficulty >= 5) {
                    BarbarianUtils.getBarbariansCloseToEntity((Entity)this, 7.0).stream().filter(entity -> !entity.func_70644_a(SPEED_EFFECT)).forEach(entity -> entity.func_70690_d(new PotionEffect(SPEED_EFFECT, 240, 2)));
                }
            } else {
                --this.currentCount;
            }
        }
        ++this.currentTick;
        super.func_70636_d();
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return BarbarianSounds.barbarianHurt;
    }

    protected SoundEvent func_184615_bR() {
        return BarbarianSounds.barbarianDeath;
    }

    public NBTTagCompound func_189511_e(NBTTagCompound compound) {
        compound.func_74772_a(TAG_TIME, this.worldTimeAtSpawn);
        return super.func_189511_e(compound);
    }

    public void func_70020_e(NBTTagCompound compound) {
        this.worldTimeAtSpawn = compound.func_74763_f(TAG_TIME);
        super.func_70020_e(compound);
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K && this.getColony() != null) {
            this.getColony().getBarbManager().unregisterBarbarian(this);
        }
    }

    protected void func_70609_aI() {
        if (!(this.func_94060_bK() instanceof EntityPlayer) && this.field_70718_bc > 0 && this.func_146066_aG() && this.field_70170_p.func_82736_K().func_82766_b("doMobLoot")) {
            int experience = EntityXPOrb.func_70527_a((int)1);
            CompatibilityUtils.spawnEntity(this.field_70170_p, (Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, experience));
        }
        super.func_70609_aI();
    }
}

