/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.minimal;

import com.minecolonies.api.entity.ai.DesiredActivity;
import com.minecolonies.api.util.CompatibilityUtils;
import com.minecolonies.coremod.entity.EntityCitizen;
import com.minecolonies.coremod.entity.ai.util.ChatSpamFilter;
import com.minecolonies.coremod.util.SoundUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

public class EntityAIGoHome
extends EntityAIBase {
    private static final int CHANCE = 100;
    private static final DamageSource CLEANUP_DAMAGE = new DamageSource("CleanUpTask");
    @NotNull
    protected final ChatSpamFilter chatSpamFilter;
    private final EntityCitizen citizen;

    public EntityAIGoHome(EntityCitizen citizen) {
        this.citizen = citizen;
        this.chatSpamFilter = new ChatSpamFilter(citizen.getCitizenData());
    }

    public boolean func_75250_a() {
        boolean areBarbariansInColony = this.citizen.getCitizenColonyHandler().getColony().getBarbManager().getHorde().size() > 0;
        return !this.citizen.getCitizenColonyHandler().isAtHome() && (this.citizen.getDesiredActivity() == DesiredActivity.SLEEP || areBarbariansInColony);
    }

    public boolean func_75253_b() {
        return !this.citizen.getNavigator().func_75500_f() && this.citizen.getDesiredActivity() == DesiredActivity.SLEEP;
    }

    public void func_75249_e() {
        BlockPos pos = this.citizen.func_180486_cf();
        if (pos == null) {
            if (this.citizen.getCitizenColonyHandler().getColony() == null) {
                this.citizen.func_70645_a(CLEANUP_DAMAGE);
            } else {
                this.citizen.isWorkerAtSiteWithMove(this.citizen.getCitizenColonyHandler().getColony().getCenter(), 2);
            }
            return;
        }
        this.citizen.isWorkerAtSiteWithMove(pos, 2);
        this.playGoHomeSounds();
    }

    public void func_75248_a(int mutexBitsIn) {
        super.func_75248_a(1);
    }

    private void playGoHomeSounds() {
        int chance = this.citizen.getRandom().nextInt(100);
        if (chance <= 1 && this.citizen.getCitizenColonyHandler().getWorkBuilding() != null && this.citizen.getCitizenJobHandler().getColonyJob() != null) {
            SoundUtils.playSoundAtCitizenWithChance(CompatibilityUtils.getWorld((Entity)this.citizen), this.citizen.func_180425_c(), this.citizen.getCitizenJobHandler().getColonyJob().getBedTimeSound(), 1);
        }
    }
}

