/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.minimal;

import com.minecolonies.api.util.CompatibilityUtils;
import com.minecolonies.coremod.colony.jobs.AbstractJobGuard;
import com.minecolonies.coremod.entity.EntityCitizen;
import com.minecolonies.coremod.entity.ai.mobs.barbarians.AbstractEntityBarbarian;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import org.jetbrains.annotations.Nullable;

public class EntityAICitizenAvoidEntity
extends EntityAIBase {
    private static final double TOO_CLOSE_TO_MOB = 49.0;
    private final EntityCitizen theEntity;
    private final double farSpeed;
    private final double nearSpeed;
    private final float distanceFromEntity;
    private final Class<? extends Entity> targetEntityClass;
    @Nullable
    private Entity closestLivingEntity;

    public EntityAICitizenAvoidEntity(EntityCitizen entity, Class<? extends Entity> targetEntityClass, float distanceFromEntity, double farSpeed, double nearSpeed) {
        this.theEntity = entity;
        this.targetEntityClass = targetEntityClass;
        this.distanceFromEntity = distanceFromEntity;
        this.farSpeed = farSpeed;
        this.nearSpeed = nearSpeed;
        super.func_75248_a(1);
    }

    public boolean func_75250_a() {
        this.closestLivingEntity = this.getClosestToAvoid();
        if (this.closestLivingEntity instanceof AbstractEntityBarbarian) {
            return false;
        }
        return this.closestLivingEntity != null && !(this.theEntity.getCitizenJobHandler().getColonyJob() instanceof AbstractJobGuard) && this.theEntity.func_70685_l(this.closestLivingEntity);
    }

    private Entity getClosestToAvoid() {
        if (this.targetEntityClass == EntityPlayer.class) {
            return CompatibilityUtils.getWorld((Entity)this.theEntity).func_72890_a((Entity)this.theEntity, (double)this.distanceFromEntity);
        }
        Optional<Entity> entityOptional = CompatibilityUtils.getWorld((Entity)this.theEntity).func_175674_a((Entity)this.theEntity, this.theEntity.func_174813_aQ().func_72321_a((double)this.distanceFromEntity, 3.0, (double)this.distanceFromEntity), target -> target.func_70089_S() && this.theEntity.func_70635_at().func_75522_a(target)).stream().filter(this.targetEntityClass::isInstance).findFirst();
        return entityOptional.isPresent() ? entityOptional.get() : null;
    }

    public boolean func_75253_b() {
        if (this.closestLivingEntity instanceof AbstractEntityBarbarian) {
            return false;
        }
        return !this.theEntity.getNavigator().func_75500_f();
    }

    public void func_75249_e() {
        this.performMoveAway();
    }

    private void performMoveAway() {
        if (this.closestLivingEntity instanceof AbstractEntityBarbarian) {
            return;
        }
        this.theEntity.getNavigator().moveAwayFromEntityLiving(this.closestLivingEntity, (double)this.distanceFromEntity * 2.0, this.nearSpeed);
    }

    public void func_75251_c() {
        this.closestLivingEntity = null;
    }

    public void func_75246_d() {
        this.theEntity.playMoveAwaySound();
        Entity newClosest = this.getClosestToAvoid();
        if (newClosest != null && newClosest.func_145782_y() != this.closestLivingEntity.func_145782_y()) {
            this.closestLivingEntity = newClosest;
            this.performMoveAway();
            this.theEntity.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TextComponentTranslation("com.minecolonies.coremod.status.avoiding", new Object[0])});
            return;
        }
        if ((double)this.theEntity.func_70032_d(this.closestLivingEntity) < 49.0) {
            this.theEntity.getNavigator().func_75489_a(this.nearSpeed);
        } else {
            this.theEntity.getNavigator().func_75489_a(this.farSpeed);
        }
    }
}

