/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.miner;

import com.minecolonies.api.util.Vec2i;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingMiner;
import com.minecolonies.coremod.entity.ai.citizen.miner.Node;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Random;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.MathHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Level {
    private static final String TAG_DEPTH = "Depth";
    private static final String TAG_NODES = "Nodes";
    private static final String TAG_LADDERX = "LadderX";
    private static final String TAG_LADDERZ = "LadderZ";
    private static final String TAG_OPEN_NODES = "OpenNodes";
    private static final int ROTATE_ONCE = 1;
    private static final int ROTATE_TWICE = 2;
    private static final int ROTATE_THREE_TIMES = 3;
    private static final int MAX_ROTATIONS = 4;
    private static final Random rand = new Random();
    private static final int RANDOM_TYPES = 4;
    @NotNull
    private static final Comparator<Node> NODE_COMPARATOR = (n1, n2) -> rand.nextInt(100) > 50 ? 1 : -1;
    @NotNull
    private final Map<Vec2i, Node> nodes = new HashMap<Vec2i, Node>();
    @NotNull
    private final Queue<Node> openNodes = new PriorityQueue<Node>(11, NODE_COMPARATOR);
    private final int depth;
    private final Node ladderNode;

    public Level(@NotNull BuildingMiner buildingMiner, int depth) {
        this.depth = depth;
        int cobbleX = buildingMiner.getCobbleLocation().func_177958_n();
        int cobbleZ = buildingMiner.getCobbleLocation().func_177952_p();
        Vec2i cobbleCenter = new Vec2i(cobbleX - buildingMiner.getVectorX() * 3, cobbleZ - buildingMiner.getVectorZ() * 3);
        Vec2i ladderCenter = new Vec2i(cobbleX + buildingMiner.getVectorX() * 4, cobbleZ + buildingMiner.getVectorZ() * 4);
        Node cobbleNode = new Node(cobbleCenter.getX(), cobbleCenter.getZ(), ladderCenter);
        cobbleNode.setStyle(Node.NodeType.LADDER_BACK);
        cobbleNode.setStatus(Node.NodeStatus.COMPLETED);
        this.nodes.put(cobbleCenter, cobbleNode);
        this.ladderNode = new Node(ladderCenter.getX(), ladderCenter.getZ(), null);
        this.ladderNode.setStyle(Node.NodeType.SHAFT);
        this.ladderNode.setStatus(Node.NodeStatus.COMPLETED);
        this.nodes.put(ladderCenter, this.ladderNode);
        ArrayList<Vec2i> nodeCenterList = new ArrayList<Vec2i>(4);
        nodeCenterList.add(this.ladderNode.getNorthNodeCenter());
        nodeCenterList.add(this.ladderNode.getSouthNodeCenter());
        nodeCenterList.add(this.ladderNode.getEastNodeCenter());
        nodeCenterList.add(this.ladderNode.getWestNodeCenter());
        for (Vec2i pos : nodeCenterList) {
            if (cobbleCenter.equals(pos) || ladderCenter.equals(pos)) continue;
            Node tempNode = new Node(pos.getX(), pos.getZ(), ladderCenter);
            tempNode.setStyle(Node.NodeType.TUNNEL);
            this.nodes.put(pos, tempNode);
            this.openNodes.add(tempNode);
        }
    }

    public Level(@NotNull NBTTagCompound compound) {
        int ladderZ;
        int ladderX;
        this.depth = compound.func_74762_e(TAG_DEPTH);
        NBTTagList nodeTagList = compound.func_150295_c(TAG_NODES, 10);
        for (int i = 0; i < nodeTagList.func_74745_c(); ++i) {
            Node node = Node.createFromNBT(nodeTagList.func_150305_b(i));
            this.nodes.put(new Vec2i(node.getX(), node.getZ()), node);
        }
        boolean hasDoubles = compound.func_150297_b(TAG_LADDERX, 6);
        if (hasDoubles) {
            ladderX = MathHelper.func_76128_c((double)compound.func_74769_h(TAG_LADDERX));
            ladderZ = MathHelper.func_76128_c((double)compound.func_74769_h(TAG_LADDERZ));
        } else {
            ladderX = compound.func_74762_e(TAG_LADDERX);
            ladderZ = compound.func_74762_e(TAG_LADDERZ);
        }
        this.ladderNode = this.nodes.get(new Vec2i(ladderX, ladderZ));
        NBTTagList openNodeTagList = compound.func_150295_c(TAG_OPEN_NODES, 10);
        for (int i = 0; i < openNodeTagList.func_74745_c(); ++i) {
            Node node = Node.createFromNBT(openNodeTagList.func_150305_b(i));
            this.openNodes.add(node);
        }
    }

    public Node getRandomNode(@Nullable Node node) {
        Node nextNode = null;
        if (node != null && rand.nextInt(4) > 0) {
            nextNode = node.getRandomNextNode(this, 0);
        }
        return nextNode == null ? this.openNodes.peek() : nextNode;
    }

    public void closeNextNode(int rotation, Node node) {
        Node tempNode = node == null ? this.openNodes.peek() : node;
        ArrayList<Vec2i> nodeCenterList = new ArrayList<Vec2i>(3);
        if (tempNode == null) {
            return;
        }
        switch (tempNode.getStyle()) {
            case TUNNEL: {
                nodeCenterList.add(Level.getNextNodePositionFromNodeWithRotation(tempNode, rotation, 0));
                break;
            }
            case BEND: {
                nodeCenterList.add(Level.getNextNodePositionFromNodeWithRotation(tempNode, rotation, 3));
                break;
            }
            case CROSSROAD: {
                nodeCenterList.add(Level.getNextNodePositionFromNodeWithRotation(tempNode, rotation, 0));
                nodeCenterList.add(Level.getNextNodePositionFromNodeWithRotation(tempNode, rotation, 1));
                nodeCenterList.add(Level.getNextNodePositionFromNodeWithRotation(tempNode, rotation, 3));
                break;
            }
            default: {
                return;
            }
        }
        for (Vec2i pos : nodeCenterList) {
            if (this.nodes.containsKey(pos)) continue;
            Node tempNodeToAdd = new Node(pos.getX(), pos.getZ(), new Vec2i(tempNode.getX(), tempNode.getZ()));
            tempNodeToAdd.setStyle(Level.getRandomNodeType());
            this.nodes.put(pos, tempNodeToAdd);
            this.openNodes.add(tempNodeToAdd);
        }
        this.nodes.get(new Vec2i(tempNode.getX(), tempNode.getZ())).setStatus(Node.NodeStatus.COMPLETED);
        this.openNodes.removeIf(tempNode::equals);
    }

    private static Vec2i getNextNodePositionFromNodeWithRotation(Node node, int rotation, int additionalRotation) {
        int realRotation = Math.floorMod(rotation + additionalRotation, 4);
        switch (realRotation) {
            case 1: {
                return node.getSouthNodeCenter();
            }
            case 2: {
                return node.getWestNodeCenter();
            }
            case 3: {
                return node.getNorthNodeCenter();
            }
        }
        return node.getEastNodeCenter();
    }

    private static Node.NodeType getRandomNodeType() {
        int randNumber = rand.nextInt(4);
        if (randNumber <= 1) {
            return Node.NodeType.TUNNEL;
        }
        if (randNumber == 2) {
            return Node.NodeType.BEND;
        }
        return Node.NodeType.CROSSROAD;
    }

    @NotNull
    public String toString() {
        return "Level{depth=" + this.depth + ", nodes=" + this.nodes + ", ladderNode=" + this.ladderNode + '}';
    }

    public void writeToNBT(@NotNull NBTTagCompound compound) {
        compound.func_74768_a(TAG_DEPTH, this.depth);
        NBTTagList nodeTagList = new NBTTagList();
        for (Node node : this.nodes.values()) {
            NBTTagCompound nodeCompound = new NBTTagCompound();
            node.writeToNBT(nodeCompound);
            nodeTagList.func_74742_a((NBTBase)nodeCompound);
        }
        compound.func_74782_a(TAG_NODES, (NBTBase)nodeTagList);
        compound.func_74768_a(TAG_LADDERX, this.ladderNode.getX());
        compound.func_74768_a(TAG_LADDERZ, this.ladderNode.getZ());
        NBTTagList openNodeTagList = new NBTTagList();
        for (Node node : this.openNodes) {
            NBTTagCompound nodeCompound = new NBTTagCompound();
            node.writeToNBT(nodeCompound);
            openNodeTagList.func_74742_a((NBTBase)nodeCompound);
        }
        compound.func_74782_a(TAG_OPEN_NODES, (NBTBase)openNodeTagList);
    }

    @NotNull
    public Map<Vec2i, Node> getNodes() {
        return Collections.unmodifiableMap(this.nodes);
    }

    public int getNumberOfNodes() {
        return this.nodes.size();
    }

    public int getDepth() {
        return this.depth;
    }

    @NotNull
    public Node getLadderNode() {
        return this.ladderNode;
    }

    public void addNode(Node newNode) {
        this.nodes.put(new Vec2i(newNode.getX(), newNode.getZ()), newNode);
    }

    public Node getNode(Vec2i key) {
        return this.nodes.get(key);
    }

    public Node getOpenNode(Vec2i key) {
        return this.nodes.get(key);
    }
}

