/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.guard;

import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.coremod.colony.jobs.JobKnight;
import com.minecolonies.coremod.entity.ai.citizen.guard.AbstractEntityAIGuard;
import com.minecolonies.coremod.entity.ai.util.AIState;
import java.util.List;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class EntityAIKnight
extends AbstractEntityAIGuard<JobKnight> {
    private static final double MAX_DISTANCE_FOR_ATTACK = 3.0;
    private static final int BASE_RELOAD_TIME = 30;

    public EntityAIKnight(@NotNull JobKnight job) {
        super(job);
        this.toolsNeeded.add(ToolType.SWORD);
        this.itemsNeeded.add(new ItemStack(Items.field_185159_cQ, 1));
    }

    @Override
    protected int getAttackRange() {
        return 3;
    }

    @Override
    protected int getAttackDelay() {
        if (this.worker.getCitizenData() != null) {
            return 30 / (this.worker.getCitizenData().getLevel() + 1);
        }
        return 30;
    }

    @Override
    @NotNull
    protected List<ItemStack> itemsNiceToHave() {
        List<ItemStack> list = super.itemsNiceToHave();
        list.add(new ItemStack(Items.field_185159_cQ, 1));
        return list;
    }

    @Override
    protected AIState decide() {
        AIState superState = super.decide();
        if (superState != AIState.DECIDE || this.target == null) {
            return superState;
        }
        return AIState.GUARD_ATTACK_PHYSICAL;
    }
}

