/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.guard;

import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.compatibility.tinkers.TinkersWeaponHelper;
import com.minecolonies.api.util.InventoryFunctions;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingContainer;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.buildings.AbstractSchematicProvider;
import com.minecolonies.coremod.colony.buildings.views.MobEntryView;
import com.minecolonies.coremod.colony.jobs.AbstractJobGuard;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAIInteract;
import com.minecolonies.coremod.entity.ai.citizen.guard.GuardArrow;
import com.minecolonies.coremod.entity.ai.mobs.barbarians.AbstractEntityBarbarian;
import com.minecolonies.coremod.entity.ai.util.AIState;
import com.minecolonies.coremod.entity.ai.util.AITarget;
import com.minecolonies.coremod.tileentities.TileEntityColonyBuilding;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractEntityAIGuard<J extends AbstractJobGuard>
extends AbstractEntityAIInteract<J> {
    public final List<ToolType> toolsNeeded = new ArrayList<ToolType>();
    public final List<ItemStack> itemsNeeded = new ArrayList<ItemStack>();
    protected int currentAttackDelay = 0;
    protected EntityLivingBase target = null;
    private BlockPos currentPatrolPoint = null;

    public AbstractEntityAIGuard(@NotNull J job) {
        super(job);
        super.registerTargets(new AITarget(AIState.IDLE, AIState.START_WORKING), new AITarget(AIState.START_WORKING, this::startWorkingAtOwnBuilding), new AITarget(AIState.PREPARING, this::prepare), new AITarget(AIState.DECIDE, this::decide), new AITarget(AIState.GUARD_ATTACK_PROTECT, this::attackProtect), new AITarget(AIState.GUARD_ATTACK_PHYSICAL, this::attackPhysical), new AITarget(AIState.GUARD_ATTACK_RANGED, this::attackRanged));
        this.worker.getCitizenExperienceHandler().setSkillModifier(2 * this.worker.getCitizenData().getStrength() + this.worker.getCitizenData().getIntelligence());
        this.worker.func_98053_h(true);
    }

    @Override
    public Class getExpectedBuildingClass() {
        return AbstractBuildingGuards.class;
    }

    @Override
    protected void updateRenderMetaData() {
        this.updateArmor();
    }

    protected abstract int getAttackRange();

    private AIState startWorkingAtOwnBuilding() {
        this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TextComponentTranslation("com.minecolonies.coremod.status.worker.goingToHut", new Object[0])});
        if (this.walkToBuilding()) {
            return this.getState();
        }
        return AIState.PREPARING;
    }

    private AIState prepare() {
        this.setDelay(100);
        for (ToolType tool : this.toolsNeeded) {
            if (this.checkForToolOrWeapon(tool)) {
                return this.getState();
            }
            if (this.getOwnBuilding() == null) continue;
            InventoryFunctions.matchFirstInProviderWithSimpleAction((ICapabilityProvider)this.worker, stack -> ItemStackUtils.isEmpty(stack) == false && ItemStackUtils.doesItemServeAsWeapon(stack) && ItemStackUtils.hasToolLevel(stack, tool, 0, ((AbstractBuildingWorker)this.getOwnBuilding()).getMaxToolLevel()), itemStack -> this.worker.getCitizenItemHandler().setMainHeldItem((int)itemStack));
        }
        for (ItemStack item : this.itemsNeeded) {
            this.checkIfRequestForItemExistOrCreateAsynch(item);
        }
        if (this.getOwnBuilding() != null) {
            TileEntityColonyBuilding chest = ((AbstractBuildingContainer)this.getOwnBuilding()).getTileEntity();
            for (int i = 0; i < ((AbstractBuildingContainer)this.getOwnBuilding()).getTileEntity().func_70302_i_(); ++i) {
                ItemStack stack2 = chest.func_70301_a(i);
                if (InventoryUtils.findFirstSlotInProviderWith((ICapabilityProvider)chest, itemStack -> itemStack.func_77973_b() instanceof ItemArmor) == -1) continue;
                InventoryUtils.transferXOfFirstSlotInProviderWithIntoNextFreeSlotInItemHandler(this.getOwnBuilding(), itemStack -> itemStack.func_77973_b() instanceof ItemArmor, stack2.func_190916_E(), (IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()));
            }
        }
        return AIState.DECIDE;
    }

    protected AIState decide() {
        this.setDelay(20);
        for (ToolType toolType : this.toolsNeeded) {
            if (this.getOwnBuilding() == null || InventoryUtils.hasItemHandlerToolWithLevel((IItemHandler)new InvWrapper((IInventory)this.getInventory()), toolType, 0, ((AbstractBuildingWorker)this.getOwnBuilding()).getMaxToolLevel())) continue;
            return AIState.START_WORKING;
        }
        if ((this.worker.func_110144_aD() == null || this.worker.func_110144_aD().field_70128_L) && this.getOwnBuilding(AbstractBuildingGuards.class) != null && this.target == null) {
            AbstractBuildingGuards guardBuilding = (AbstractBuildingGuards)this.getOwnBuilding();
            switch (guardBuilding.getTask()) {
                case PATROL: {
                    if (this.currentPatrolPoint == null) {
                        this.currentPatrolPoint = guardBuilding.getNextPatrolTarget(null);
                    }
                    if (this.currentPatrolPoint == null || !this.worker.isWorkerAtSiteWithMove(this.currentPatrolPoint, 2)) break;
                    this.currentPatrolPoint = guardBuilding.getNextPatrolTarget(this.currentPatrolPoint);
                    break;
                }
                case GUARD: {
                    this.worker.isWorkerAtSiteWithMove(guardBuilding.getGuardPos(), 0);
                    break;
                }
                case FOLLOW: {
                    this.worker.isWorkerAtSiteWithMove(guardBuilding.getPlayerToFollow(), 0);
                    break;
                }
                default: {
                    this.worker.isWorkerAtSiteWithMove(this.worker.getCitizenColonyHandler().getWorkBuilding().getLocation(), 0);
                }
            }
        }
        if (this.target == null) {
            this.target = this.getTarget();
        }
        if (this.target != null && this.target.field_70128_L) {
            this.worker.getCitizenExperienceHandler().addExperience(5.0);
            this.target = null;
        }
        return AIState.DECIDE;
    }

    protected EntityLivingBase getTarget() {
        AbstractBuildingGuards building = (AbstractBuildingGuards)this.getOwnBuilding();
        if (building != null && this.target == null && this.worker.getCitizenColonyHandler().getColony() != null) {
            for (CitizenData citizenData : this.worker.getCitizenColonyHandler().getColony().getCitizenManager().getCitizens()) {
                EntityLivingBase entity;
                if (!citizenData.getCitizenEntity().isPresent() || !((entity = citizenData.getCitizenEntity().get().func_70643_av()) instanceof AbstractEntityBarbarian) || !this.worker.func_70685_l((Entity)entity)) continue;
                return entity;
            }
            List targets = this.world.func_72872_a(EntityLivingBase.class, this.getSearchArea());
            for (EntityLivingBase entity : targets) {
                if (!(entity instanceof EntityPlayer)) continue;
                EntityPlayer player = (EntityPlayer)entity;
                if (this.worker.getCitizenColonyHandler().getColony() == null || !this.worker.getCitizenColonyHandler().getColony().getPermissions().hasPermission(player, Action.GUARDS_ATTACK) || !this.worker.func_70685_l((Entity)player)) continue;
                return entity;
            }
            float f = -1.0f;
            EntityLivingBase targetEntity = null;
            for (MobEntryView mobEntry : building.getMobsToAttack()) {
                if (!mobEntry.hasAttack()) continue;
                for (EntityLivingBase entity : targets) {
                    if (!mobEntry.getEntityEntry().getEntityClass().isInstance(entity) || !this.worker.func_70685_l((Entity)entity) || !(this.worker.func_70032_d((Entity)entity) < f) && (int)f != -1) continue;
                    f = this.worker.func_70032_d((Entity)entity);
                    targetEntity = entity;
                }
                if (targetEntity == null) continue;
                return targetEntity;
            }
        } else if (this.target != null) {
            return this.target;
        }
        return null;
    }

    protected AIState attackProtect() {
        this.setDelay(2);
        int shieldSlot = InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)new InvWrapper((IInventory)this.getInventory()), Items.field_185159_cQ, -1);
        if (shieldSlot != -1 && this.target != null && !this.target.field_70128_L) {
            this.worker.getCitizenItemHandler().setHeldItem(EnumHand.OFF_HAND, shieldSlot);
            this.worker.func_184598_c(EnumHand.OFF_HAND);
            this.worker.func_70625_a((Entity)this.target, 180.0f, 180.0f);
            this.worker.func_70671_ap().func_75651_a((Entity)this.target, 180.0f, 180.0f);
            if (this.worker.func_70032_d((Entity)this.target) > (float)this.getAttackRange()) {
                this.worker.isWorkerAtSiteWithMove(this.target.func_180425_c(), this.getAttackRange());
            }
        }
        return AIState.GUARD_ATTACK_PHYSICAL;
    }

    protected AIState attackPhysical() {
        if (this.worker.func_70643_av() != null && !this.worker.func_70643_av().field_70128_L && this.worker.func_70032_d((Entity)this.worker.func_70643_av()) < (float)this.getAttackRange()) {
            this.target = this.worker.func_70643_av();
        }
        if (this.target == null || this.target.field_70128_L) {
            this.worker.getCitizenExperienceHandler().addExperience(5.0);
            return AIState.DECIDE;
        }
        if (this.currentAttackDelay != 0) {
            --this.currentAttackDelay;
            return AIState.GUARD_ATTACK_PROTECT;
        }
        this.currentAttackDelay = this.getAttackDelay();
        if (this.getOwnBuilding() != null) {
            if (this.worker.func_70032_d((Entity)this.target) > (float)this.getAttackRange()) {
                this.worker.isWorkerAtSiteWithMove(this.target.func_180425_c(), this.getAttackRange());
                return AIState.GUARD_ATTACK_PHYSICAL;
            }
            int swordSlot = InventoryUtils.getFirstSlotOfItemHandlerContainingTool((IItemHandler)new InvWrapper((IInventory)this.getInventory()), ToolType.SWORD, 0, ((AbstractBuildingWorker)this.getOwnBuilding()).getMaxToolLevel());
            if (swordSlot != -1) {
                ItemStack heldItem;
                this.worker.getCitizenItemHandler().setHeldItem(EnumHand.MAIN_HAND, swordSlot);
                this.worker.func_70625_a((Entity)this.target, 180.0f, 180.0f);
                this.worker.func_70671_ap().func_75651_a((Entity)this.target, 180.0f, 180.0f);
                this.worker.func_184609_a(EnumHand.MAIN_HAND);
                this.worker.func_184185_a(SoundEvents.field_187730_dW, 1.0f, (float)this.getRandomPitch());
                double damageToBeDealt = 3.0;
                if (this.worker.func_110143_aJ() <= 2.0f) {
                    damageToBeDealt *= 2.0;
                }
                if (ItemStackUtils.doesItemServeAsWeapon(heldItem = this.worker.func_184586_b(EnumHand.MAIN_HAND))) {
                    damageToBeDealt = heldItem.func_77973_b() instanceof ItemSword ? (damageToBeDealt += (double)((ItemSword)heldItem.func_77973_b()).func_150931_i()) : (damageToBeDealt += TinkersWeaponHelper.getDamage(heldItem));
                    damageToBeDealt += (double)EnchantmentHelper.func_152377_a((ItemStack)heldItem, (EnumCreatureAttribute)this.target.func_70668_bt());
                }
                this.target.func_70097_a(new DamageSource(this.worker.func_70005_c_()), (float)damageToBeDealt);
                this.target.func_70604_c((EntityLivingBase)this.worker);
                this.worker.getCitizenItemHandler().damageItemInHand(EnumHand.MAIN_HAND, 1);
            }
        }
        return AIState.GUARD_ATTACK_PHYSICAL;
    }

    protected AIState attackRanged() {
        if (this.worker.func_110144_aD() != null && !this.worker.func_110144_aD().field_70128_L && this.worker.func_70032_d((Entity)this.worker.func_110144_aD()) < (float)this.getAttackRange()) {
            this.target = this.worker.func_110144_aD();
        }
        if (this.target == null || this.target.field_70128_L) {
            this.worker.getCitizenExperienceHandler().addExperience(5.0);
            return AIState.DECIDE;
        }
        if (this.currentAttackDelay != 0) {
            --this.currentAttackDelay;
            return AIState.GUARD_ATTACK_RANGED;
        }
        this.currentAttackDelay = this.getAttackDelay();
        if (this.getOwnBuilding() != null && this.worker.getCitizenData() != null) {
            if (this.worker.func_70032_d((Entity)this.target) > (float)this.getAttackRange()) {
                this.worker.isWorkerAtSiteWithMove(this.target.func_180425_c(), this.getAttackRange());
                return AIState.GUARD_ATTACK_RANGED;
            }
            int bowslot = InventoryUtils.getFirstSlotOfItemHandlerContainingTool((IItemHandler)new InvWrapper((IInventory)this.getInventory()), ToolType.BOW, 0, ((AbstractBuildingWorker)this.getOwnBuilding()).getMaxToolLevel());
            if (bowslot != -1) {
                this.worker.getCitizenItemHandler().setHeldItem(EnumHand.MAIN_HAND, bowslot);
                this.worker.func_70625_a((Entity)this.target, 180.0f, 180.0f);
                this.worker.func_70671_ap().func_75651_a((Entity)this.target, 180.0f, 180.0f);
                this.worker.func_184609_a(EnumHand.MAIN_HAND);
                GuardArrow arrow = new GuardArrow(this.world, this.worker);
                double xVector = this.target.field_70165_t - this.worker.field_70165_t;
                double yVector = this.target.func_174813_aQ().field_72338_b + (double)this.target.field_70131_O / this.getAimHeight() - arrow.field_70163_u;
                double zVector = this.target.field_70161_v - this.worker.field_70161_v;
                double distance = MathHelper.func_76133_a((double)(xVector * xVector + zVector * zVector));
                double damage = this.getRangedAttackDamage();
                double chance = 15.0 / (double)(this.worker.getCitizenData().getLevel() + 1);
                arrow.func_70186_c(xVector, yVector + distance * (double)0.2f, zVector, 1.6f, (float)chance);
                if (this.worker.func_110143_aJ() <= 2.0f) {
                    damage *= 2.0;
                }
                arrow.func_70239_b(damage);
                double xDiff = this.target.field_70165_t - this.worker.field_70165_t;
                double zDiff = this.target.field_70161_v - this.worker.field_70161_v;
                double goToX = xDiff > 0.0 ? 0.01 : -0.01;
                double goToZ = zDiff > 0.0 ? 0.01 : -0.01;
                this.worker.func_70091_d(MoverType.SELF, goToX, 0.0, goToZ);
                this.worker.func_184185_a(SoundEvents.field_187866_fi, 1.0f, (float)this.getRandomPitch());
                this.worker.field_70170_p.func_72838_d((Entity)arrow);
                this.target.func_70604_c((EntityLivingBase)this.worker);
                this.worker.getCitizenItemHandler().damageItemInHand(EnumHand.MAIN_HAND, 1);
            }
        }
        return AIState.GUARD_ATTACK_RANGED;
    }

    protected int getAttackDelay() {
        if (this.worker.getCitizenData() != null) {
            return 20 / (this.worker.getCitizenData().getLevel() + 1);
        }
        return 20;
    }

    protected double getAimHeight() {
        return 3.0;
    }

    protected float getRangedAttackDamage() {
        return 2.0f;
    }

    protected AxisAlignedBB getSearchArea() {
        AbstractBuildingGuards building = (AbstractBuildingGuards)this.getOwnBuilding();
        if (building != null) {
            double x1 = this.worker.field_70165_t + (double)(building.getBonusVision() + 10);
            double x2 = this.worker.field_70165_t - (double)(building.getBonusVision() + 10);
            double y1 = this.worker.field_70163_u + 10.0;
            double y2 = this.worker.field_70163_u - 10.0;
            double z1 = this.worker.field_70161_v + (double)(building.getBonusVision() + 10);
            double z2 = this.worker.field_70161_v - (double)(building.getBonusVision() + 10);
            return new AxisAlignedBB(x1, y1, z1, x2, y2, z2);
        }
        return ((AbstractSchematicProvider)this.getOwnBuilding()).getTargetableArea(this.world);
    }

    protected void updateArmor() {
        this.worker.func_184201_a(EntityEquipmentSlot.CHEST, ItemStackUtils.EMPTY);
        this.worker.func_184201_a(EntityEquipmentSlot.FEET, ItemStackUtils.EMPTY);
        this.worker.func_184201_a(EntityEquipmentSlot.HEAD, ItemStackUtils.EMPTY);
        this.worker.func_184201_a(EntityEquipmentSlot.LEGS, ItemStackUtils.EMPTY);
        for (int i = 0; i < new InvWrapper((IInventory)this.worker.getInventoryCitizen()).getSlots(); ++i) {
            ItemStack stack = this.worker.getInventoryCitizen().func_70301_a(i);
            if (ItemStackUtils.isEmpty(stack).booleanValue()) {
                new InvWrapper((IInventory)this.worker.getInventoryCitizen()).extractItem(i, Integer.MAX_VALUE, false);
                continue;
            }
            if (!(stack.func_77973_b() instanceof ItemArmor) || this.worker.func_184582_a(((ItemArmor)stack.func_77973_b()).field_77881_a) != ItemStackUtils.EMPTY) continue;
            this.worker.func_184201_a(((ItemArmor)stack.func_77973_b()).field_77881_a, stack);
        }
    }

    private double getRandomPitch() {
        return 1.0 / (this.worker.func_70681_au().nextDouble() * 0.4 + 0.8);
    }
}

