/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.cook;

import com.minecolonies.api.colony.requestsystem.requestable.Food;
import com.minecolonies.api.colony.requestsystem.requestable.IRequestable;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.coremod.colony.buildings.AbstractSchematicProvider;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingCook;
import com.minecolonies.coremod.colony.jobs.JobCook;
import com.minecolonies.coremod.entity.EntityCitizen;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAIUsesFurnace;
import com.minecolonies.coremod.entity.ai.util.AIState;
import com.minecolonies.coremod.entity.ai.util.AITarget;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class EntityAIWorkCook
extends AbstractEntityAIUsesFurnace<JobCook> {
    private static final int CHARISMA_MULTIPLIER = 2;
    private static final int INTELLIGENCE_MULTIPLIER = 1;
    private static final int AMOUNT_OF_FOOD_TO_SERVE = 3;
    private static final int SERVE_DELAY = 30;
    private final List<EntityCitizen> citizenToServe = new ArrayList<EntityCitizen>();
    private AxisAlignedBB range = null;

    public EntityAIWorkCook(@NotNull JobCook job) {
        super(job);
        super.registerTargets(new AITarget(AIState.COOK_SERVE_FOOD_TO_CITIZEN, this::serveFoodToCitizen));
        this.worker.getCitizenExperienceHandler().setSkillModifier(2 * this.worker.getCitizenData().getCharisma() + 1 * this.worker.getCitizenData().getIntelligence());
        this.worker.func_98053_h(true);
    }

    @Override
    public Class getExpectedBuildingClass() {
        return BuildingCook.class;
    }

    @Override
    protected void extractFromFurnace(TileEntityFurnace furnace) {
        InventoryUtils.transferItemStackIntoNextFreeSlotInItemHandlers((IItemHandler)new InvWrapper((IInventory)furnace), 2, (IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()));
    }

    @Override
    protected boolean isSmeltable(ItemStack stack) {
        return ItemStackUtils.ISCOOKABLE.test(stack);
    }

    private AIState serveFoodToCitizen() {
        this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TextComponentTranslation("com.minecolonies.coremod.status.serving", new Object[0])});
        if (this.citizenToServe.isEmpty()) {
            return AIState.START_WORKING;
        }
        if (this.walkToBlock(this.citizenToServe.get(0).func_180425_c())) {
            this.setDelay(2);
            return this.getState();
        }
        if (InventoryUtils.isItemHandlerFull((IItemHandler)new InvWrapper((IInventory)this.citizenToServe.get(0).getInventoryCitizen()))) {
            this.chatSpamFilter.talkWithoutSpam("com.minecolonies.coremod.cook.full", new Object[0]);
            this.citizenToServe.remove(0);
            this.setDelay(30);
            return this.getState();
        }
        InventoryUtils.transferXOfFirstSlotInItemHandlerWithIntoNextFreeSlotInItemHandler((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()), ItemStackUtils.ISFOOD, 3, (IItemHandler)new InvWrapper((IInventory)this.citizenToServe.get(0).getInventoryCitizen()));
        this.citizenToServe.remove(0);
        this.setDelay(30);
        return this.getState();
    }

    @Override
    protected AIState checkForImportantJobs() {
        if (this.range == null) {
            this.range = ((AbstractSchematicProvider)this.getOwnBuilding()).getTargetableArea(this.world);
        }
        this.citizenToServe.clear();
        List citizenList = this.world.func_175647_a(EntityCitizen.class, this.range, cit -> !(cit.getCitizenJobHandler().getColonyJob() instanceof JobCook) && cit.getCitizenData() != null && cit.getCitizenData().getSaturation() <= 0.0);
        if (!citizenList.isEmpty()) {
            this.citizenToServe.addAll(citizenList);
            if (InventoryUtils.hasItemInItemHandler((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()), ItemStackUtils.ISFOOD)) {
                return AIState.COOK_SERVE_FOOD_TO_CITIZEN;
            }
            this.needsCurrently = ItemStackUtils.ISFOOD;
            return AIState.GATHERING_REQUIRED_MATERIALS;
        }
        return AIState.START_WORKING;
    }

    @Override
    protected IRequestable getSmeltAbleClass() {
        return new Food(64);
    }
}

