/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.builder;

import com.minecolonies.api.util.BlockUtils;
import com.minecolonies.api.util.EntityUtils;
import com.minecolonies.coremod.blocks.ModBlocks;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingStructureBuilder;
import com.minecolonies.coremod.colony.buildings.AbstractCitizenAssignable;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingBuilder;
import com.minecolonies.coremod.colony.jobs.JobBuilder;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuild;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuildDecoration;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuildRemoval;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAIStructureWithWorkOrder;
import com.minecolonies.coremod.entity.ai.util.AIState;
import com.minecolonies.coremod.entity.ai.util.AITarget;
import com.minecolonies.coremod.util.StructureWrapper;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

public class EntityAIStructureBuilder
extends AbstractEntityAIStructureWithWorkOrder<JobBuilder> {
    private static final int INTELLIGENCE_MULTIPLIER = 2;
    private static final int STRENGTH_MULTIPLIER = 1;
    private static final int DEPTH_LEVEL_1 = 30;
    private static final int DEPTH_LEVEL_2 = 15;
    private static final int SPEED_BUFF_1 = 2;
    private static final int SPEED_BUFF_2 = 4;
    private static final int STAND_OFFSET = 3;
    private static final int BASE_Y_HEIGHT = 70;
    private static final int ACTIONS_UNTIL_DUMP = 1024;

    public EntityAIStructureBuilder(@NotNull JobBuilder job) {
        super(job);
        super.registerTargets(new AITarget(AIState.IDLE, AIState.START_WORKING), new AITarget(this::checkIfExecute, this::getState), new AITarget(AIState.START_WORKING, this::startWorkingAtOwnBuilding));
        this.worker.getCitizenExperienceHandler().setSkillModifier(2 * this.worker.getCitizenData().getIntelligence() + 1 * this.worker.getCitizenData().getStrength());
        this.worker.func_98053_h(true);
    }

    @Override
    public Class getExpectedBuildingClass() {
        return BuildingBuilder.class;
    }

    private boolean checkIfExecute() {
        this.setDelay(1);
        if (!((JobBuilder)this.job).hasWorkOrder()) {
            this.getOwnBuilding(AbstractBuildingStructureBuilder.class).searchWorkOrder();
            return true;
        }
        WorkOrderBuildDecoration wo = ((JobBuilder)this.job).getWorkOrder();
        if (wo == null) {
            ((JobBuilder)this.job).setWorkOrder(null);
            return true;
        }
        AbstractBuilding building = ((JobBuilder)this.job).getColony().getBuildingManager().getBuilding(wo.getBuildingLocation());
        if (building == null && wo instanceof WorkOrderBuild && !(wo instanceof WorkOrderBuildRemoval)) {
            ((JobBuilder)this.job).complete();
            return true;
        }
        if (!((JobBuilder)this.job).hasStructure()) {
            super.initiate();
        }
        return false;
    }

    @Override
    public AIState switchStage(AIState state) {
        if (((JobBuilder)this.job).getWorkOrder() instanceof WorkOrderBuildRemoval && state.equals((Object)AIState.BUILDING_STEP)) {
            return AIState.COMPLETE_BUILD;
        }
        return super.switchStage(state);
    }

    private AIState startWorkingAtOwnBuilding() {
        if (this.walkToBuilding()) {
            return this.getState();
        }
        return AIState.START_BUILDING;
    }

    @Override
    public BlockPos getWorkingPosition(BlockPos targetPosition) {
        BlockPos[] edges;
        StructureWrapper wrapper = ((JobBuilder)this.job).getStructure();
        int x1 = wrapper.getPosition().func_177958_n() - wrapper.getOffset().func_177958_n() - 3;
        int z1 = wrapper.getPosition().func_177952_p() - wrapper.getOffset().func_177952_p() - 3;
        int x3 = wrapper.getPosition().func_177958_n() + (wrapper.getWidth() - wrapper.getOffset().func_177958_n()) + 3;
        int z3 = wrapper.getPosition().func_177952_p() + (wrapper.getLength() - wrapper.getOffset().func_177952_p() + 3);
        for (BlockPos pos : edges = new BlockPos[]{new BlockPos(x1, 70, z1), new BlockPos(x3, 70, z1), new BlockPos(x1, 70, z3), new BlockPos(x3, 70, z3)}) {
            BlockPos basePos = this.world.func_175672_r(pos);
            if (!EntityUtils.checkForFreeSpace(this.world, basePos.func_177977_b()) || this.world.func_180495_p(basePos).func_177230_c() == Blocks.field_150345_g || !this.world.func_180495_p(basePos.func_177977_b()).func_185904_a().func_76220_a()) continue;
            return basePos;
        }
        return targetPosition;
    }

    @Override
    public void connectBlockToBuildingIfNecessary(@NotNull IBlockState blockState, @NotNull BlockPos pos) {
        BlockPos buildingLocation = ((JobBuilder)this.job).getWorkOrder().getBuildingLocation();
        AbstractBuilding building = ((AbstractCitizenAssignable)this.getOwnBuilding()).getColony().getBuildingManager().getBuilding(buildingLocation);
        if (building != null) {
            building.registerBlockPosition(blockState, pos, this.world);
        }
        if (blockState.func_177230_c() == ModBlocks.blockWayPoint) {
            this.worker.getCitizenColonyHandler().getColony().addWayPoint(pos, this.world.func_180495_p(pos));
        }
    }

    @Override
    public boolean shallReplaceSolidSubstitutionBlock(Block worldBlock, IBlockState worldMetadata) {
        return false;
    }

    @Override
    public IBlockState getSolidSubstitution(@NotNull BlockPos location) {
        return BlockUtils.getSubstitutionBlockAtWorld(this.world, location);
    }

    @Override
    public int getBlockMiningDelay(@NotNull Block block, @NotNull BlockPos pos) {
        int initialDelay = super.getBlockMiningDelay(block, pos);
        if (pos.func_177956_o() > 30) {
            return initialDelay;
        }
        if (pos.func_177956_o() < 15) {
            return initialDelay * 4;
        }
        return initialDelay * 2;
    }

    @Override
    protected int getActionsDoneUntilDumping() {
        return 1024;
    }
}

