/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.builder;

import com.minecolonies.api.configuration.Configurations;
import com.minecolonies.coremod.blocks.ModBlocks;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuildDecoration;
import com.minecolonies.coremod.util.ColonyUtils;
import com.minecolonies.coremod.util.StructureWrapper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import org.jetbrains.annotations.NotNull;

public final class ConstructionTapeHelper {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    public static final int MINHEIGHT = 1;
    public static final int MAXHEIGHT = 256;

    private ConstructionTapeHelper() {
    }

    public static void placeConstructionTape(@NotNull WorkOrderBuildDecoration workOrder, @NotNull World world) {
        Tuple<Tuple<Integer, Integer>, Tuple<Integer, Integer>> corners = ColonyUtils.calculateCorners(workOrder.getBuildingLocation(), world, new StructureWrapper(world, workOrder.getStructureName()), workOrder.getRotation(world), workOrder.isMirrored());
        ConstructionTapeHelper.placeConstructionTape(workOrder.getBuildingLocation(), corners, world);
    }

    public static void placeConstructionTape(BlockPos pos, Tuple<Tuple<Integer, Integer>, Tuple<Integer, Integer>> corners, @NotNull World world) {
        if (Configurations.gameplay.builderPlaceConstructionTape) {
            BlockPos row4;
            BlockPos row3;
            BlockPos row2;
            BlockPos row1;
            int newY;
            int i;
            IBlockState constructionTape = ModBlocks.blockConstructionTape.func_176223_P();
            int x1 = (Integer)((Tuple)corners.func_76341_a()).func_76341_a();
            int x3 = (Integer)((Tuple)corners.func_76341_a()).func_76340_b();
            int z1 = (Integer)((Tuple)corners.func_76340_b()).func_76341_a();
            int z3 = (Integer)((Tuple)corners.func_76340_b()).func_76340_b();
            int y = pos.func_177956_o();
            if (x1 < x3) {
                for (i = x1 + 1; i < x3; ++i) {
                    newY = ConstructionTapeHelper.checkIfPlaceable(i, y, z1, world);
                    row1 = new BlockPos(i, newY, z1);
                    world.func_175656_a(row1, constructionTape.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.SOUTH));
                    newY = ConstructionTapeHelper.checkIfPlaceable(i, y, z3, world);
                    row2 = new BlockPos(i, newY, z3);
                    world.func_175656_a(row2, constructionTape.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
                }
            } else {
                for (i = x3 + 1; i < x1; ++i) {
                    newY = ConstructionTapeHelper.checkIfPlaceable(i, y, z1, world);
                    row1 = new BlockPos(i, newY, z1);
                    world.func_175656_a(row1, constructionTape.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.SOUTH));
                    newY = ConstructionTapeHelper.checkIfPlaceable(i, y, z3, world);
                    row2 = new BlockPos(i, newY, z3);
                    world.func_175656_a(row2, constructionTape.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
                }
            }
            if (z1 < z3) {
                for (i = z1 + 1; i < z3; ++i) {
                    newY = ConstructionTapeHelper.checkIfPlaceable(x1, y, i, world);
                    row3 = new BlockPos(x1, newY, i);
                    world.func_175656_a(row3, constructionTape.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.EAST));
                    newY = ConstructionTapeHelper.checkIfPlaceable(x3, y, i, world);
                    row4 = new BlockPos(x3, newY, i);
                    world.func_175656_a(row4, constructionTape.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.WEST));
                }
            } else {
                for (i = z3 + 1; i < z1; ++i) {
                    newY = ConstructionTapeHelper.checkIfPlaceable(x1, y, i, world);
                    row3 = new BlockPos(x1, newY, i);
                    world.func_175656_a(row3, constructionTape.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.EAST));
                    newY = ConstructionTapeHelper.checkIfPlaceable(x3, y, i, world);
                    row4 = new BlockPos(x3, newY, i);
                    world.func_175656_a(row4, constructionTape.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.WEST));
                }
            }
            newY = ConstructionTapeHelper.checkIfPlaceable(x1, y, z1, world);
            BlockPos corner1 = new BlockPos(x1, newY, z1);
            newY = ConstructionTapeHelper.checkIfPlaceable(x1, y, z3, world);
            BlockPos corner2 = new BlockPos(x1, newY, z3);
            newY = ConstructionTapeHelper.checkIfPlaceable(x3, y, z1, world);
            BlockPos corner3 = new BlockPos(x3, newY, z1);
            newY = ConstructionTapeHelper.checkIfPlaceable(x3, y, z3, world);
            BlockPos corner4 = new BlockPos(x3, newY, z3);
            world.func_175656_a(corner1, constructionTape.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.SOUTH));
            world.func_175656_a(corner2, constructionTape.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.EAST));
            world.func_175656_a(corner3, constructionTape.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.WEST));
            world.func_175656_a(corner4, constructionTape.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        }
    }

    public static int checkIfPlaceable(@NotNull int x, @NotNull int y, @NotNull int z, @NotNull World world) {
        BlockPos target = new BlockPos(x, y, z);
        Chunk chunk = world.func_175726_f(target);
        target = new BlockPos(x, chunk.func_76625_h() + 16, z);
        while (world.func_180495_p(target).func_185904_a().func_76222_j() && (target = target.func_177977_b()).func_177956_o() != 0) {
        }
        return target.func_177956_o() + 1;
    }

    public static void removeConstructionTape(@NotNull WorkOrderBuildDecoration workOrder, @NotNull World world) {
        Tuple<Tuple<Integer, Integer>, Tuple<Integer, Integer>> corners = ColonyUtils.calculateCorners(workOrder.getBuildingLocation(), world, new StructureWrapper(world, workOrder.getStructureName()), workOrder.getRotation(world), workOrder.isMirrored());
        ConstructionTapeHelper.removeConstructionTape(corners, world);
    }

    public static void removeConstructionTape(Tuple<Tuple<Integer, Integer>, Tuple<Integer, Integer>> corners, @NotNull World world) {
        BlockPos block2;
        BlockPos block1;
        int i;
        int x1 = (Integer)((Tuple)corners.func_76341_a()).func_76341_a();
        int x3 = (Integer)((Tuple)corners.func_76341_a()).func_76340_b();
        int z1 = (Integer)((Tuple)corners.func_76340_b()).func_76341_a();
        int z3 = (Integer)((Tuple)corners.func_76340_b()).func_76340_b();
        if (x1 < x3) {
            for (i = x1; i <= x3; ++i) {
                block1 = new BlockPos(i, 0, z1);
                block2 = new BlockPos(i, 0, z3);
                ConstructionTapeHelper.removeTapeIfNecessary(world, block1, ModBlocks.blockConstructionTape);
                ConstructionTapeHelper.removeTapeIfNecessary(world, block2, ModBlocks.blockConstructionTape);
            }
        } else {
            for (i = x3; i <= x1; ++i) {
                block1 = new BlockPos(i, 0, z1);
                block2 = new BlockPos(i, 0, z3);
                ConstructionTapeHelper.removeTapeIfNecessary(world, block1, ModBlocks.blockConstructionTape);
                ConstructionTapeHelper.removeTapeIfNecessary(world, block2, ModBlocks.blockConstructionTape);
            }
        }
        if (z1 < z3) {
            for (i = z1; i <= z3; ++i) {
                block1 = new BlockPos(x1, 0, i);
                block2 = new BlockPos(x3, 0, i);
                ConstructionTapeHelper.removeTapeIfNecessary(world, block1, ModBlocks.blockConstructionTape);
                ConstructionTapeHelper.removeTapeIfNecessary(world, block2, ModBlocks.blockConstructionTape);
            }
        } else {
            for (i = z3; i <= z1; ++i) {
                block1 = new BlockPos(x1, 0, i);
                block2 = new BlockPos(x3, 0, i);
                ConstructionTapeHelper.removeTapeIfNecessary(world, block1, ModBlocks.blockConstructionTape);
                ConstructionTapeHelper.removeTapeIfNecessary(world, block2, ModBlocks.blockConstructionTape);
            }
        }
        BlockPos corner1 = new BlockPos(x1, 0, z1);
        BlockPos corner2 = new BlockPos(x1, 0, z3);
        BlockPos corner3 = new BlockPos(x3, 0, z1);
        BlockPos corner4 = new BlockPos(x3, 0, z3);
        ConstructionTapeHelper.removeTapeIfNecessary(world, corner1, ModBlocks.blockConstructionTape);
        ConstructionTapeHelper.removeTapeIfNecessary(world, corner2, ModBlocks.blockConstructionTape);
        ConstructionTapeHelper.removeTapeIfNecessary(world, corner3, ModBlocks.blockConstructionTape);
        ConstructionTapeHelper.removeTapeIfNecessary(world, corner4, ModBlocks.blockConstructionTape);
    }

    public static void removeTapeIfNecessary(@NotNull World world, @NotNull BlockPos block, @NotNull Block tapeOrTapeCorner) {
        for (int y = 1; y <= 256; ++y) {
            BlockPos newBlock = new BlockPos(block.func_177958_n(), y, block.func_177952_p());
            if (world.func_180495_p(newBlock).func_177230_c() != tapeOrTapeCorner) continue;
            world.func_175656_a(newBlock, Blocks.field_150350_a.func_176223_P());
            break;
        }
    }
}

