/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.basic;

import com.minecolonies.api.compatibility.candb.ChiselAndBitsCheck;
import com.minecolonies.api.configuration.Configurations;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.BlockUtils;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.MathUtils;
import com.minecolonies.api.util.Utils;
import com.minecolonies.coremod.blocks.ModBlocks;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingStructureBuilder;
import com.minecolonies.coremod.colony.jobs.AbstractJob;
import com.minecolonies.coremod.colony.jobs.AbstractJobStructure;
import com.minecolonies.coremod.entity.EntityCitizen;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAIInteract;
import com.minecolonies.coremod.entity.ai.util.AIState;
import com.minecolonies.coremod.entity.ai.util.AITarget;
import com.minecolonies.coremod.entity.ai.util.Structure;
import com.minecolonies.coremod.placementhandlers.IPlacementHandler;
import com.minecolonies.coremod.placementhandlers.PlacementHandlers;
import com.minecolonies.coremod.util.StructureWrapper;
import com.minecolonies.coremod.util.WorkerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Mirror;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractEntityAIStructure<J extends AbstractJob>
extends AbstractEntityAIInteract<J> {
    public static final String WAYPOINT_STRING = "infrastructure";
    private static final double XP_EACH_BUILDING = 10.0;
    private static final double XP_EACH_BLOCK = 0.1;
    private static final int PROGRESS_MULTIPLIER = 10;
    private static final double RUN_AWAY_SPEED = 4.1;
    private static final int MIN_ADDITIONAL_RANGE_TO_BUILD = 3;
    private static final int UNLIMITED_RESOURCES_TIMEOUT = 5;
    private static final int STANDARD_WORKING_RANGE = 5;
    private static final int MIN_WORKING_RANGE = 12;
    private Structure currentStructure;
    private BlockPos workFrom;
    private int rotation = 0;

    protected AbstractEntityAIStructure(@NotNull J job) {
        super(job);
        this.registerTargets(new AITarget(AIState.PICK_UP_RESIDUALS, this::pickUpResiduals), new AITarget(this::checkIfCanceled, AIState.IDLE), new AITarget(AIState.START_BUILDING, this::startBuilding), new AITarget(AIState.IDLE, this::isThereAStructureToBuild, () -> AIState.START_BUILDING), new AITarget(AIState.REMOVE_STEP, this.generateStructureGenerator(this::clearStep, AIState.COMPLETE_BUILD)), new AITarget(AIState.CLEAR_STEP, this.generateStructureGenerator(this::clearStep, AIState.BUILDING_STEP)), new AITarget(AIState.BUILDING_STEP, this.generateStructureGenerator(this::structureStep, AIState.SPAWN_STEP)), new AITarget(AIState.SPAWN_STEP, this.generateStructureGenerator(this::spawnEntity, AIState.DECORATION_STEP)), new AITarget(AIState.DECORATION_STEP, this.generateStructureGenerator(this::decorationStep, AIState.COMPLETE_BUILD)), new AITarget(AIState.COMPLETE_BUILD, this::completeBuild));
    }

    @Override
    public Class getExpectedBuildingClass() {
        return AbstractBuildingStructureBuilder.class;
    }

    private Supplier<AIState> generateStructureGenerator(@NotNull Function<Structure.StructureBlock, Boolean> evaluationFunction, @NotNull AIState nextState) {
        Supplier<Structure.StructureBlock> getCurrentBlock = () -> this.currentStructure.getCurrentBlock();
        Supplier<Structure.Result> advanceBlock = () -> this.currentStructure.advanceBlock();
        return () -> {
            Structure.StructureBlock currentBlock = (Structure.StructureBlock)getCurrentBlock.get();
            if (currentBlock.block == null || ((Boolean)evaluationFunction.apply(currentBlock)).booleanValue()) {
                Structure.Result result = (Structure.Result)((Object)((Object)advanceBlock.get()));
                if (result == Structure.Result.AT_END) {
                    return this.switchStage(nextState);
                }
                if (result == Structure.Result.CONFIG_LIMIT) {
                    return this.getState();
                }
            }
            return this.getState();
        };
    }

    public AIState switchStage(AIState state) {
        if (state.equals((Object)AIState.REMOVE_STEP)) {
            this.currentStructure.setStage(Structure.Stage.REMOVE);
        } else if (state.equals((Object)AIState.BUILDING_STEP)) {
            this.currentStructure.setStage(Structure.Stage.BUILD);
        } else if (state.equals((Object)AIState.DECORATION_STEP)) {
            this.currentStructure.setStage(Structure.Stage.DECORATE);
        } else if (state.equals((Object)AIState.SPAWN_STEP)) {
            this.currentStructure.setStage(Structure.Stage.SPAWN);
        } else if (state.equals((Object)AIState.COMPLETE_BUILD)) {
            this.currentStructure.setStage(Structure.Stage.COMPLETE);
        }
        return state;
    }

    private AIState pickUpResiduals() {
        if (this.getItemsForPickUp() == null) {
            this.fillItemsList();
        }
        if (this.getItemsForPickUp() != null && !this.getItemsForPickUp().isEmpty()) {
            this.gatherItems();
            return this.getState();
        }
        this.resetGatheringItems();
        this.workFrom = null;
        this.currentStructure = null;
        return AIState.IDLE;
    }

    @Override
    public void fillItemsList() {
        this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TextComponentTranslation("com.minecolonies.coremod.status.gathering", new Object[0])});
        if (this.currentStructure == null) {
            return;
        }
        BlockPos centerPos = this.currentStructure.getCenter();
        if (centerPos.func_177956_o() == 0) {
            return;
        }
        this.searchForItems(new AxisAlignedBB(centerPos).func_72321_a((double)this.currentStructure.getLength() / 2.0, (double)this.currentStructure.getHeight(), (double)this.currentStructure.getWidth()));
    }

    private AIState completeBuild() {
        this.incrementActionsDoneAndDecSaturation();
        if (this.job instanceof AbstractJobStructure) {
            this.executeSpecificCompleteActions();
            this.worker.getCitizenExperienceHandler().addExperience(10.0);
        }
        return AIState.PICK_UP_RESIDUALS;
    }

    protected abstract void executeSpecificCompleteActions();

    private Boolean decorationStep(Structure.StructureBlock structureBlock) {
        if (!BlockUtils.shouldNeverBeMessedWith(structureBlock.worldBlock)) {
            this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TextComponentTranslation("com.minecolonies.coremod.status.decorating", new Object[0])});
            if (!this.walkToConstructionSite()) {
                return false;
            }
            if (structureBlock.block == null || structureBlock.doesStructureBlockEqualWorldBlock() || structureBlock.metadata.func_185904_a().func_76220_a()) {
                return true;
            }
            WorkerUtil.faceBlock(structureBlock.blockPosition, this.worker);
            Block block = structureBlock.block;
            if (block == null) {
                BlockPos local = structureBlock.blockPosition;
                Log.getLogger().error(String.format("StructureProxy has null block at %s - local(%s)", this.currentStructure.getCurrentBlockPosition(), local));
                return true;
            }
            IBlockState blockState = structureBlock.metadata;
            return this.placeBlockAt(blockState, structureBlock.blockPosition);
        }
        return true;
    }

    public boolean walkToConstructionSite() {
        if (this.workFrom == null) {
            this.workFrom = this.getWorkingPosition(this.currentStructure.getCurrentBlockPosition());
        }
        return this.worker.isWorkerAtSiteWithMove(this.workFrom, 5) || MathUtils.twoDimDistance(this.worker.func_180425_c(), this.workFrom) < 12.0;
    }

    private boolean placeBlockAt(@NotNull IBlockState blockState, @NotNull BlockPos coords) {
        ItemStack item = BlockUtils.getItemStackFromBlockState(blockState);
        this.worker.func_184201_a(EntityEquipmentSlot.MAINHAND, item == null ? ItemStackUtils.EMPTY : item);
        for (IPlacementHandler handlers : PlacementHandlers.handlers) {
            Object result = handlers.handle(this.world, coords, blockState, this, Configurations.gameplay.builderInfiniteResources, false);
            if (result instanceof IPlacementHandler.ActionProcessingResult) {
                if (result == IPlacementHandler.ActionProcessingResult.ACCEPT) {
                    return true;
                }
                if (result != IPlacementHandler.ActionProcessingResult.DENY) continue;
                return false;
            }
            if (!(result instanceof IBlockState)) continue;
            IBlockState decrease = (IBlockState)result;
            this.decreaseInventory(coords, decrease.func_177230_c(), decrease);
            this.connectBlockToBuildingIfNecessary(decrease, coords);
            this.worker.func_184609_a(this.worker.func_184600_cs());
            this.worker.getCitizenExperienceHandler().addExperience(0.1);
            return true;
        }
        Log.getLogger().warn("Couldn't handle block: " + blockState.func_177230_c().func_149739_a());
        return true;
    }

    @Override
    public BlockPos getWorkingPosition(BlockPos targetPosition) {
        int length = this.currentStructure.getLength();
        int width = this.currentStructure.getWidth();
        int distance = Math.max(width, length) + 3;
        return this.getWorkingPosition(distance, targetPosition, 0);
    }

    private boolean decreaseInventory(@NotNull BlockPos pos, Block block, @NotNull IBlockState state) {
        Block blockToPlace;
        IBlockState stateToPlace = state;
        if (MathHelper.func_76128_c((double)this.worker.field_70165_t) == pos.func_177958_n() && MathHelper.func_76130_a((int)(pos.func_177956_o() - (int)this.worker.field_70163_u)) <= 1 && MathHelper.func_76128_c((double)this.worker.field_70161_v) == pos.func_177952_p() && this.worker.getNavigator().func_75500_f()) {
            this.worker.getNavigator().moveAwayFromXYZ(pos, 4.1, 1.0);
        }
        if (AbstractEntityAIStructure.isBlockFree(blockToPlace = block, blockToPlace.func_176201_c(stateToPlace))) {
            return true;
        }
        ItemStack stack = BlockUtils.getItemStackFromBlockState(stateToPlace);
        if (ItemStackUtils.isEmpty(stack).booleanValue()) {
            Log.getLogger().error("Block causes NPE: " + stateToPlace.func_177230_c());
            return false;
        }
        ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
        if (!ChiselAndBitsCheck.isChiselAndBitsBlock(stateToPlace)) {
            itemList.add(stack);
        }
        itemList.addAll(this.getItemsFromTileEntity());
        for (ItemStack tempStack : itemList) {
            int slot;
            if (ItemStackUtils.isEmpty(tempStack).booleanValue() || (slot = this.worker.getCitizenInventoryHandler().findFirstSlotInInventoryWith(tempStack.func_77973_b(), tempStack.func_77952_i())) == -1) continue;
            ItemStack container = tempStack.func_77973_b().getContainerItem(tempStack);
            new InvWrapper((IInventory)this.getInventory()).extractItem(slot, 1, false);
            if (!ItemStackUtils.isEmpty(container).booleanValue()) {
                new InvWrapper((IInventory)this.getInventory()).insertItem(slot, container, false);
            }
            this.reduceNeededResources(tempStack);
        }
        if (Configurations.gameplay.builderBuildBlockDelay > 0 && blockToPlace != Blocks.field_150350_a) {
            this.setDelay(Configurations.gameplay.builderBuildBlockDelay * 10 / (this.worker.getCitizenExperienceHandler().getLevel() + 10));
        }
        return true;
    }

    public void connectBlockToBuildingIfNecessary(@NotNull IBlockState blockState, @NotNull BlockPos pos) {
    }

    public static boolean isBlockFree(@Nullable Block block, int metadata) {
        return block == null || BlockUtils.isWater(block.func_176223_P()) || block.equals(Blocks.field_150362_t) || block.equals(Blocks.field_150361_u) || block.equals(Blocks.field_150398_cm) && Utils.testFlag(metadata, 8);
    }

    public List<ItemStack> getItemsFromTileEntity() {
        return Collections.emptyList();
    }

    public void reduceNeededResources(ItemStack stack) {
    }

    private Boolean structureStep(Structure.StructureBlock structureBlock) {
        if (!BlockUtils.shouldNeverBeMessedWith(structureBlock.worldBlock)) {
            this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TextComponentTranslation("com.minecolonies.coremod.status.building", new Object[0])});
            if (!this.walkToConstructionSite()) {
                return false;
            }
            if (structureBlock.block == null || !structureBlock.metadata.func_185904_a().func_76220_a() && structureBlock.block != Blocks.field_150350_a) {
                return true;
            }
            if (structureBlock.doesStructureBlockEqualWorldBlock()) {
                this.connectBlockToBuildingIfNecessary(structureBlock.metadata, structureBlock.blockPosition);
                return true;
            }
            Block block = structureBlock.block;
            IBlockState blockState = structureBlock.metadata;
            if (block == ModBlocks.blockSolidSubstitution || this.shallReplaceSolidSubstitutionBlock(structureBlock.worldBlock, structureBlock.worldMetadata)) {
                blockState = this.getSolidSubstitution(structureBlock.blockPosition);
                block = blockState.func_177230_c();
            }
            WorkerUtil.faceBlock(structureBlock.blockPosition, this.worker);
            if (block == null) {
                BlockPos local = structureBlock.blockPosition;
                Log.getLogger().error(String.format("StructureProxy has null block at %s - local(%s)", this.currentStructure.getCurrentBlockPosition(), local));
                return true;
            }
            return this.placeBlockAt(blockState, structureBlock.blockPosition);
        }
        return true;
    }

    public abstract boolean shallReplaceSolidSubstitutionBlock(Block var1, IBlockState var2);

    public abstract IBlockState getSolidSubstitution(BlockPos var1);

    public void loadStructure(@NotNull String name, int rotateTimes, BlockPos position, boolean isMirrored, boolean removal) {
        if (this.job instanceof AbstractJobStructure) {
            this.rotation = rotateTimes;
            try {
                StructureWrapper wrapper = new StructureWrapper(this.world, name);
                ((AbstractJobStructure)this.job).setStructure(wrapper);
                this.currentStructure = new Structure(this.world, wrapper, removal ? Structure.Stage.REMOVE : Structure.Stage.CLEAR);
            }
            catch (IllegalStateException e) {
                Log.getLogger().warn(String.format("StructureProxy: (%s) does not exist - removing build request", name), (Throwable)e);
                ((AbstractJobStructure)this.job).setStructure(null);
            }
            try {
                ((AbstractJobStructure)this.job).getStructure().rotate(rotateTimes, this.world, position, isMirrored ? Mirror.FRONT_BACK : Mirror.NONE);
                ((AbstractJobStructure)this.job).getStructure().setPosition(position);
            }
            catch (NullPointerException ex) {
                this.handleSpecificCancelActions();
                ((AbstractJobStructure)this.job).setStructure(null);
                Log.getLogger().warn("Structure couldn't be found which caused an NPE, removed workOrder, more details in log", (Throwable)ex);
            }
        }
    }

    public void handleSpecificCancelActions() {
    }

    protected abstract boolean checkIfCanceled();

    private boolean clearStep(@NotNull Structure.StructureBlock currentBlock) {
        if (this.isAlreadyCleared() || !this.currentStructure.getStage().equals((Object)Structure.Stage.CLEAR) && !this.currentStructure.getStage().equals((Object)Structure.Stage.REMOVE)) {
            return true;
        }
        this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TextComponentTranslation("com.minecolonies.coremod.status.clearing", new Object[0])});
        if (!BlockUtils.shouldNeverBeMessedWith(currentBlock.worldBlock)) {
            if (!this.walkToConstructionSite()) {
                return false;
            }
            WorkerUtil.faceBlock(currentBlock.blockPosition, this.worker);
            if (Configurations.gameplay.builderInfiniteResources || currentBlock.worldMetadata.func_185904_a().func_76224_d()) {
                this.worker.func_184201_a(EntityEquipmentSlot.MAINHAND, ItemStackUtils.EMPTY);
                this.world.func_175698_g(currentBlock.blockPosition);
                this.world.func_175656_a(currentBlock.blockPosition, Blocks.field_150350_a.func_176223_P());
                this.worker.func_184609_a(this.worker.func_184600_cs());
                this.setDelay(50 / (this.worker.getCitizenExperienceHandler().getLevel() + 10));
            } else if (!this.mineBlock(currentBlock.blockPosition, this.getCurrentWorkingPosition())) {
                return false;
            }
        }
        return true;
    }

    protected boolean isAlreadyCleared() {
        return false;
    }

    private BlockPos getCurrentWorkingPosition() {
        return this.workFrom == null ? this.getWorkingPosition(this.currentStructure.getCurrentBlockPosition()) : this.workFrom;
    }

    protected boolean isThereAStructureToBuild() {
        if (this.currentStructure == null) {
            this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TextComponentTranslation("com.minecolonies.coremod.status.waitingForBuild", new Object[0])});
        }
        return this.currentStructure != null;
    }

    @NotNull
    private AIState startBuilding() {
        if (this.currentStructure == null) {
            this.onStartWithoutStructure();
            return AIState.IDLE;
        }
        switch (this.currentStructure.getStage()) {
            case REMOVE: {
                return AIState.REMOVE_STEP;
            }
            case CLEAR: {
                return AIState.CLEAR_STEP;
            }
            case BUILD: {
                return AIState.BUILDING_STEP;
            }
            case DECORATE: {
                return AIState.DECORATION_STEP;
            }
            case SPAWN: {
                return AIState.SPAWN_STEP;
            }
        }
        return AIState.COMPLETE_BUILD;
    }

    protected abstract void onStartWithoutStructure();

    public Template.EntityInfo getEntityInfo() {
        return null;
    }

    @Nullable
    public ItemStack getTotalAmount(@Nullable ItemStack stack) {
        return stack;
    }

    public void handleBuildingOverBlock(@NotNull BlockPos pos) {
        List<ItemStack> items = BlockPosUtil.getBlockDrops(this.world, pos, 0);
        for (ItemStack item : items) {
            InventoryUtils.addItemStackToItemHandler((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()), item);
        }
    }

    public void handleTileEntityPlacement(@NotNull BlockPos pos) {
    }

    public void resetCurrentStructure() {
        this.workFrom = null;
        this.currentStructure = null;
    }

    private Boolean spawnEntity(@NotNull Structure.StructureBlock currentBlock) {
        Template.EntityInfo entityInfo = currentBlock.entity;
        if (entityInfo == null) {
            return true;
        }
        this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TextComponentTranslation("com.minecolonies.coremod.status.spawning", new Object[0])});
        Entity entity = ItemStackUtils.getEntityFromEntityInfoOrNull(entityInfo, this.world);
        if (entity != null && !AbstractEntityAIStructure.isEntityAtPosition(entity, this.world)) {
            ArrayList<ItemStack> request = new ArrayList<ItemStack>();
            if (entity instanceof EntityItemFrame) {
                ItemStack stack = ((EntityItemFrame)entity).func_82335_i();
                if (!ItemStackUtils.isEmpty(stack).booleanValue()) {
                    ItemStackUtils.changeSize(stack, 1);
                    request.add(stack);
                }
                request.add(new ItemStack(Items.field_151160_bD, 1));
            } else if (entity instanceof EntityArmorStand) {
                request.add(entity.getPickedResult(new RayTraceResult((Entity)this.worker)));
                entity.func_184193_aE().forEach(request::add);
                entity.func_184214_aD().forEach(request::add);
            } else {
                request.add(entity.getPickedResult(new RayTraceResult((Entity)this.worker)));
            }
            if (!Configurations.gameplay.builderInfiniteResources) {
                if (PlacementHandlers.checkForListInInvAndRequest(this, new ArrayList<ItemStack>(request))) {
                    return false;
                }
                for (ItemStack stack : request) {
                    int slot;
                    if (ItemStackUtils.isEmpty(stack).booleanValue() || (slot = this.worker.getCitizenInventoryHandler().findFirstSlotInInventoryWith(stack.func_77973_b(), stack.func_77952_i())) == -1) continue;
                    new InvWrapper((IInventory)this.getInventory()).extractItem(slot, 1, false);
                    this.reduceNeededResources(stack);
                }
            }
            entity.func_184221_a(UUID.randomUUID());
            entity.func_70012_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70177_z, entity.field_70125_A);
            if (!this.world.func_72838_d(entity)) {
                Log.getLogger().info("Failed to spawn entity");
            }
        }
        return true;
    }

    private static boolean isEntityAtPosition(Entity entity, World world) {
        return !world.func_72872_a(entity.getClass(), new AxisAlignedBB(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v)).isEmpty();
    }

    public EntityCitizen getWorker() {
        return this.worker;
    }

    public int getRotation() {
        return this.rotation;
    }

    public void addWayPoint(BlockPos pos) {
        this.worker.getCitizenColonyHandler().getColony().addWayPoint(pos, this.world.func_180495_p(pos));
    }
}

