/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity;

import com.minecolonies.api.util.CompatibilityUtils;
import com.minecolonies.coremod.client.render.RenderBipedCitizen;
import com.minecolonies.coremod.util.SoundUtils;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.INpc;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemShield;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractEntityCitizen
extends EntityAgeable
implements INpc {
    public static final DataParameter<Integer> DATA_LEVEL = EntityDataManager.func_187226_a(AbstractEntityCitizen.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> DATA_TEXTURE = EntityDataManager.func_187226_a(AbstractEntityCitizen.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> DATA_IS_FEMALE = EntityDataManager.func_187226_a(AbstractEntityCitizen.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> DATA_COLONY_ID = EntityDataManager.func_187226_a(AbstractEntityCitizen.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> DATA_CITIZEN_ID = EntityDataManager.func_187226_a(AbstractEntityCitizen.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<String> DATA_MODEL = EntityDataManager.func_187226_a(AbstractEntityCitizen.class, (DataSerializer)DataSerializers.field_187194_d);
    public static final DataParameter<String> DATA_RENDER_METADATA = EntityDataManager.func_187226_a(AbstractEntityCitizen.class, (DataSerializer)DataSerializers.field_187194_d);
    public static final DataParameter<Boolean> DATA_IS_ASLEEP = EntityDataManager.func_187226_a(AbstractEntityCitizen.class, (DataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<BlockPos> DATA_BED_POS = EntityDataManager.func_187226_a(AbstractEntityCitizen.class, (DataSerializer)DataSerializers.field_187200_j);
    private RenderBipedCitizen.Model modelId = RenderBipedCitizen.Model.SETTLER;
    private int textureId;
    private String renderMetadata;
    private boolean female;
    private ResourceLocation texture;

    public AbstractEntityCitizen(World world) {
        super(world);
    }

    @Nullable
    public Entity func_184204_a(int dimensionIn) {
        return null;
    }

    @NotNull
    public BlockPos func_180425_c() {
        return new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    @NotNull
    public EnumActionResult func_184199_a(EntityPlayer player, Vec3d vec, EnumHand hand) {
        SoundUtils.playInteractionSoundAtCitizenWithChance(CompatibilityUtils.getWorld((Entity)this), this.func_180425_c(), 100, this);
        return super.func_184199_a(player, vec, hand);
    }

    public boolean func_175446_cd() {
        return false;
    }

    public RenderBipedCitizen.Model getModelID() {
        return this.modelId;
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }

    public void setTexture() {
        if (!CompatibilityUtils.getWorld((Entity)this).field_72995_K) {
            return;
        }
        RenderBipedCitizen.Model model = this.getModelID();
        String textureBase = "textures/entity/" + model.textureBase + (this.female ? "Female" : "Male");
        int moddedTextureId = this.textureId % model.numTextures + 1;
        this.texture = new ResourceLocation("minecolonies", textureBase + moddedTextureId + this.renderMetadata + ".png");
    }

    public EntityAgeable func_90011_a(@NotNull EntityAgeable child) {
        return null;
    }

    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_TEXTURE, (Object)0);
        this.field_70180_af.func_187214_a(DATA_LEVEL, (Object)0);
        this.field_70180_af.func_187214_a(DATA_IS_FEMALE, (Object)0);
        this.field_70180_af.func_187214_a(DATA_MODEL, (Object)RenderBipedCitizen.Model.SETTLER.name());
        this.field_70180_af.func_187214_a(DATA_RENDER_METADATA, (Object)"");
        this.field_70180_af.func_187214_a(DATA_IS_ASLEEP, (Object)false);
        this.field_70180_af.func_187214_a(DATA_BED_POS, (Object)new BlockPos(0, 0, 0));
    }

    public boolean isFemale() {
        return this.female;
    }

    public void setFemale(boolean female) {
        this.female = female;
    }

    public void setTextureId(int textureId) {
        this.textureId = textureId;
    }

    public void setRenderMetadata(String renderMetadata) {
        this.renderMetadata = renderMetadata;
    }

    public String getRenderMetadata() {
        return this.renderMetadata;
    }

    protected void func_175445_a(EntityItem itemEntity) {
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(100.0);
    }

    public Random getRandom() {
        return this.field_70146_Z;
    }

    public int getOffsetTicks() {
        return this.field_70173_aa + 7 * this.func_145782_y();
    }

    public boolean func_184585_cz() {
        return this.func_184607_cu().func_77973_b() instanceof ItemShield;
    }

    protected void func_184231_a(double y, boolean onGroundIn, @NotNull IBlockState state, @NotNull BlockPos pos) {
        if (!this.field_70122_E) {
            int px = MathHelper.func_76128_c((double)this.field_70165_t);
            int py = (int)this.field_70163_u;
            int pz = MathHelper.func_76128_c((double)this.field_70161_v);
            this.field_70122_E = CompatibilityUtils.getWorld((Entity)this).func_180495_p(new BlockPos(px, py, pz)).func_177230_c().isLadder(this.field_70170_p.func_180495_p(new BlockPos(px, py, pz)), (IBlockAccess)this.field_70170_p, new BlockPos(px, py, pz), (EntityLivingBase)this);
        }
        super.func_184231_a(y, onGroundIn, state, pos);
    }

    public void setOwnRotation(float yaw, float pitch) {
        this.func_70101_b(yaw, pitch);
    }

    public void setModelId(RenderBipedCitizen.Model model) {
        this.modelId = model;
    }

    public void updateArmSwingProg() {
        this.func_82168_bl();
    }

    public int getTextureId() {
        return this.textureId;
    }

    public int getRecentlyHit() {
        return this.field_70718_bc;
    }

    public boolean checkCanDropLoot() {
        return this.func_146066_aG();
    }
}

