/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.commands.colonycommands;

import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.commands.AbstractSingleCommand;
import com.minecolonies.coremod.commands.ActionMenuState;
import com.minecolonies.coremod.commands.IActionCommand;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import org.jetbrains.annotations.NotNull;

public class DisableBarbarianSpawnsCommand
extends AbstractSingleCommand
implements IActionCommand {
    public static final String DESC = "barbarians";
    private static final String NO_ARGUMENTS = "Please define a colony";
    private static final String NO_COLONY_WITH_ID_FOUND_MESSAGE = "Colony with ID %d not found.";
    private static final String NO_COLONY_FOUND_MESSAGE = "Colony not found.";

    public DisableBarbarianSpawnsCommand() {
        super(new String[0]);
    }

    public DisableBarbarianSpawnsCommand(String ... parents) {
        super(parents);
    }

    @Override
    @NotNull
    public String getCommandUsage(@NotNull ICommandSender sender) {
        return super.getCommandUsage(sender) + "<ColonyId> <true|false>";
    }

    @Override
    public void execute(@NotNull MinecraftServer server, @NotNull ICommandSender sender, @NotNull ActionMenuState actionMenuState) throws CommandException {
        boolean canHaveBarbEvents;
        Colony colony = actionMenuState.getColonyForArgument("colony");
        boolean bl = canHaveBarbEvents = !actionMenuState.getBooleanValueForArgument("disableSpawns", true);
        if (colony == null) {
            String noColonyFoundMessage = String.format(NO_COLONY_FOUND_MESSAGE, new Object[0]);
            sender.func_145747_a((ITextComponent)new TextComponentString(noColonyFoundMessage));
            return;
        }
        this.executeShared(server, sender, colony, canHaveBarbEvents);
    }

    @Override
    public void execute(@NotNull MinecraftServer server, @NotNull ICommandSender sender, String ... args) throws CommandException {
        int colonyId;
        Colony colony;
        if (args.length == 0) {
            sender.func_145747_a((ITextComponent)new TextComponentString(NO_ARGUMENTS));
        }
        if ((colony = ColonyManager.getColony(colonyId = DisableBarbarianSpawnsCommand.getIthArgument(args, 0, -1))) == null) {
            String noColonyFoundMessage = String.format(NO_COLONY_WITH_ID_FOUND_MESSAGE, colonyId);
            sender.func_145747_a((ITextComponent)new TextComponentString(noColonyFoundMessage));
            return;
        }
        boolean canHaveBarbEvents = Boolean.parseBoolean(args[1]);
        this.executeShared(server, sender, colony, canHaveBarbEvents);
    }

    private void executeShared(@NotNull MinecraftServer server, @NotNull ICommandSender sender, @NotNull Colony colony, boolean canHaveBarbEvents) throws CommandException {
        if (sender instanceof EntityPlayer && !DisableBarbarianSpawnsCommand.isPlayerOpped(sender)) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Must be OP to use this command"));
        }
        colony.getBarbManager().setCanHaveBarbEvents(canHaveBarbEvents);
        colony.markDirty();
        sender.func_145747_a((ITextComponent)new TextComponentString("Colony \" Can have Barbarian Events \" now set to: " + colony.isCanHaveBarbEvents()));
    }

    @Override
    @NotNull
    public List<String> getTabCompletionOptions(@NotNull MinecraftServer server, @NotNull ICommandSender sender, @NotNull String[] args, @Nullable BlockPos pos) {
        return Collections.emptyList();
    }

    @Override
    public boolean isUsernameIndex(@NotNull String[] args, int index) {
        return false;
    }
}

