/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.commands.colonycommands;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.permissions.Rank;
import com.minecolonies.api.util.CompatibilityUtils;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.commands.AbstractSingleCommand;
import com.minecolonies.coremod.commands.ActionMenuState;
import com.minecolonies.coremod.commands.IActionCommand;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import org.jetbrains.annotations.NotNull;

public class DeleteColonyCommand
extends AbstractSingleCommand
implements IActionCommand {
    public static final String DESC = "delete";
    private static final String DELETE_COLONY_CONFIRM_DELETE_COMMAND_SUGGESTED = "/mc colony delete colony: %d canDestroy: %s confirmDelete: true";

    public DeleteColonyCommand() {
        super(new String[0]);
    }

    public DeleteColonyCommand(String ... parents) {
        super(parents);
    }

    @Override
    @NotNull
    public String getCommandUsage(@NotNull ICommandSender sender) {
        return super.getCommandUsage(sender) + "<ColonyId|OwnerName>";
    }

    @Override
    public boolean canRankUseCommand(@NotNull Colony colony, @NotNull EntityPlayer player) {
        return colony.getPermissions().getRank(player).equals((Object)Rank.OWNER);
    }

    @Override
    public void execute(@NotNull MinecraftServer server, @NotNull ICommandSender sender, @NotNull ActionMenuState actionMenuState) throws CommandException {
        Colony colony = actionMenuState.getColonyForArgument("colony");
        boolean canDestroy = actionMenuState.getBooleanValueForArgument("canDestroy", true);
        boolean confirmDelete = actionMenuState.getBooleanValueForArgument("confirmDelete", false);
        if (colony == null) {
            String noColonyFoundMessage = String.format("Invalid colony, aborting!", new Object[0]);
            sender.func_145747_a((ITextComponent)new TextComponentString(noColonyFoundMessage));
            return;
        }
        this.executeShared(server, sender, colony, canDestroy, confirmDelete);
    }

    @Override
    public void execute(@NotNull MinecraftServer server, @NotNull ICommandSender sender, String ... args) throws CommandException {
        int colonyId;
        IColony colony;
        boolean canDestroy = true;
        boolean confirmDelete = false;
        if (args.length == 0) {
            colony = null;
            if (sender instanceof EntityPlayer) {
                colony = ColonyManager.getIColonyByOwner(CompatibilityUtils.getWorld((Entity)((EntityPlayer)sender)), (EntityPlayer)sender);
            }
            if (colony == null) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Invalid colony, aborting!"));
                return;
            }
            colonyId = colony.getID();
        } else {
            colonyId = DeleteColonyCommand.getIthArgument(args, 0, -1);
            if (args.length > 1) {
                canDestroy = Boolean.parseBoolean(args[1]);
            }
            if (args.length > 2) {
                confirmDelete = Boolean.parseBoolean(args[2]);
            }
        }
        colony = ColonyManager.getColony(colonyId);
        if (colony == null) {
            String noColonyFoundMessage = String.format("Couldn't find colony %d.", colonyId);
            sender.func_145747_a((ITextComponent)new TextComponentString(noColonyFoundMessage));
            return;
        }
        this.executeShared(server, sender, (Colony)colony, canDestroy, confirmDelete);
    }

    private void executeShared(@NotNull MinecraftServer server, @NotNull ICommandSender sender, Colony colony, boolean canDestroy, boolean confirmDelete) throws CommandException {
        EntityPlayer player;
        if (!confirmDelete) {
            ITextComponent deleteButton = new TextComponentString("[DELETE]").func_150255_a(new Style().func_150227_a(Boolean.valueOf(true)).func_150238_a(TextFormatting.GOLD).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, String.format(DELETE_COLONY_CONFIRM_DELETE_COMMAND_SUGGESTED, colony.getID(), canDestroy ? "true" : "false"))));
            sender.func_145747_a((ITextComponent)new TextComponentString("Click [DELETE] to confirm the deletion of colony: " + colony.getID()));
            sender.func_145747_a(deleteButton);
            return;
        }
        Entity senderEntity = sender.func_174793_f();
        if (senderEntity instanceof EntityPlayer && !this.canPlayerUseCommand(player = (EntityPlayer)sender, AbstractSingleCommand.Commands.DELETECOLONY, colony.getID())) {
            sender.func_145747_a((ITextComponent)new TextComponentString("You are not allowed to do that!"));
            return;
        }
        boolean shouldDestroy = canDestroy;
        server.func_152344_a(() -> ColonyManager.deleteColony(colony.getID(), shouldDestroy));
        sender.func_145747_a((ITextComponent)new TextComponentString("Delete colony task scheduled."));
    }

    @Override
    @NotNull
    public List<String> getTabCompletionOptions(@NotNull MinecraftServer server, @NotNull ICommandSender sender, @NotNull String[] args, @Nullable BlockPos pos) {
        return Collections.emptyList();
    }

    @Override
    public boolean isUsernameIndex(@NotNull String[] args, int index) {
        return index == 0 && args.length > 0 && !args[0].isEmpty() && DeleteColonyCommand.getIthArgument(args, 0, Integer.MAX_VALUE) == Integer.MAX_VALUE;
    }
}

