/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.commands.colonycommands;

import com.minecolonies.api.configuration.Configurations;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.commands.AbstractSingleCommand;
import com.minecolonies.coremod.commands.ActionMenuState;
import com.minecolonies.coremod.commands.IActionCommand;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.chunk.Chunk;
import org.jetbrains.annotations.NotNull;

public class ClaimChunksCommand
implements IActionCommand {
    public static final String DESC = "claim";

    @Override
    public void execute(@NotNull MinecraftServer server, @NotNull ICommandSender sender, @NotNull ActionMenuState actionMenuState) throws CommandException {
        if (sender instanceof EntityPlayerMP && AbstractSingleCommand.isPlayerOpped(sender)) {
            Colony colony = actionMenuState.getColonyForArgument("colony");
            if (colony == null) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Invalid colony, aborting!"));
                return;
            }
            int range = actionMenuState.getIntValueForArgument("range", Configurations.gameplay.workingRangeTownHallChunks);
            Boolean add = actionMenuState.getBooleanForArgument("add");
            Chunk chunk = ((EntityPlayerMP)sender).func_71121_q().func_175726_f(sender.func_180425_c());
            ColonyManager.claimChunksInRange(colony.getID(), colony.getDimension(), add == null ? true : add, chunk.field_76635_g, chunk.field_76647_h, range, 0, sender.func_130014_f_());
            sender.func_145747_a((ITextComponent)new TextComponentString("Succesfully claimed chunks in every direction"));
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentString("You do not have permission to claim land like that!"));
        }
    }
}

